; 2003.12.29 - port to protected mode
; parameters

_ParamSize    equ 0 ;  <parameter name size>
_PParam       equ 2 ;  <pointer to parameter name>
_ValueSize    equ 6 ;  <parameter value size>
_PValue       equ 8 ;  <pointer to parameter value>

; available functions

_StrToOem     equ 0Ch ; Procedure StrToOem(Src,Dst:Pointer;Count:Word);
_OemToStr     equ 10h ; Procedure OemToStr(Src,Dst:Pointer;Count:Word);
_OemLow       equ 14h ; Procedure OemLow(Src,Dst:Pointer;Count:Word);
_OemUp        equ 18h ; Procedure OemUp(Src,Dst:Pointer;Count:Word);
_StrToUnicode equ 1Ch ; Procedure StrToUnicode(Src,Dst:Pointer;Count:Word);
_UnicodeToStr equ 20h ; Procedure UnicodeToStr(Src,Dst:Pointer;Count:Word);
_MessageBox   equ 24h ; Function MessageBox(Title,Message:String):Pointer;
_Warning      equ 28h ; Function Warning(Message:String;keys:string):Word;
_ScrSave      equ 2Ch ; Function ScrSave(x1,y1,x2,y2:Word):Pointer;
_ScrRest      equ 30h ; Procedure ScrRest(Screen:Pointer);
_GetKey       equ 34h ; Function GetKey:Word;
_GetShiftKey  equ 38h ; Function GetShiftKey:Word;
_KeyPressed   equ 3Ch ; Function KeyPressed:Boolean;

StartUp macro
        or eax,044387E0Ah
        or eax,0A0D0Ah
        pushf
        pusha
        cld
        call @@StartUpSelf
@@StartUpSelf:
        pop  eax
        sub  eax,offset @@StartUpSelf
        mov  ebp,eax
        mov  [ebp][SaveESP],esp
Endm

Return macro result
        mov  esp,[ebp][SaveESP]
        popa
        mov  eax,result
        popf
        retn
Endm

CallEDI macro func
        mov  edi,[ebp][ParamAddr]
        call [edi][func]
Endm

ValueSize macro reg
        mov  reg,[ebp][ParamAddr]
        movzx reg,word ptr[reg][_ValueSize]
Endm

ParamSize macro reg
        mov  reg,[ebp][ParamAddr]
        movzx reg,word ptr[reg][_ParamSize]
Endm

PValue macro reg
        mov  reg,[ebp][ParamAddr]
        mov  reg,[reg][_PValue]
Endm

PParam macro reg
        mov  reg,[ebp][ParamAddr]
        mov  reg,[reg][_PParam]
Endm

StrToOem macro
        CallEDI _StrToOem
Endm

OemToStr macro
        CallEDI _OemToStr
Endm

OemLow macro
        CallEDI _OemLow
Endm

OemUp macro
        CallEDI _OemUp
Endm

StrToUnicode macro
        CallEDI _StrToUnicode
Endm

UnicodeToStr macro
        CallEDI _UnicodeToStr
Endm

MessageBox macro
        CallEDI _MessageBox
Endm

Warning macro
        CallEDI _Warning
Endm

ScrSave macro
        CallEDI _ScrSave
Endm

ScrRest macro
        CallEDI _ScrRest
Endm

GetKey macro
        CallEDI _GetKey
Endm

GetShiftKey macro
        CallEDI _GetShiftKey
Endm

KeyPressed macro
        CallEDI _KeyPressed
Endm
