/*
 *  kexbases\user32\_user32_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2016, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "kexcoresdk.h"
#include "_user32_apilist.h"
#include "thuni_layer.h"

IsHungThread_t IsHungThread_pfn;
DrawCaptionTempA_t DrawCaptionTempA_pfn;

BOOL SetParent_fix_init();

BOOL init_user32()
{
	HMODULE hUser32 = GetModuleHandle("USER32.DLL");
	
	IsHungThread_pfn = (IsHungThread_t)kexGetProcAddress(hUser32, "IsHungThread");
	DrawCaptionTempA_pfn = (DrawCaptionTempA_t)kexGetProcAddress(hUser32, "DrawCaptionTempA");
	GetMouseMovePoints_pfn = (GetMouseMovePoints_t)kexGetProcAddress(hUser32, "GetMouseMovePoints");
	
	return IsHungThread_pfn && DrawCaptionTempA_pfn && GetMouseMovePoints_pfn
			&& InitUniThunkLayer();
}

/* APIs which don't require Unicode implementations in thuni model
 * MAKE_EXPORT CallMsgFilterA=CallMsgFilterW
 * MAKE_EXPORT CopyAcceleratorTableA=CopyAcceleratorTableW
 * MAKE_EXPORT CreateAcceleratorTableA=CreateAcceleratorTableW
 * MAKE_EXPORT DispatchMessageA=DispatchMessageW
 * MAKE_EXPORT IsDialogMessageA=IsDialogMessageW
 * MAKE_EXPORT GetAltTabInfo=GetAltTabInfoA
 * MAKE_EXPORT RealGetWindowClass=RealGetWindowClassA
 * MAKE_EXPORT SetWindowsHookExA=SetWindowsHookExW
 * MAKE_EXPORT SetWindowsHookA=SetWindowsHookW
 * MAKE_EXPORT TranslateAcceleratorA=TranslateAcceleratorW
 */

/* Shell hook APIs. Can be implemented with shell, 
 * but would be too sensitive for cruel world.
 * MAKE_EXPORT IsWindow=DeregisterShellHookWindow
 * MAKE_EXPORT IsWindow=RegisterShellHookWindow
 * jumper: should these be stubbed to return false/fail? *FIXME*
 */

static const apilib_named_api user32_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("AllowSetForegroundWindow", AllowSetForegroundWindow_98),
	DECL_API("AppendMenuW", AppendMenuW_new),
	DECL_API("CalcMenuBar", CalcMenuBar_stub),
	DECL_API("CallMsgFilterW", CallMsgFilterA),
	DECL_API("CallWindowProcA", CallWindowProcA_fix),
	DECL_API("CallWindowProcW", CallWindowProcW_new),
	DECL_API("ChangeMenuW", ChangeMenuW_new),
	DECL_API("ChangeWindowMessageFilter", ChangeWindowMessageFilter_stub),
	DECL_API("CharLowerBuffW", CharLowerBuffW_new),
	DECL_API("CharLowerW", CharLowerW_new),
	DECL_API("CharNextExW", CharNextExW_new),
	DECL_API("CharNextW", CharNextW_new),
	DECL_API("CharPrevExW", CharPrevExW_new),
	DECL_API("CharPrevW", CharPrevW_new),
	DECL_API("CharToOemBuffW", CharToOemBuffW_new),
	DECL_API("CharToOemW", CharToOemW_new),
	DECL_API("CharUpperBuffW", CharUpperBuffW_new),
	DECL_API("CharUpperW", CharUpperW_new),
	DECL_API("CliImmSetHotKey", CliImmSetHotKey_stub),
	DECL_API("CopyAcceleratorTableW", CopyAcceleratorTableA),
	DECL_API("CreateAcceleratorTableW", CreateAcceleratorTableA),
	DECL_API("CreateDialogIndirectParamW", CreateDialogIndirectParamW_new),
	DECL_API("CreateDialogParamW", CreateDialogParamW_new),
	DECL_API("CreateMDIWindowW", CreateMDIWindowW_new),
	DECL_API("CreateWindowExW", CreateWindowExW_new),
	DECL_API("CreateWindowW", CreateWindowW_new),
	DECL_API("DefDlgProcW", DefDlgProcW_new),
	DECL_API("DefFrameProcW", DefFrameProcW_new),
	DECL_API("DefMDIChildProcW", DefMDIChildProcW_new),
	DECL_API("DefRawInputProc", DefRawInputProc_new),
	DECL_API("DefWindowProcW", DefWindowProcW_new),
	DECL_API("DeregisterShellHookWindow", IsWindow),
	DECL_API("DialogBoxIndirectParamW", DialogBoxIndirectParamW_new),
	DECL_API("DialogBoxParamW", DialogBoxParamW_new),
	DECL_API("DisableProcessWindowsGhosting", DisableProcessWindowsGhosting_new),
	DECL_API("DispatchMessageW", DispatchMessageA),
	DECL_API("DrawCaptionTempW", DrawCaptionTempW_new),
	DECL_API("EnableWindow", EnableWindow_fix),
	DECL_API("GetAltTabInfoA", GetAltTabInfo),
	DECL_API("GetAncestor", GetAncestor_fix),
	DECL_API("GetClassInfoExW", GetClassInfoExW_new),
	DECL_API("GetClassInfoW", GetClassInfoW_new),
	DECL_API("GetClassLongW", GetClassLongW_new),
	DECL_API("GetDlgItemTextW", GetDlgItemTextW_new),
	DECL_API("GetLastInputInfo", GetLastInputInfo_new),
	DECL_API("GetLayeredWindowAttributes", GetLayeredWindowAttributes_stub),
	DECL_API("GetMessageA", GetMessageA_fix),
	DECL_API("GetMessageW", GetMessageW_new),
	DECL_API("GetMouseMovePointsEx", GetMouseMovePointsEx_98),
	DECL_API("GetNextDlgTabItem", GetNextDlgTabItem_fix),
	DECL_API("GetRawInputBuffer", GetRawInputBuffer_new),
	DECL_API("GetRawInputData", GetRawInputData_new),
	DECL_API("GetRawInputDeviceInfoA", GetRawInputDeviceInfo_new),
	DECL_API("GetRawInputDeviceInfoW", GetRawInputDeviceInfo_new),
	DECL_API("GetRawInputDeviceList", GetRawInputDeviceList_new),
	DECL_API("GetRegisteredRawInputDevices", GetRegisteredRawInputDevices_new),
	DECL_API("GetWindowLongA", GetWindowLongA_fix),
	DECL_API("GetWindowLongW", GetWindowLongW_new),
	DECL_API("GetWindowRgnBox", GetWindowRgnBox_stub),
	DECL_API("GetWindowTextLengthW", GetWindowTextLengthW_new),
	DECL_API("GetWindowTextW", GetWindowTextW_new),
	DECL_API("InitSharedTable", InitSharedTable_stub),
	DECL_API("InsertMenuW", InsertMenuW_new),
	DECL_API("IsCharAlphaNumericW", IsCharAlphaNumericW_new),
	DECL_API("IsCharAlphaW", IsCharAlphaW_new),
	DECL_API("IsCharLowerW", IsCharLowerW_new),
	DECL_API("IsCharUpperW", IsCharUpperW_new),
	DECL_API("IsDialogMessageW", IsDialogMessageA),
	DECL_API("IsHungAppWindow", IsHungAppWindow_new),
	DECL_API("IsServerSideWindow", IsServerSideWindow_stub),
	DECL_API("IsWinEventHookInstalled", IsWinEventHookInstalled_stub),
	DECL_API("IsWindowInDestroy", IsWindowInDestroy_stub),
	DECL_API("IsWindowUnicode", IsWindowUnicode_new),
	DECL_API("LoadMenuA", LoadMenuA_fix),
	DECL_API("LoadMenuIndirectW", LoadMenuIndirectA),
	DECL_API("LoadMenuW", LoadMenuW_new),
	DECL_API("LoadStringW", LoadStringW_new),
	DECL_API("LockSetForegroundWindow", LockSetForegroundWindow_98),
	DECL_API("LockWorkStation", LockWorkStation_new),
	DECL_API("MBToWCSEx", MBToWCSEx_new),
	DECL_API("MapVirtualKeyA", MapVirtualKeyA_new),
	DECL_API("MapVirtualKeyExA", MapVirtualKeyExA_new),
	DECL_API("ModifyMenuW", ModifyMenuW_new),
	DECL_API("OemToCharBuffW", OemToCharBuffW_new),
	DECL_API("OemToCharW", OemToCharW_new),
	DECL_API("PeekMessageA", PeekMessageA_fix),
	DECL_API("PeekMessageW", PeekMessageW_new),
	DECL_API("PostMessageW", PostMessageW_new),
	DECL_API("PostThreadMessageW", PostThreadMessageW_new),
	DECL_API("PrintWindow", PrintWindow_stub),
	DECL_API("RealGetWindowClassA", RealGetWindowClass),
	DECL_API("RealGetWindowClassW", RealGetWindowClassW_new),
	DECL_API("RegisterClassExW", RegisterClassExW_new),
	DECL_API("RegisterClassW", RegisterClassW_new),
	DECL_API("RegisterPowerSettingNotification", RegisterPowerSettingNotification_stub),
	DECL_API("RegisterRawInputDevices", RegisterRawInputDevices_new),
	DECL_API("RegisterServicesProcess", RegisterServicesProcess_stub),
	DECL_API("RegisterShellHookWindow", IsWindow),
	DECL_API("SendDlgItemMessageW", SendDlgItemMessageW_new),
	DECL_API("SendMessageA", SendMessageA_fix),
	DECL_API("SendMessageCallbackW", SendMessageCallbackW_new),
	DECL_API("SendMessageTimeoutW", SendMessageTimeoutW_new),
	DECL_API("SendMessageW", SendMessageW_new),
	DECL_API("SendNotifyMessageW", SendNotifyMessageW_new),
	DECL_API("SetClassLongW", SetClassLongW_new),
	DECL_API("SetDlgItemTextW", SetDlgItemTextW_new),
	DECL_API("SetLayeredWindowAttributes", SetLayeredWindowAttributes_stub),
	DECL_API("SetParent", SetParent_fix),
	DECL_API("SetProcessDPIAware", SetProcessDPIAware_stub),
	DECL_API("SetProcessDPIAware1", SetProcessDPIAware1_stub),
	DECL_API("SetWindowLongA", SetWindowLongA_fix),
	DECL_API("SetWindowLongW", SetWindowLongW_new),
	DECL_API("SetWindowTextW", SetWindowTextW_new),
	DECL_API("SetWindowsHookExW", SetWindowsHookExA),
	DECL_API("SetWindowsHookW", SetWindowsHookA),
	DECL_API("SystemParametersInfoA", SystemParametersInfoA_fix),
	DECL_API("ToUnicode", ToUnicode_new),
	DECL_API("ToUnicodeEx", ToUnicodeEx_new),
	DECL_API("TranslateAcceleratorW", TranslateAcceleratorA),
	DECL_API("UnregisterClassW", UnregisterClassW_new),
	DECL_API("UnregisterPowerSettingNotification", UnregisterPowerSettingNotification_stub),
	DECL_API("UpdateLayeredWindow", UpdateLayeredWindow_new),
	DECL_API("User32InitializeImmEntryTable", User32InitializeImmEntryTable_stub),
	DECL_API("UserHandleGrantAccess", UserHandleGrantAccess_stub),
	DECL_API("UserRealizePalette", UserRealizePalette_stub),
	DECL_API("WCSToMBEx", WCSToMBEx_new),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef user32_ordinal_apis
static const apilib_unnamed_api user32_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_user32 = 
  DECL_TAB("USER32.DLL", user32_named_apis, user32_ordinal_apis);
