/*
 *  kexbases\shell32\_shell32_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2016, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "common.h"
#include "kexcoresdk.h"
#include "_shell32_apilist.h"
#include "../kernel32/_kernel32_apilist.h"

BOOL init_shell32()
{
	return TRUE;
}


/*
 * MAKE_EXPORT GetDiskFreeSpaceExA_fix=SHGetDiskFreeSpaceA
 * MAKE_EXPORT GetDiskFreeSpaceExA_fix=SHGetDiskFreeSpaceExA
 * MAKE_EXPORT GetDiskFreeSpaceExW_new=SHGetDiskFreeSpaceExW
 */

/* MAKE_EXPORT SHGetImageList_stub=ordinal727 ;IE7 IEFrame.dll */
/* MAKE_EXPORT SHLimitInputEdit_stub=ordinal747 ;IE7 IEFrame.dll */
/* MAKE_EXPORT SHPropStgCreate_stub=ordinal685 ;IE7 URLmon.dll */
/* MAKE_EXPORT SHPropStgReadMultiple_stub=ordinal688 ;IE7 URLmon.dll */
/* MAKE_EXPORT SHPropStgWriteMultiple_stub=ordinal689 ;IE7 URLmon.dll */


static const apilib_named_api shell32_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("CommandLineToArgvW", CommandLineToArgvW_new),
	DECL_API("ILAppendID", ILAppendID_stub),
	DECL_API("ILClone", ILClone_stub),
	DECL_API("ILCloneFirst", ILCloneFirst_stub),
	DECL_API("ILCombine", ILCombine_stub),
	DECL_API("ILCreateFromPathW", ILCreateFromPathW_stub),
	DECL_API("ILFindChild", ILFindChild_stub),
	DECL_API("ILFindLastID", ILFindLastID_stub),
	DECL_API("ILFree", ILFree_stub),
	DECL_API("ILGetNext", ILGetNext_stub),
	DECL_API("ILGetSize", ILGetSize_stub),
	DECL_API("ILIsEqual", ILIsEqual_stub),
	DECL_API("ILIsParent", ILIsParent_stub),
	DECL_API("ILLoadFromStream", ILLoadFromStream_stub),
	DECL_API("ILRemoveLastID", ILRemoveLastID_stub),
	DECL_API("ILSaveToStream", ILSaveToStream_stub),
	DECL_API("IsUserAnAdmin", IsUserAnAdmin_new),
	DECL_API("PathCleanupSpec", PathCleanupSpec_stub),
	DECL_API("SHCloneSpecialIDList", SHCloneSpecialIDList_stub),
	DECL_API("SHCoCreateInstance", SHCoCreateInstance_stub),
	DECL_API("SHCreateItemFromParsingName", SHCreateItemFromParsingName_stub),
	DECL_API("SHCreateShellItem", SHCreateShellItem_stub),
	DECL_API("SHDefExtractIconW", SHDefExtractIconW_stub),
	DECL_API("SHEnumerateUnreadMailAccountsW", SHEnumerateUnreadMailAccountsW_stub),
	DECL_API("SHExtractIconsW", SHExtractIconsW_stub),
	DECL_API("SHFindFiles", SHFindFiles_stub),
	DECL_API("SHGetDiskFreeSpaceA", GetDiskFreeSpaceExA_fix),
	DECL_API("SHGetDiskFreeSpaceExA", GetDiskFreeSpaceExA_fix),
	DECL_API("SHGetDiskFreeSpaceExW", GetDiskFreeSpaceExW_new),
	DECL_API("SHGetFolderPathAndSubDirW", SHGetFolderPathAndSubDirW_stub),
	DECL_API("SHGetIconOverlayIndexW", SHGetIconOverlayIndexW_stub),
	DECL_API("SHGetImageList", SHGetImageList_stub),
	DECL_API("SHGetKnownFolderPath", SHGetKnownFolderPath_stub),
	DECL_API("SHLimitInputEdit", SHLimitInputEdit_stub),
	DECL_API("SHOpenFolderAndSelectItems", SHOpenFolderAndSelectItems_stub),
	DECL_API("SHOpenWithDialog", SHOpenWithDialog_stub),
	DECL_API("SHPathPrepareForWriteW", SHPathPrepareForWriteW_stub),
	DECL_API("SHPropStgCreate", SHPropStgCreate_stub),
	DECL_API("SHPropStgReadMultiple", SHPropStgReadMultiple_stub),
	DECL_API("SHPropStgWriteMultiple", SHPropStgWriteMultiple_stub),
	DECL_API("SHQueryUserNotificationState", SHQueryUserNotificationState_stub),
	DECL_API("SHRestricted", SHRestricted_stub),
	DECL_API("SHSetLocalizedName", SHSetLocalizedName_stub),
	DECL_API("SHSetUnreadMailCountW", SHSetUnreadMailCountW_stub),
	DECL_API("Shell_NotifyIconGetRect", Shell_NotifyIconGetRect_stub),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

static const apilib_unnamed_api shell32_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
	DECL_API(680, IsUserAnAdmin_new),
	DECL_API(685, SHPropStgCreate_stub),
	DECL_API(688, SHPropStgReadMultiple_stub),
	DECL_API(689, SHPropStgWriteMultiple_stub),
	DECL_API(727, SHGetImageList_stub),
	DECL_API(747, SHLimitInputEdit_stub),
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};

const apilib_api_table apitable_shell32 = 
  DECL_TAB("SHELL32.DLL", shell32_named_apis, shell32_ordinal_apis);
