/*
 *  kexbases\ntdll\_ntdll_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2019, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "_ntdll_apilist.h"
#include "../kernel32/_kernel32_apilist.h"
#include "../advapi32/_advapi32_apilist.h"

BOOL init_ntdll()
{
	return TRUE;
}


/*

LdrGetProcedureAddress=LdrGetProcedureAddress  ;ie7
NtDeleteKey=NtDeleteKey  ;R041
NtQueryVolumeInformationFile=NtQueryVolumeInformationFile
RtlInterlockedCompareExchange64=RtlInterlockedCompareExchange64
 * MAKE~EXPORT InterlockedFlushSList_stub=RtlInterlockedFlushSList
RtlIsCriticalSectionLockedByThread=RtlIsCriticalSectionLockedByThread
RtlRunEncodeUnicodeString=RtlRunEncodeUnicodeString
RtlRunDecodeUnicodeString=RtlRunDecodeUnicodeString


  Fls is Vista?
 * MAKE~EXPORT FlsAlloc_stub=FlsAlloc
 * MAKE~EXPORT FlsFree_stub=FlsFree
 * MAKE~EXPORT FlsGetValue_stub=FlsGetValue
 * MAKE~EXPORT FlsSetValue_stub=FlsSetValue
*/

/* Kernel32.dll
  MAKEEXPORT FillMemory=RtlFillMemory
  MAKEEXPORT MoveMemory=RtlMoveMemory
  MAKEEXPORT ZeroMemory=RtlZeroMemory
*/

/* kernel32\CriticalSection_fix.c redirects
  MAKE~EXPORT DeleteCriticalSection_fix=RtlDeleteCriticalSection
  MAKE~EXPORT EnterCriticalSection_fix=RtlEnterCriticalSection
  MAKE~EXPORT InitializeCriticalSectionAndSpinCount_new=RtlInitializeCriticalSectionAndSpinCount
  MAKE~EXPORT LeaveCriticalSection_fix=RtlLeaveCriticalSection
  MAKE_EXPORT SetCriticalSectionSpinCount_new=RtlSetCriticalSectionSpinCount

  DWORD WINAPI SetCriticalSectionSpinCount_new(LPCRITICAL_SECTION lpCriticalSection, DWORD dwSpinCount);
  void WINAPI EnterCriticalSection_fix(LPCRITICAL_SECTION lpCriticalSection);
  void WINAPI LeaveCriticalSection_fix(LPCRITICAL_SECTION lpCriticalSection);
  void WINAPI DeleteCriticalSection_fix(LPCRITICAL_SECTION lpCriticalSection);
*/

/* kernel32\unikernel32.c redirects
  MAKE_EXPORT GetCurrentDirectoryW_new=RtlGetCurrentDirectory_U
*/

/* kernel32\_kernel32_stubs.c redirects
  MAKE_EXPORT RtlCaptureStackBackTrace_stub=RtlCaptureStackBackTrace *Kernel32 mirror*
*/

/* ntdll\_ntdll_stubs.c redirects
  MAKE_EXPORT NtConnectPort_stub=ZwConnectPort
*/

/* kernel32\SList.c redirects
  MAKE_EXPORT RtlFirstEntrySList_new=RtlFirstEntrySList
  MAKE_EXPORT InitializeSListHead_new=RtlInitializeSListHead
  MAKE_EXPORT InterlockedFlushSList_new=RtlInterlockedFlushSList
  MAKE_EXPORT InterlockedPopEntrySList_new=RtlInterlockedPopEntrySList
  MAKE_EXPORT InterlockedPushEntrySList_new=RtlInterlockedPushEntrySList
  MAKE_EXPORT InterlockedPushListSList_new=RtlInterlockedPushListSList
  MAKE_EXPORT InterlockedPushListSListEx_new=RtlInterlockedPushListSListEx
  MAKE_EXPORT QueryDepthSList_new=RtlQueryDepthSList
*/

/* kernel32\version.c redirects **
  MAKE_EXPORT GetVersionExW_ORIG=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN95=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN98SE=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WINME=RtlGetVersion
  MAKE_EXPORT GetVersionExW_NT40G=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN2000D=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WINXP2=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN2003A=RtlGetVersion
  MAKE_EXPORT GetVersionExW_VISTA=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN2008A=RtlGetVersion
  MAKE_EXPORT GetVersionExW_VISTA2=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN7A=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN8=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN81=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN10=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN10A=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN98=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WINXP=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WINXP3=RtlGetVersion
  MAKE_EXPORT VerifyVersionInfoW_WIN2000D=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WINXP2=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN2003A=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_VISTA=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN2008A=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_VISTA2=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN7A=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN8=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN81=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN10=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN10A=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WINXP=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WINXP3=RtlVerifyVersionInfo
  MAKE_EXPORT VerSetConditionMask_new=VerSetConditionMask
*/


static const apilib_named_api ntdll_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("CsrGetProcessId", CsrGetProcessId_stub),
	DECL_API("DbgPrintEx", DbgPrintEx_stub),
	DECL_API("LdrAccessResource", LdrAccessResource_stub),
	DECL_API("LdrFindResource_U", LdrFindResource_U_stub),
	DECL_API("LdrLoadDll", LdrLoadDll_stub),
	DECL_API("LdrUnloadDll", LdrUnloadDll_stub),
	DECL_API("NtAcceptConnectPort", NtAcceptConnectPort_stub),
	DECL_API("NtAccessCheck", NtAccessCheck_fwd),
	DECL_API("NtAccessCheckAndAuditAlarm", NtAccessCheckAndAuditAlarm_fwd),
	DECL_API("NtAdjustGroupsToken", NtAdjustGroupsToken_fwd),
	DECL_API("NtAdjustPrivilegesToken", NtAdjustPrivilegesToken_fwd),
	DECL_API("NtAllocateLocallyUniqueId", NtAllocateLocallyUniqueId_fwd),
	DECL_API("NtAllocateVirtualMemory", NtAllocateVirtualMemory_new),
	DECL_API("NtClose", NtClose_new),
	DECL_API("NtCloseObjectAuditAlarm", NtCloseObjectAuditAlarm_fwd),
	DECL_API("NtCompleteConnectPort", NtCompleteConnectPort_stub),
	DECL_API("NtConnectPort", NtConnectPort_stub),
	DECL_API("NtCreateEvent", NtCreateEvent_stub),
	DECL_API("NtCreateIoCompletion", NtCreateIoCompletion_stub),
	DECL_API("NtCreateKey", NtCreateKey_stub),
	DECL_API("NtCreateNamedPipeFile", NtCreateNamedPipeFile_stub),
	DECL_API("NtCreatePort", NtCreatePort_stub),
	DECL_API("NtCreateProfile", NtCreateProfile_stub),
	DECL_API("NtCreateSection", NtCreateSection_stub),
	DECL_API("NtDeleteObjectAuditAlarm", NtDeleteObjectAuditAlarm_fwd),
	DECL_API("NtDeviceIoControlFile", NtDeviceIoControlFile_stub),
	DECL_API("NtDuplicateToken", NtDuplicateToken_fwd),
	DECL_API("NtListenPort", NtListenPort_stub),
	DECL_API("NtOpenFile", NtOpenFile_stub),
	DECL_API("NtOpenObjectAuditAlarm", NtOpenObjectAuditAlarm_fwd),
	DECL_API("NtOpenProcessToken", NtOpenProcessToken_fwd),
	DECL_API("NtOpenThreadToken", NtOpenThreadToken_fwd),
	DECL_API("NtPrivilegeObjectAuditAlarm", NtPrivilegeObjectAuditAlarm_fwd),
	DECL_API("NtPrivilegedServiceAuditAlarm", NtPrivilegedServiceAuditAlarm_fwd),
	DECL_API("NtQueryAttributesFile", NtQueryAttributesFile_stub),
	DECL_API("NtQueryDirectoryFile", NtQueryDirectoryFile_stub),
	DECL_API("NtQueryInformationFile", NtQueryInformationFile_stub),
	DECL_API("NtQueryInformationProcess", NtQueryInformationProcess_stub),
	DECL_API("NtQueryInformationThread", NtQueryInformationThread_stub),
	DECL_API("NtQueryInformationToken", NtQueryInformationToken_fwd),
	DECL_API("NtQuerySecurityObject", NtQuerySecurityObject_fwd),
	DECL_API("NtQuerySystemInformation", NtQuerySystemInformation_stub),
	DECL_API("NtQuerySystemTime", NtQuerySystemTime_new),
	DECL_API("NtQuerySystemTime", NtQuerySystemTime_stub),
	DECL_API("NtSetInformationProcess", NtSetInformationProcess_stub),
	DECL_API("NtSetInformationToken", NtSetInformationToken_fwd),
	DECL_API("NtSetSecurityObject", NtSetSecurityObject_fwd),
	DECL_API("NtShutdownSystem", NtShutdownSystem_new),
	DECL_API("NtWaitForSingleObject", NtWaitForSingleObject_new),
	DECL_API("RtlAcquireResourceExclusive", RtlAcquireResourceExclusive_stub),
	DECL_API("RtlAcquireResourceShared", RtlAcquireResourceShared_stub),
	DECL_API("RtlAddAccessAllowedAce", RtlAddAccessAllowedAce_fwd),
	DECL_API("RtlAddAccessAllowedAceEx", RtlAddAccessAllowedAceEx_stub),
	DECL_API("RtlAddAccessDeniedAce", RtlAddAccessDeniedAce_fwd),
	DECL_API("RtlAddAccessDeniedAceEx", RtlAddAccessDeniedAceEx_stub),
	DECL_API("RtlAddAce", RtlAddAce_fwd),
	DECL_API("RtlAddAuditAccessAce", RtlAddAuditAccessAce_fwd),
	DECL_API("RtlAdjustPrivilege", RtlAdjustPrivilege),
	DECL_API("RtlAllocateAndInitializeSid", RtlAllocateAndInitializeSid_fwd),
	DECL_API("RtlAppendUnicodeStringToString", RtlAppendUnicodeStringToString_stub),
	DECL_API("RtlAppendUnicodeToString", RtlAppendUnicodeToString_stub),
	DECL_API("RtlAssert", RtlAssert_stub),
	DECL_API("RtlCaptureStackBackTrace", RtlCaptureStackBackTrace_stub),
	DECL_API("RtlCharToInteger", RtlCharToInteger_stub),
	DECL_API("RtlCompareMemory", RtlCompareMemory_stub),
	DECL_API("RtlCompareUnicodeString", RtlCompareUnicodeString_new),
	DECL_API("RtlConvertSidToUnicodeString", RtlConvertSidToUnicodeString_stub),
	DECL_API("RtlCopySid", RtlCopySid),
	DECL_API("RtlCreateEnvironment", RtlCreateEnvironment),
	DECL_API("RtlCreateSecurityDescriptor", RtlCreateSecurityDescriptor),
	DECL_API("RtlCreateTagHeap", RtlCreateTagHeap),
	DECL_API("RtlCreateUnicodeString", RtlCreateUnicodeString_stub),
	DECL_API("RtlCreateUnicodeStringFromAsciiz", RtlCreateUnicodeStringFromAsciiz_stub),
	DECL_API("RtlCreateUserThread", RtlCreateUserThread),
	DECL_API("RtlDeleteAce", RtlDeleteAce_fwd),
	DECL_API("RtlDeleteCriticalSection", RtlDeleteCriticalSection_new),
	DECL_API("RtlDeleteResource", RtlDeleteResource_stub),
	DECL_API("RtlDeleteSecurityObject", RtlDeleteSecurityObject_fwd),
	DECL_API("RtlEnterCriticalSection", RtlEnterCriticalSection_new),
	DECL_API("RtlEqualPrefixSid", RtlEqualPrefixSid_fwd),
	DECL_API("RtlEqualSid", RtlEqualSid_fwd),
	DECL_API("RtlEqualUnicodeString", RtlEqualUnicodeString_new),
	DECL_API("RtlExpandEnvironmentStrings_U", RtlExpandEnvironmentStrings_U_new),
	DECL_API("RtlFirstEntrySList", RtlFirstEntrySList_new),
	DECL_API("RtlFirstFreeAce", RtlFirstFreeAce_fwd),
	DECL_API("RtlFreeAnsiString", RtlFreeString_new),
	DECL_API("RtlFreeOemString", RtlFreeString_new),
	DECL_API("RtlFreeSid", RtlFreeSid),
	DECL_API("RtlFreeUnicodeString", RtlFreeString_new),
	DECL_API("RtlGUIDFromString", RtlGUIDFromString_stub),
	DECL_API("RtlGetAce", RtlGetAce_fwd),
	DECL_API("RtlGetControlSecurityDescriptor", RtlGetControlSecurityDescriptor_fwd),
	DECL_API("RtlGetCurrentDirectory_U", GetCurrentDirectoryW_new),
	DECL_API("RtlGetDaclSecurityDescriptor", RtlGetDaclSecurityDescriptor_fwd),
	DECL_API("RtlGetGroupSecurityDescriptor", RtlGetGroupSecurityDescriptor_fwd),
	DECL_API("RtlGetNtProductType", RtlGetNtProductType_stub),
	DECL_API("RtlGetOwnerSecurityDescriptor", RtlGetOwnerSecurityDescriptor_fwd),
	DECL_API("RtlGetSaclSecurityDescriptor", RtlGetSaclSecurityDescriptor_fwd),
	DECL_API("RtlGetVersion", GetVersionExW_ORIG),
	DECL_API("RtlGetVersion", GetVersionExW_WIN95),
	DECL_API("RtlGetVersion", GetVersionExW_WIN98SE),
	DECL_API("RtlGetVersion", GetVersionExW_WINME),
	DECL_API("RtlGetVersion", GetVersionExW_NT40G),
	DECL_API("RtlGetVersion", GetVersionExW_WIN2000D),
	DECL_API("RtlGetVersion", GetVersionExW_WINXP2),
	DECL_API("RtlGetVersion", GetVersionExW_WIN2003A),
	DECL_API("RtlGetVersion", GetVersionExW_VISTA),
	DECL_API("RtlGetVersion", GetVersionExW_WIN2008A),
	DECL_API("RtlGetVersion", GetVersionExW_VISTA2),
	DECL_API("RtlGetVersion", GetVersionExW_WIN7A),
	DECL_API("RtlGetVersion", GetVersionExW_WIN8),
	DECL_API("RtlGetVersion", GetVersionExW_WIN81),
	DECL_API("RtlGetVersion", GetVersionExW_WIN10),
	DECL_API("RtlGetVersion", GetVersionExW_WIN10A),
	DECL_API("RtlGetVersion", GetVersionExW_WIN98),
	DECL_API("RtlGetVersion", GetVersionExW_WINXP),
	DECL_API("RtlGetVersion", GetVersionExW_WINXP3),
	DECL_API("RtlIdentifierAuthoritySid", RtlIdentifierAuthoritySid_fwd),
	DECL_API("RtlImageRvaToSection", RtlImageRvaToSection_stub),
	DECL_API("RtlImageRvaToVa", RtlImageRvaToVa_stub),
	DECL_API("RtlInitAnsiString", RtlInitString_new),
	DECL_API("RtlInitAnsiStringEx", RtlInitStringEx_new),
	DECL_API("RtlInitOemString", RtlInitString_new),
	DECL_API("RtlInitOemStringEx", RtlInitStringEx_new),
	DECL_API("RtlInitString", RtlInitString_new),
	DECL_API("RtlInitUnicodeString", RtlInitUnicodeString_new),
	DECL_API("RtlInitializeBitMap", RtlInitializeBitMap),
	DECL_API("RtlInitializeCriticalSection", RtlInitializeCriticalSection_new),
	DECL_API("RtlInitializeCriticalSectionAndSpinCount", RtlInitializeCriticalSectionAndSpinCount_new),
	DECL_API("RtlInitializeCriticalSectionEx", RtlInitializeCriticalSectionEx_new),
	DECL_API("RtlInitializeResource", RtlInitializeResource_stub),
	DECL_API("RtlInitializeSListHead", InitializeSListHead_new),
	DECL_API("RtlInitializeSid", RtlInitializeSid),
	DECL_API("RtlInterlockedFlushSList", InterlockedFlushSList_new),
	DECL_API("RtlInterlockedPopEntrySList", InterlockedPopEntrySList_new),
	DECL_API("RtlInterlockedPushEntrySList", InterlockedPushEntrySList_new),
	DECL_API("RtlInterlockedPushListSList", InterlockedPushListSList_new),
	DECL_API("RtlInterlockedPushListSListEx", InterlockedPushListSListEx_new),
	DECL_API("RtlIpv4StringToAddressW", RtlIpv4StringToAddressW_stub),
	DECL_API("RtlLeaveCriticalSection", RtlLeaveCriticalSection_new),
	DECL_API("RtlLengthRequiredSid", RtlLengthRequiredSid),
	DECL_API("RtlLengthSid", RtlLengthSid),
	DECL_API("RtlMultiByteToUnicodeSize", RtlMultiByteToUnicodeSize_new),
	DECL_API("RtlNewSecurityObject", RtlNewSecurityObject_fwd),
	DECL_API("RtlOemToUnicodeN", RtlOemToUnicodeN_new),
	DECL_API("RtlPrefixUnicodeString", RtlPrefixUnicodeString_new),
	DECL_API("RtlQueryDepthSList", QueryDepthSList_new),
	DECL_API("RtlQueryInformationAcl", RtlQueryInformationAcl_fwd),
	DECL_API("RtlQuerySecurityObject", RtlQuerySecurityObject_fwd),
	DECL_API("RtlReleaseResource", RtlReleaseResource_stub),
	DECL_API("RtlSecondsSince1970ToTime", RtlSecondsSince1970ToTime_new),
	DECL_API("RtlSecondsSince1980ToTime", RtlSecondsSince1980ToTime_new),
	DECL_API("RtlSetCriticalSectionSpinCount", SetCriticalSectionSpinCount_new),
	DECL_API("RtlSetDaclSecurityDescriptor", RtlSetDaclSecurityDescriptor_fwd),
	DECL_API("RtlSetGroupSecurityDescriptor", RtlSetGroupSecurityDescriptor_fwd),
	DECL_API("RtlSetInformationAcl", RtlSetInformationAcl_fwd),
	DECL_API("RtlSetOwnerSecurityDescriptor", RtlSetOwnerSecurityDescriptor_fwd),
	DECL_API("RtlSetSaclSecurityDescriptor", RtlSetSaclSecurityDescriptor_fwd),
	DECL_API("RtlSetSecurityDescriptorControl", RtlSetSecurityDescriptorControl_stub),
	DECL_API("RtlSetSecurityObject", RtlSetSecurityObject_fwd),
	DECL_API("RtlSubAuthorityCountSid", RtlSubAuthorityCountSid_fwd),
	DECL_API("RtlSubAuthoritySid", RtlSubAuthoritySid),
	DECL_API("RtlSystemTimeToLocalTime", RtlSystemTimeToLocalTime),
	DECL_API("RtlTimeToSecondsSince1970", RtlTimeToSecondsSince1970_new),
	DECL_API("RtlTimeToSecondsSince1980", RtlTimeToSecondsSince1980_new),
	DECL_API("RtlTryEnterCriticalSection", RtlTryEnterCriticalSection_new),
	DECL_API("RtlUnicodeStringToOemString", RtlUnicodeStringToOemString_new),
	DECL_API("RtlUnicodeToMultiByteSize", RtlUnicodeToMultiByteSize_stub),
	DECL_API("RtlUnicodeToOemN", RtlUnicodeToOemN_new),
	DECL_API("RtlUniform", RtlUniform_new),
	DECL_API("RtlUpcaseUnicodeChar", RtlUpcaseUnicodeChar_new),
	DECL_API("RtlUpcaseUnicodeString", RtlUpcaseUnicodeString_new),
	DECL_API("RtlValidAcl", RtlValidAcl_fwd),
	DECL_API("RtlValidSecurityDescriptor", RtlValidSecurityDescriptor_fwd),
	DECL_API("RtlValidSid", RtlValidSid_fwd),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN2000D),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WINXP2),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN2003A),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_VISTA),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN2008A),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_VISTA2),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN7A),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN8),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN81),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN10),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN10A),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WINXP),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WINXP3),
	DECL_API("RtlpEnsureBufferSize", RtlpEnsureBufferSize_stub),
	DECL_API("RtlxUnicodeStringToOemSize", RtlxUnicodeStringToOemSize_new),
	DECL_API("VerSetConditionMask", VerSetConditionMask_new),
	DECL_API("ZwClose", NtClose_new),
	DECL_API("ZwConnectPort", NtConnectPort_stub),
	DECL_API("vDbgPrintExWithPrefix", vDbgPrintExWithPrefix_stub),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef ntdll_ordinal_apis
static const apilib_unnamed_api ntdll_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_ntdll =
  DECL_TAB("NTDLL.DLL", ntdll_named_apis, ntdll_ordinal_apis);
