/*
 *  kexbasen\rasapi32\_rasapi32_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2017, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "kexcoresdk.h"
#include "_rasapi32_apilist.h"

BOOL init_rasapi32()
{
	return TRUE;
}

static const apilib_named_api rasapi32_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("RasDeleteEntryW", RasDeleteEntryW_fwd),
	DECL_API("RasDeleteSubEntryW", RasDeleteSubEntryW_fwd),
	DECL_API("RasEnumDevicesW", RasEnumDevicesW_fwd),
	DECL_API("RasGetEntryPropertiesW", RasGetEntryPropertiesW_fwd),
	DECL_API("RasRenameEntryW", RasRenameEntryW_fwd),
	DECL_API("RasSetEntryPropertiesW", RasSetEntryPropertiesW_fwd),
	DECL_API("RasSetSubEntryPropertiesW", RasSetSubEntryPropertiesW_fwd),
	DECL_API("RasValidateEntryNameW", RasValidateEntryNameW_fwd),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef rasapi32_ordinal_apis
static const apilib_unnamed_api rasapi32_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_rasapi32 = 
  DECL_TAB("RASAPI32.DLL", rasapi32_named_apis, rasapi32_ordinal_apis);
