/*
 *  kexbasen\ntdll\_ntdll_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2016, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
//#include "kexcoresdk.h"
#include "_ntdll_apilist.h"
//#include "../kernel32/_kernel32_apilist.h"

BOOL init_ntdll()
{
	return TRUE;
}


static const apilib_named_api ntdll_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("RtlFillMemory", RtlFillMemory_fwd),
	DECL_API("RtlImageDirectoryEntryToData", RtlImageDirectoryEntryToData_fwd),
	DECL_API("RtlImageRvaToSection", RtlImageRvaToSection_fwd),
	DECL_API("RtlImageRvaToVa", RtlImageRvaToVa_fwd),
	DECL_API("RtlMoveMemory", RtlMoveMemory_fwd),
	DECL_API("RtlZeroMemory", RtlZeroMemory_fwd),
	DECL_API("_CIcos", _CIcos_fwd),
	DECL_API("_CIlog", _CIlog_fwd),
	DECL_API("_CIpow", _CIpow_fwd),
	DECL_API("_CIsin", _CIsin_fwd),
	DECL_API("_CIsqrt", _CIsqrt_fwd),
	DECL_API("__isascii", __isascii_fwd),
	DECL_API("__iscsym", __iscsym_fwd),
	DECL_API("__iscsymf", __iscsymf_fwd),
	DECL_API("__toascii", __toascii_fwd),
	DECL_API("_atoi64", _atoi64_fwd),
	DECL_API("_chkstk", _chkstk_fwd),
	DECL_API("_ftol", _ftol_fwd),
	DECL_API("_ftol2", _ftol2_fwd),
	DECL_API("_ftol2_sse", _ftol2_sse_fwd),
	DECL_API("_i64toa", _i64toa_fwd),
	DECL_API("_i64tow", _i64tow_fwd),
	DECL_API("_itoa", _itoa_fwd),
	DECL_API("_itow", _itow_fwd),
	DECL_API("_lfind", _lfind_fwd),
	DECL_API("_ltoa", _ltoa_fwd),
	DECL_API("_ltow", _ltow_fwd),
	DECL_API("_memccpy", _memccpy_fwd),
	DECL_API("_memicmp", _memicmp_fwd),
	DECL_API("_snprintf", _snprintf_fwd),
	DECL_API("_snwprintf", _snwprintf_fwd),
	DECL_API("_splitpath", _splitpath_fwd),
	DECL_API("_strcmpi", _strcmpi_fwd),
	DECL_API("_stricmp", _stricmp_fwd),
	DECL_API("_strlwr", _strlwr_fwd),
	DECL_API("_strnicmp", _strnicmp_fwd),
	DECL_API("_strupr", _strupr_fwd),
	DECL_API("_tolower", _tolower_fwd),
	DECL_API("_toupper", _toupper_fwd),
	DECL_API("_ui64toa", _ui64toa_fwd),
	DECL_API("_ui64tow", _ui64tow_fwd),
	DECL_API("_ultoa", _ultoa_fwd),
	DECL_API("_ultow", _ultow_fwd),
	DECL_API("_vsnprintf", _vsnprintf_fwd),
	DECL_API("_vsnwprintf", _vsnwprintf_fwd),
	DECL_API("_wcsicmp", _wcsicmp_fwd),
	DECL_API("_wcslwr", _wcslwr_fwd),
	DECL_API("_wcsnicmp", _wcsnicmp_fwd),
	DECL_API("_wcsupr", _wcsupr_fwd),
	DECL_API("_wtoi", _wtoi_fwd),
	DECL_API("_wtoi64", _wtoi64_fwd),
	DECL_API("_wtol", _wtol_fwd),
	DECL_API("abs", abs_fwd),
	DECL_API("atan", atan_fwd),
	DECL_API("atoi", atoi_fwd),
	DECL_API("atol", atol_fwd),
	DECL_API("bsearch", bsearch_fwd),
	DECL_API("ceil", ceil_fwd),
	DECL_API("cos", cos_fwd),
	DECL_API("fabs", fabs_fwd),
	DECL_API("floor", floor_fwd),
	DECL_API("isalnum", isalnum_fwd),
	DECL_API("isalpha", isalpha_fwd),
	DECL_API("iscntrl", iscntrl_fwd),
	DECL_API("isdigit", isdigit_fwd),
	DECL_API("isgraph", isgraph_fwd),
	DECL_API("islower", islower_fwd),
	DECL_API("isprint", isprint_fwd),
	DECL_API("ispunct", ispunct_fwd),
	DECL_API("isspace", isspace_fwd),
	DECL_API("isupper", isupper_fwd),
	DECL_API("iswalpha", iswalpha_fwd),
	DECL_API("iswctype", iswctype_fwd),
	DECL_API("iswdigit", iswdigit_fwd),
	DECL_API("iswlower", iswlower_fwd),
	DECL_API("iswspace", iswspace_fwd),
	DECL_API("iswxdigit", iswxdigit_fwd),
	DECL_API("isxdigit", isxdigit_fwd),
	DECL_API("labs", labs_fwd),
	DECL_API("log", log_fwd),
	DECL_API("mbstowcs", mbstowcs_fwd),
	DECL_API("memchr", memchr_fwd),
	DECL_API("memcmp", memcmp_fwd),
	DECL_API("memcpy", memcpy_fwd),
	DECL_API("memmove", memmove_fwd),
	DECL_API("memset", memset_fwd),
	DECL_API("pow", pow_fwd),
	DECL_API("qsort", qsort_fwd),
	DECL_API("sin", sin_fwd),
	DECL_API("sprintf", sprintf_fwd),
	DECL_API("sqrt", sqrt_fwd),
	DECL_API("sscanf", sscanf_fwd),
	DECL_API("strcat", strcat_fwd),
	DECL_API("strchr", strchr_fwd),
	DECL_API("strcmp", strcmp_fwd),
	DECL_API("strcpy", strcpy_fwd),
	DECL_API("strcspn", strcspn_fwd),
	DECL_API("strlen", strlen_fwd),
	DECL_API("strncat", strncat_fwd),
	DECL_API("strncmp", strncmp_fwd),
	DECL_API("strncpy", strncpy_fwd),
	DECL_API("strpbrk", strpbrk_fwd),
	DECL_API("strrchr", strrchr_fwd),
	DECL_API("strspn", strspn_fwd),
	DECL_API("strstr", strstr_fwd),
	DECL_API("strtol", strtol_fwd),
	DECL_API("strtoul", strtoul_fwd),
	DECL_API("swprintf", swprintf_fwd),
	DECL_API("tan", tan_fwd),
	DECL_API("tolower", tolower_fwd),
	DECL_API("toupper", toupper_fwd),
	DECL_API("towlower", towlower_fwd),
	DECL_API("towupper", towupper_fwd),
	DECL_API("vsprintf", vsprintf_fwd),
	DECL_API("wcscat", wcscat_fwd),
	DECL_API("wcschr", wcschr_fwd),
	DECL_API("wcscmp", wcscmp_fwd),
	DECL_API("wcscpy", wcscpy_fwd),
	DECL_API("wcscspn", wcscspn_fwd),
	DECL_API("wcslen", wcslen_fwd),
	DECL_API("wcsncat", wcsncat_fwd),
	DECL_API("wcsncmp", wcsncmp_fwd),
	DECL_API("wcsncpy", wcsncpy_fwd),
	DECL_API("wcspbrk", wcspbrk_fwd),
	DECL_API("wcsrchr", wcsrchr_fwd),
	DECL_API("wcsspn", wcsspn_fwd),
	DECL_API("wcsstr", wcsstr_fwd),
	DECL_API("wcstol", wcstol_fwd),
	DECL_API("wcstombs", wcstombs_fwd),
	DECL_API("wcstoul", wcstoul_fwd),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef ntdll_ordinal_apis
static const apilib_unnamed_api ntdll_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_ntdll =
  DECL_TAB("NTDLL.DLL", ntdll_named_apis, ntdll_ordinal_apis);
