/*
 *  kexbasen\gdi32\_gdi32_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2016, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "kexcoresdk.h"
#include "_gdi32_apilist.h"

BOOL InitUberGDI(void);

BOOL init_gdi32()
{
	return InitUberGDI();
}

static const apilib_named_api gdi32_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("CopyEnhMetaFileW", CopyEnhMetaFileW_fwd),
	DECL_API("CopyMetaFileW", CopyMetaFileW_fwd),
	DECL_API("CreateColorSpaceW", CreateColorSpaceW_fwd),
	DECL_API("CreateDCW", CreateDCW_fwd),
	DECL_API("CreateEnhMetaFileW", CreateEnhMetaFileW_fwd),
	DECL_API("CreateFontIndirectW", CreateFontIndirectW_fwd),
	DECL_API("CreateFontW", CreateFontW_fwd),
	DECL_API("CreateICW", CreateICW_fwd),
	DECL_API("CreateMetaFileW", CreateMetaFileW_fwd),
	DECL_API("CreateScalableFontResourceW", CreateScalableFontResourceW_fwd),
	DECL_API("EnumICMProfilesW", EnumICMProfilesW_fwd),
	DECL_API("GdiAlphaBlend", GdiAlphaBlend_fwd),
	DECL_API("GdiGradientFill", GdiGradientFill_fwd),
	DECL_API("GdiTransparentBlt", GdiTransparentBlt_fwd),
	DECL_API("GetCharABCWidthsI", GetCharABCWidthsI_new),
	DECL_API("GetCharABCWidthsW", GetCharABCWidthsW_new),
	DECL_API("GetCharWidthI", GetCharWidthI_new),
	DECL_API("GetCharacterPlacementW", GetCharacterPlacementW_fwd),
	DECL_API("GetEnhMetaFileDescriptionW", GetEnhMetaFileDescriptionW_fwd),
	DECL_API("GetEnhMetaFileW", GetEnhMetaFileW_fwd),
	DECL_API("GetGlyphIndicesA", GetGlyphIndicesA_new),
	DECL_API("GetGlyphIndicesW", GetGlyphIndicesW_new),
	DECL_API("GetGlyphOutlineW", GetGlyphOutlineW_new),
	DECL_API("GetICMProfileW", GetICMProfileW_fwd),
	DECL_API("GetKerningPairsW", GetKerningPairsW_fwd),
	DECL_API("GetLogColorSpaceW", GetLogColorSpaceW_fwd),
	DECL_API("GetMetaFileW", GetMetaFileW_fwd),
	DECL_API("GetOutlineTextMetricsW", GetOutlineTextMetricsW_fwd),
	DECL_API("GetTextExtentExPointI", GetTextExtentExPointI_new),
	DECL_API("GetTextExtentExPointW", GetTextExtentExPointW_fwd),
	DECL_API("GetTextExtentPointI", GetTextExtentPointI_new),
	DECL_API("GetTextFaceW", GetTextFaceW_fwd),
	DECL_API("GetTextMetricsW", GetTextMetricsW_fwd),
	DECL_API("ResetDCW", ResetDCW_fwd),
	DECL_API("SetICMProfileW", SetICMProfileW_fwd),
	DECL_API("StartDocW", StartDocW_fwd),
	DECL_API("UpdateICMRegKeyW", UpdateICMRegKeyW_fwd),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef gdi32_ordinal_apis
static const apilib_unnamed_api gdi32_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_gdi32 = 
  DECL_TAB("GDI32.DLL", gdi32_named_apis, gdi32_ordinal_apis);
