/*
 *  kexbases\gdi32\_gdi32_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2016, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "_gdi32_apilist.h"

BOOL InitGDIObjects(void);

BOOL init_gdi32()
{
	return InitGDIObjects();
}

/*
 * MAKE_EXPORT GetCharWidthA=GetCharWidth32A  FIXME: forward to Unicows?
 * MAKE_EXPORT GetCharWidthW=GetCharWidth32W  FIXME: forward to Unicows?
 */

static const apilib_named_api gdi32_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("AddFontMemResourceEx", AddFontMemResourceEx_stub),
	DECL_API("AddFontResourceExA", AddFontResourceExA_new),
	DECL_API("AddFontResourceExW", AddFontResourceExW_new),
	DECL_API("AddFontResourceW", AddFontResourceW_new),
	DECL_API("ClearBitmapAttributes", ClearBitmapAttributes_stub),
	DECL_API("CreateDIBSection", CreateDIBSection_fix),
	DECL_API("CreateFontIndirectA", CreateFontIndirectA_fix),
	DECL_API("DeleteObject", DeleteObject_fix),
	DECL_API("EnumFontFamiliesExA", EnumFontFamiliesExA_new),
	DECL_API("EnumFontFamiliesExW", EnumFontFamiliesExW_new),
	DECL_API("EnumFontFamiliesW", EnumFontFamiliesW_new),
	DECL_API("EnumFontsW", EnumFontsW_new),
	DECL_API("ExtCreatePen", ExtCreatePen_fix),
	DECL_API("ExtTextOutA", ExtTextOutA_new),
	DECL_API("ExtTextOutW", ExtTextOutW_new),
	DECL_API("FontIsLinked", FontIsLinked_stub),
	DECL_API("GdiDrawStream", GdiDrawStream_stub),
	DECL_API("GdiEntry13", GdiEntry13_stub),
	DECL_API("GetCharWidth32A", GetCharWidthA),
	DECL_API("GetCharWidth32W", GetCharWidthW),
	DECL_API("GetDCBrushColor", GetDCBrushColor_stub),
	DECL_API("GetDCPenColor", GetDCPenColor_stub),
	DECL_API("GetFontUnicodeRanges", GetFontUnicodeRanges_new),
	DECL_API("GetGlyphOutlineA", GetGlyphOutlineA_fix),
	DECL_API("GetObjectType", GetObjectType_fix),
	DECL_API("GetObjectW", GetObjectW_new),
	DECL_API("GetRandomRgn", GetRandomRgn_NT),
	DECL_API("GetTextExtentPoint32A", GetTextExtentPoint32A_fix),
	DECL_API("GetTextExtentPoint32W", GetTextExtentPoint32W_fix),
	DECL_API("GetTextMetricsA", GetTextMetricsA_NT),
	DECL_API("GetWorldTransform", GetWorldTransform_NT),
	DECL_API("MaskBlt", MaskBlt_new),
	DECL_API("ModifyWorldTransform", ModifyWorldTransform_NT),
	DECL_API("PolyTextOutA", PolyTextOutA_new),
	DECL_API("PolyTextOutW", PolyTextOutW_new),
	DECL_API("RemoveFontMemResourceEx", RemoveFontMemResourceEx_stub),
	DECL_API("RemoveFontResourceExA", RemoveFontResourceExA_new),
	DECL_API("RemoveFontResourceExW", RemoveFontResourceExW_new),
	DECL_API("RemoveFontResourceW", RemoveFontResourceW_new),
	DECL_API("SelectObject", SelectObject_fix),
	DECL_API("SetDCBrushColor", SetDCBrushColor_stub),
	DECL_API("SetDCPenColor", SetDCPenColor_stub),
	DECL_API("SetGraphicsMode", SetGraphicsMode_NT),
	DECL_API("SetMapMode", SetMapMode_NT),
	DECL_API("SetWorldTransform", SetWorldTransform_9x),
	DECL_API("SetWorldTransform", SetWorldTransform_NT),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef gdi32_ordinal_apis
static const apilib_unnamed_api gdi32_ordinal_apis[] = 
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_gdi32 = 
  DECL_TAB("GDI32.DLL", gdi32_named_apis, gdi32_ordinal_apis);
