/*
 *  kexbases\advapi32\_advapi32_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2016, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "kexcoresdk.h"
#include "_advapi32_apilist.h"

BOOL init_advapi32()
{
	return TRUE;
}

static const apilib_named_api advapi32_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("A_SHAFinal", A_SHAFinal_stub),
	DECL_API("A_SHAInit", A_SHAInit_stub),
	DECL_API("A_SHAUpdate", A_SHAUpdate_stub),
	DECL_API("AccessCheck", AccessCheck_new),
	DECL_API("AccessCheckByType", AccessCheckByType_stub),
	DECL_API("AddAccessAllowedAce", AddAccessAllowedAce_new),
	DECL_API("AddAccessAllowedAceEx", AddAccessAllowedAceEx_stub),
	DECL_API("AddAccessDeniedAceEx", AddAccessDeniedAceEx_stub),
	DECL_API("AddMandatoryAce", AddMandatoryAce_stub),
	DECL_API("AdjustTokenPrivileges", AdjustTokenPrivileges_new),
	DECL_API("AllocateAndInitializeSid", AllocateAndInitializeSid_new),
	DECL_API("ChangeServiceConfig2A", ChangeServiceConfig2A_stub),
	DECL_API("ChangeServiceConfig2W", ChangeServiceConfig2W_stub),
	DECL_API("CheckTokenMembership", CheckTokenMembership_new),
	DECL_API("CloseTrace", CloseTrace_stub),
	DECL_API("ControlTraceA", ControlTraceA_stub),
	DECL_API("ControlTraceW", ControlTraceW_stub),
	DECL_API("ConvertSecurityDescriptorToStringSecurityDescriptorA", ConvertSecurityDescriptorToStringSecurityDescriptorA_stub),
	DECL_API("ConvertSecurityDescriptorToStringSecurityDescriptorW", ConvertSecurityDescriptorToStringSecurityDescriptorW_stub),
	DECL_API("ConvertSidToStringSidA", ConvertSidToStringSidA_new),
	DECL_API("ConvertSidToStringSidA", ConvertSidToStringSidA_stub),
	DECL_API("ConvertSidToStringSidW", ConvertSidToStringSidW_new),
	DECL_API("ConvertSidToStringSidW", ConvertSidToStringSidW_stub),
	DECL_API("ConvertStringSecurityDescriptorToSecurityDescriptorA", ConvertStringSecurityDescriptorToSecurityDescriptorA_stub),
	DECL_API("ConvertStringSecurityDescriptorToSecurityDescriptorW", ConvertStringSecurityDescriptorToSecurityDescriptorW_stub),
	DECL_API("ConvertStringSidToSidA", ConvertStringSidToSidA_stub),
	DECL_API("ConvertStringSidToSidW", ConvertStringSidToSidW_stub),
	DECL_API("CopySid", CopySid_new),
	DECL_API("CreateProcessWithLogonW", CreateProcessWithLogonW_stub),
	DECL_API("CreateRestrictedToken", CreateRestrictedToken_new),
	DECL_API("CreateWellKnownSid", CreateWellKnownSid_new),
	DECL_API("CredDeleteW", CredDeleteW_stub),
	DECL_API("CredEnumerateW", CredEnumerateW_stub),
	DECL_API("CredFree", CredFree_stub),
	DECL_API("CredGetTargetInfoW", CredGetTargetInfoW_stub),
	DECL_API("CredIsMarshaledCredentialW", CredIsMarshaledCredentialW_stub),
	DECL_API("CredReadDomainCredentialsW", CredReadDomainCredentialsW_stub),
	DECL_API("CredReadW", CredReadW_stub),
	DECL_API("CredWriteW", CredWriteW_stub),
	DECL_API("CredpConvertCredential", CredpConvertCredential_stub),
	DECL_API("CredpConvertTargetInfo", CredpConvertTargetInfo_stub),
	DECL_API("CredpDecodeCredential", CredpDecodeCredential_stub),
	DECL_API("CredpEncodeCredential", CredpEncodeCredential_stub),
	DECL_API("CryptAcquireContextW", CryptAcquireContextW_stub),
	DECL_API("CryptEnumProviderTypesW", CryptEnumProviderTypesW_stub),
	DECL_API("CryptEnumProvidersW", CryptEnumProvidersW_stub),
	DECL_API("CryptGetDefaultProviderW", CryptGetDefaultProviderW_stub),
	DECL_API("CryptGetLocalKeyLimits", CryptGetLocalKeyLimits_stub),
	DECL_API("CryptSetProviderExW", CryptSetProviderExW_stub),
	DECL_API("CryptSetProviderW", CryptSetProviderW_stub),
	DECL_API("CryptSignHashW", CryptSignHashW_stub),
	DECL_API("CryptVerifySignatureW", CryptVerifySignatureW_stub),
	DECL_API("DecryptFileA", DecryptFileA_stub),
	DECL_API("DecryptFileW", DecryptFileW_stub),
	DECL_API("DeleteAce", DeleteAce_new),
	DECL_API("DuplicateToken", DuplicateToken_new),
	DECL_API("DuplicateTokenEx", DuplicateTokenEx_new),
	DECL_API("EnableTrace", EnableTrace_stub),
	DECL_API("EncryptFileA", EncryptFileA_stub),
	DECL_API("EncryptFileW", EncryptFileW_stub),
	DECL_API("EnumServicesStatusExA", EnumServicesStatusExA_stub),
	DECL_API("EnumServicesStatusExW", EnumServicesStatusExW_stub),
	DECL_API("EqualPrefixSid", EqualPrefixSid_new),
	DECL_API("EqualSid", EqualSid_new),
	DECL_API("EventRegister", EventRegister_stub),
	DECL_API("EventUnregister", EventUnregister_stub),
	DECL_API("EventWrite", EventWrite_stub),
	DECL_API("FileEncryptionStatusA", FileEncryptionStatusA_stub),
	DECL_API("FileEncryptionStatusW", FileEncryptionStatusW_stub),
	DECL_API("FlushTraceA", FlushTraceA_stub),
	DECL_API("FlushTraceW", FlushTraceW_stub),
	DECL_API("FreeSid", FreeSid_new),
	DECL_API("GetAce", GetAce_new),
	DECL_API("GetExplicitEntriesFromAclA", GetExplicitEntriesFromAclA_stub),
	DECL_API("GetExplicitEntriesFromAclW", GetExplicitEntriesFromAclW_stub),
	DECL_API("GetFileSecurityA", GetFileSecurityA_new),
	DECL_API("GetFileSecurityW", GetFileSecurityW_new),
	DECL_API("GetLengthSid", GetLengthSid_new),
	DECL_API("GetNamedSecurityInfoA", GetNamedSecurityInfoA_new),
	DECL_API("GetNamedSecurityInfoW", GetNamedSecurityInfoW_new),
	DECL_API("GetSecurityDescriptorControl", GetSecurityDescriptorControl_new),
	DECL_API("GetSecurityDescriptorDacl", GetSecurityDescriptorDacl_new),
	DECL_API("GetSecurityDescriptorGroup", GetSecurityDescriptorGroup_new),
	DECL_API("GetSecurityDescriptorLength", GetSecurityDescriptorLength_new),
	DECL_API("GetSecurityDescriptorOwner", GetSecurityDescriptorOwner_new),
	DECL_API("GetSecurityDescriptorSacl", GetSecurityDescriptorSacl_new),
	DECL_API("GetSidIdentifierAuthority", GetSidIdentifierAuthority_new),
	DECL_API("GetSidLengthRequired", GetSidLengthRequired_new),
	DECL_API("GetSidSubAuthority", GetSidSubAuthority_new),
	DECL_API("GetSidSubAuthorityCount", GetSidSubAuthorityCount_new),
	DECL_API("GetTokenInformation", GetTokenInformation_new),
	DECL_API("GetTraceEnableFlags", GetTraceEnableFlags_stub),
	DECL_API("GetTraceEnableLevel", GetTraceEnableLevel_stub),
	DECL_API("GetTraceLoggerHandle", GetTraceLoggerHandle_stub),
	DECL_API("ImpersonateSelf", ImpersonateSelf_new),
	DECL_API("InitializeAcl", InitializeAcl_new),
	DECL_API("InitializeSecurityDescriptor", InitializeSecurityDescriptor_new),
	DECL_API("InitializeSid", InitializeSid_new),
	DECL_API("InitiateSystemShutdownExA", InitiateSystemShutdownExA_stub),
	DECL_API("InitiateSystemShutdownExW", InitiateSystemShutdownExW_stub),
	DECL_API("IsTokenRestricted", IsTokenRestricted_stub),
	DECL_API("IsValidSecurityDescriptor", IsValidSecurityDescriptor_new),
	DECL_API("IsValidSid", IsValidSid_new),
	DECL_API("IsWellKnownSid", IsWellKnownSid_stub),
	DECL_API("LookupAccountSidA", LookupAccountSidA_new),
	DECL_API("LookupAccountSidW", LookupAccountSidW_new),
	DECL_API("LookupPrivilegeValueA", LookupPrivilegeValueA_new),
	DECL_API("LookupPrivilegeValueW", LookupPrivilegeValueW_new),
	DECL_API("LsaAddAccountRights", LsaAddAccountRights_stub),
	DECL_API("LsaClose", LsaClose_new),
	DECL_API("LsaEnumerateAccountRights", LsaEnumerateAccountRights_stub),
	DECL_API("LsaFreeMemory", LsaFreeMemory_stub),
	DECL_API("LsaLookupNames", LsaLookupNames_stub),
	DECL_API("LsaLookupNames2", LsaLookupNames2_stub),
	DECL_API("LsaLookupPrivilegeValue", LsaLookupPrivilegeValue_stub),
	DECL_API("LsaLookupSids", LsaLookupSids_stub),
	DECL_API("LsaNtStatusToWinError", K32_RtlNtStatusToDosError),
	DECL_API("LsaOpenPolicy", LsaOpenPolicy_new),
	DECL_API("LsaQueryInformationPolicy", LsaQueryInformationPolicy_stub),
	DECL_API("LsaRetrievePrivateData", LsaRetrievePrivateData_new),
	DECL_API("LsaStorePrivateData", LsaStorePrivateData_new),
	DECL_API("MD4Final", MD4Final_stub),
	DECL_API("MD4Init", MD4Init_stub),
	DECL_API("MD4Update", MD4Update_stub),
	DECL_API("MD5Final", MD5Final_stub),
	DECL_API("MD5Init", MD5Init_stub),
	DECL_API("MD5Update", MD5Update_stub),
	DECL_API("MakeSelfRelativeSD", MakeSelfRelativeSD_new),
	DECL_API("OpenProcessToken", OpenProcessToken_new),
	DECL_API("OpenSCManagerA", OpenSCManagerA_stub),
	DECL_API("OpenSCManagerW", OpenSCManagerW_stub),
	DECL_API("OpenThreadToken", OpenThreadToken_new),
	DECL_API("OpenTraceA", OpenTraceA_stub),
	DECL_API("OpenTraceW", OpenTraceW_stub),
	DECL_API("PrivilegeCheck", PrivilegeCheck_new),
	DECL_API("ProcessTrace", ProcessTrace_stub),
	DECL_API("QueryAllTracesA", QueryAllTracesA_stub),
	DECL_API("QueryAllTracesW", QueryAllTracesW_stub),
	DECL_API("QueryServiceStatusEx", QueryServiceStatusEx_stub),
	DECL_API("QueryTraceA", QueryTraceA_stub),
	DECL_API("QueryTraceW", QueryTraceW_stub),
	DECL_API("QueryUsersOnEncryptedFile", QueryUsersOnEncryptedFile_stub),
	DECL_API("QueryWindows31FilesMigration", QueryWindows31FilesMigration_stub),
	DECL_API("RegCreateKeyExW", RegCreateKeyExW_new),
	DECL_API("RegCreateKeyW", RegCreateKeyW_new),
	DECL_API("RegDeleteKeyExA", RegDeleteKeyExA_stub),
	DECL_API("RegDeleteKeyExW", RegDeleteKeyExW_stub),
	DECL_API("RegDeleteKeyW", RegDeleteKeyW_new),
	DECL_API("RegDeleteTreeA", RegDeleteTreeA_stub),
	DECL_API("RegDeleteTreeW", RegDeleteTreeW_stub),
	DECL_API("RegDisablePredefinedCache", RegDisablePredefinedCache_new),
	DECL_API("RegEnumValueW", RegEnumValueW_new),
	DECL_API("RegGetKeySecurity", RegGetKeySecurity_new),
	DECL_API("RegGetValueA", RegGetValueA_stub),
	DECL_API("RegGetValueW", RegGetValueW_stub),
	DECL_API("RegOpenCurrentUser", RegOpenCurrentUser_new),
	DECL_API("RegOpenKeyExW", RegOpenKeyExW_new),
	DECL_API("RegOpenKeyW", RegOpenKeyW_new),
	DECL_API("RegOpenUserClassesRoot", RegOpenUserClassesRoot_stub),
	DECL_API("RegOverridePredefKey", RegOverridePredefKey_stub),
	DECL_API("RegQueryValueExW", RegQueryValueExW_new),
	DECL_API("RegSetValueExA", RegSetValueExA_fix),
	DECL_API("RegSetValueExW", RegSetValueExW_new),
	DECL_API("RegisterServiceCtrlHandlerExW", RegisterServiceCtrlHandlerExW_stub),
	DECL_API("RegisterTraceGuidsA", RegisterTraceGuidsA_stub),
	DECL_API("RegisterTraceGuidsW", RegisterTraceGuidsW_stub),
	DECL_API("RevertToSelf", RevertToSelf_new),
	DECL_API("SetFileSecurityA", SetFileSecurityA_new),
	DECL_API("SetFileSecurityW", SetFileSecurityW_new),
	DECL_API("SetKernelObjectSecurity", SetKernelObjectSecurity_new),
	DECL_API("SetSecurityDescriptorControl", SetSecurityDescriptorControl_stub),
	DECL_API("SetSecurityDescriptorDacl", SetSecurityDescriptorDacl_new),
	DECL_API("SetSecurityDescriptorGroup", SetSecurityDescriptorGroup_new),
	DECL_API("SetSecurityDescriptorOwner", SetSecurityDescriptorOwner_new),
	DECL_API("SetSecurityDescriptorSacl", SetSecurityDescriptorSacl_new),
	DECL_API("SetThreadToken", SetThreadToken_new),
	DECL_API("StartTraceA", StartTraceA_stub),
	DECL_API("StartTraceW", StartTraceW_stub),
	DECL_API("StopTraceA", StopTraceA_stub),
	DECL_API("StopTraceW", StopTraceW_stub),
	DECL_API("SynchronizeWindows31FilesAndWindowsNTRegistry", SynchronizeWindows31FilesAndWindowsNTRegistry_stub),
	DECL_API("SystemFunction029", SystemFunction029_stub),
	DECL_API("SystemFunction033", SystemFunction033_stub),
	DECL_API("SystemFunction034", SystemFunction034_stub),
	DECL_API("SystemFunction035", SystemFunction035_stub),
	DECL_API("SystemFunction036", SystemFunction036_new),
	DECL_API("SystemFunction040", RtlEncryptMemory_new),
	DECL_API("SystemFunction041", RtlEncryptMemory_new),
	DECL_API("TraceEvent", TraceEvent_stub),
	DECL_API("TraceMessage", TraceMessage_stub),
	DECL_API("TraceMessageVa", TraceMessageVa_stub),
	DECL_API("TreeResetNamedSecurityInfoW", TreeResetNamedSecurityInfoW_stub),
	DECL_API("UnregisterTraceGuids", UnregisterTraceGuids_stub),
	DECL_API("UpdateTraceA", UpdateTraceA_stub),
	DECL_API("UpdateTraceW", UpdateTraceW_stub),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef advapi32_ordinal_apis
static const apilib_unnamed_api advapi32_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_advapi32 = 
  DECL_TAB("ADVAPI32.DLL", advapi32_named_apis, advapi32_ordinal_apis);
