/*
 *  kexbasen\secur32\_secur32_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2017, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "kexcoresdk.h"
#include "_secur32_apilist.h"

BOOL init_secur32()
{
	return TRUE;
}

static const apilib_named_api secur32_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("AcquireCredentialsHandleW", AcquireCredentialsHandleW_fwd),
	DECL_API("CompleteAuthToken", CompleteAuthToken_fwd),
	DECL_API("DecodeMessage", DecodeMessage_fwd),
	DECL_API("EncodeMessage", EncodeMessage_fwd),
	DECL_API("EnumerateSecurityPackagesW", EnumerateSecurityPackagesW_fwd),
	DECL_API("InitSecurityInterfaceW", InitSecurityInterfaceW_fwd),
	DECL_API("InitializeSecurityContextW", InitializeSecurityContextW_fwd),
	DECL_API("QueryContextAttributesW", QueryContextAttributesW_fwd),
	DECL_API("QueryCredentialsAttributesW", QueryCredentialsAttributesW_fwd),
	DECL_API("QuerySecurityPackageInfoW", QuerySecurityPackageInfoW_fwd),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef secur32_ordinal_apis
static const apilib_unnamed_api secur32_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_secur32 = 
  DECL_TAB("secur32.DLL", secur32_named_apis, secur32_ordinal_apis);
