#include <windows.h>
#include <WinIoCtl.h>
#include <stdio.h>
#include "args.h"

#ifdef _DEBUG
#define KdPrint(x)  {printf x;}
#else
#define KdPrint(x)  {;}
#endif

ULONG bs = 2048;
ULONG iobs = 64*1024;
ULONG retry = 3;
ULONG max_errors = 0;
BOOLEAN fall_back = 0;
BOOLEAN no_cache = 0;

PWCHAR in_nameW = NULL;
PWCHAR out_nameW = NULL;
PWCHAR log_nameW = NULL;
PWCHAR fill_stringW = NULL;

PCHAR in_nameA = NULL;
PCHAR out_nameA = NULL;
PCHAR log_nameA = NULL;
PCHAR fill_stringA = NULL;

WCHAR in_devnameW[]  = L"\\\\.\\\\PhysicalDrive000000000000";
CHAR  in_devnameA[]  = "\\\\.\\\\PhysicalDrive000000000000";

WCHAR out_devnameW[] = L"\\\\.\\\\PhysicalDrive000000000000";
CHAR  out_devnameA[] = "\\\\.\\\\PhysicalDrive000000000000";

char* buff_template = NULL;

__int64 bads = 0;
__int64 susp = 0;
__int64 copy_count = 0;

__int64 mlt = 0;

int new_target = 0;

CHAR LogBuffer[2048];

void print_help() {
    printf("Usage:\n"
           "  bbcopy.exe [-<switches>] <source file> <target file>\n"
           "      or\n"
           "  bbcopy.exe <dd-style options>\n"
           "Switches:\n"
           "  -b[k] <blocksize>   sets physical block (sector) size for media.\n"
           "                      2048 (2k) is default, 512 is used for HDD images.\n"
           "  -B[k] <blocksize>   sets I/O block size. 64k is default.\n"
           "  -o[b|k|m|g] <offset>  offset in bytes (or optionally in blocks, KBytes, MBytes or GBytes)\n"
           "                      to start recovery from\n"
           "  -c[b|k|m|g] <count>   number of bytes (or optionally in blocks, KBytes, MBytes or GBytes)\n"
           "                      to recover\n"
           "  -r <retry>          number of retry attempts. 3 is default\n"
           "  -e <max errors>     abort copying after specified number of sequential errors\n"
           "  -f                  fall-back to physical sector-by-sector mode, when I/O block\n"
           "                        cannot be read in single request (contains some bad sectors)\n"
           "  -l <logfile>        log unreliable and bad blocks to <logfile>\n"
           "  -s                  fill unreadable parts with \'** BAD BLOCK ***\'\n"
           "  -S <string>         fill unreadable parts with <string>\n"
           "                      Do not use fill patterns if you restore from multiple copies\n"
           "  -n                  use NO CACHE option for file/device I/O\n"
           "                        This option is automatically enabled for block devices\n"
           "  -d[i|o] <num>       specify input (i) or output (o) block device <num>\n"
           "                        this is short form for \\\\.\\\\PhysicalDrive<num>\n"
           "  -?                  display this help\n"
           "dd-style options:\n"
           "  if=<source file>        or    ifd=<hdd num>\n"
           "  of=<target file>        or    ofd=<hdd num>\n"
           "  bs=<blocksize>[units]   default unit 'o', other available: k\n"
           "  iobs=<blocksize>[units] default unit 'o', other available: k, b\n"
           "  ioseek=<offset>[units]  default unit 'b'\n"
           "                            set both SRC & DST positions\n"
           "  seek=<offset>[units]    default unit 'b'\n"
           "                            set SRC positions\n"
           "  offs=<offset>[units]    default unit 'b'\n"
           "                            set DST positions\n"
           "Units:\n"
           "  o - bytes (octets)      b - blocks\n"
           "  k - KBytes)             M - MBytes             G - GBytes\n"
           "Note:\n"
           "  1 KByte = 1024 bytes\n"
           "  1 MByte = 1024 KBytes = 1024*1024 bytes\n"
           "  if byte offset or byte count is specified, it will be rounded to blocksize\n"
           "Examples:\n"
           "  bbcopy.exe -o 5000000 X:\\Video.dat E:\\Temp\\Restored_Film.dat\n"
           "    will copy data starting from byte offset 5000000 to end of file\n"
           "  bbcopy.exe -om 1300 -cm 1000 X:\\Video.dat E:\\Temp\\Restored_Film.dat\n"
           "    will copy not more than 1000Mb of data starting from byte offset 1300Mb\n"
           "  bbcopy.exe -f -r 1 -b 512 -Bk 64 -l hdd.log \\\\.\\\\PhysicalDrive2 \\\\.\\\\PhysicalDrive3\n"
           "    will copy from harddisk2 to harddisk3 with optimal transfer block 64k\n"
           "    if 64k cannot be read, fall back to 512 bytes blocks for damaged area\n"
          );
    exit(0);
} // end print_help()

__int64
get_file_size(
    HANDLE h,
    BOOLEAN* is_dev
    )
{
    LONG hsz = 0;
    LONG lsz;
    __int64 sz;
    ULONG status;
    ULONG returned;
    DISK_GEOMETRY  DiskGeometry;

    if(is_dev) {
        *is_dev = FALSE;
    }

    lsz = SetFilePointer(h, 0, &hsz, FILE_END);
    if(lsz != -1 && hsz != -1) {
        ((PULONG)(&sz))[1] = hsz;
        ((PULONG)(&sz))[0] = lsz;
        return sz;
    }

    status = DeviceIoControl(h,
                             IOCTL_DISK_GET_DRIVE_GEOMETRY,
                             &DiskGeometry,sizeof(DISK_GEOMETRY),
                             &DiskGeometry,sizeof(DISK_GEOMETRY),
                             &returned,
                             FALSE);
    if(!status) {
        status = GetLastError();
        return -1;
    }

    if(is_dev) {
        *is_dev = TRUE;
    }
    sz = (DiskGeometry.Cylinders.QuadPart *
          DiskGeometry.TracksPerCylinder *
          DiskGeometry.SectorsPerTrack)*
          DiskGeometry.BytesPerSector;
    if(sz > 0) {
        bs = DiskGeometry.BytesPerSector;
        return sz;
    }

    return -1;
} // end get_file_size()

__int64
set_file_pointer(
    HANDLE h,
    __int64 sz
    )
{
    ULONG hsz = ((PULONG)(&sz))[1];
    ULONG lsz = ((PULONG)(&sz))[0];

    lsz = SetFilePointer(h, lsz, (PLONG)&hsz, FILE_BEGIN);
    if(lsz != -1 && hsz != -1) {
        ((PULONG)(&sz))[1] = hsz;
        ((PULONG)(&sz))[0] = lsz;
        return sz;
    }
    return 0;
} // end set_file_pointer()

int
set_file_size(
    HANDLE h,
    __int64 sz
    )
{
    set_file_pointer(h, sz);
    return SetEndOfFile(h);
} // end set_file_size()

void
fill_buffer(
    char* buff,
    ULONG bs,
    PWCHAR fill_stringW,
    PCHAR fill_stringA
    )
{
    if(!fill_stringA && !fill_stringW) {
        memset(buff, 0, bs);
    } else {
        if(!buff_template) {
            int tail = bs;
            int d;
            char* p_buff = buff;

            buff_template = (char*)GlobalAlloc(GMEM_FIXED, iobs);
            if(!buff_template) {
                memset(buff, 0, bs);
                return;
            }

            p_buff = buff_template;
            tail = iobs;

            while(tail > 0) {
                if(GetVersion() & 0x80000000) {
                    d = _snprintf(p_buff, tail, "%s", fill_stringA);
                } else {
                    d = _snprintf(p_buff, tail, "%S", fill_stringW);
                }
                tail -= d;
                p_buff += d;
            }
        }
        memcpy(buff, buff_template, bs);
    }
} // end fill_buffer()

#include "copy_fragment.h"

#pragma warning(push)               
#pragma warning(disable:4005)
#define XCHAR    CHAR
#define get_num  get_numA
#include "get_num.cpp.h"

#define XCHAR    WCHAR
#define get_num  get_numW
#include "get_num.cpp.h"
#pragma warning(pop)

void print_result() {
    printf("Copied %I64d bytes (%I64d blocks)\n"
           "       %I64d unreliable (%I64d blocks)\n"
           "       %I64d in bad blocks (%I64d blocks)\n", copy_count, copy_count/bs, susp, susp/bs, bads, bads/bs);
} // end print_result()

void main(void) {
    int i, j, n;
    WCHAR a;
    ULONG r;
    ULONG xbs;
    ULONG err = 0;
   
    int break_sw;
    int block_seek = 0;
    int block_offs = 0;
    int block_counter = 0;
    int block_iobs = 0;
    __int64 seek = 0;
    __int64 offs = 0;
    __int64 counter = 0;
    __int64 f_size;
    __int64 f_ptr;
    __int64 o_ptr;
    __int64 out_size;
    
    ULONG max_cached; // Gb

    in_nameW = NULL;    
    out_nameW = NULL;   
    log_nameW = NULL;   
    fill_stringW = NULL;

    in_nameA = NULL;    
    out_nameA = NULL;   
    log_nameA = NULL;   
    fill_stringA = NULL;
    
    bs = 2048;     
    iobs = 64*1024;
    retry = 3;     

    bads = 0;
    susp = 0;
    copy_count = 0;

    char* buff;
    ULONG read_bytes;
    int ok;
    __int64 p;
    int prc, prc0;

    WCHAR* CmdLineW;
    PWCHAR* argvW;
    CHAR*  CmdLineA;
    PCHAR* argvA;
    int argc;

    HANDLE in_h;
    HANDLE out_h;
    HANDLE log_h = NULL;

    BOOLEAN in_is_dev = FALSE;
    BOOLEAN out_is_dev = FALSE;
    BOOLEAN out_is_nul = FALSE;

    printf("Scratched File and Bad Block Copy utility v2.3 (c) by Alter, 2004-2014\n"
           "Home site http://www.alter.org.ua\n");

    if(GetVersion() & 0x80000000) {
        printf("Warning: running under Windows 9x family\n"
               "  You may experience 2Gb or 4Gb limitation.\n");
//        exit(1);
        max_cached = 2;

        CmdLineA = GetCommandLineA();
        argvA = CommandLineToArgvA(CmdLineA, &argc);

#pragma warning(push)               
#pragma warning(disable:4005)
#define argv     argvA
#define in_name  in_nameA
#define out_name out_nameA
#define log_name log_nameA
#define in_devname   in_devnameA
#define out_devname  out_devnameA
#define fill_string  fill_stringA
#define xsprintf sprintf
#define xcslen   strlen
#define xscanf   sscanf
#define xprintf  printf
#define xstrcmp  strcmp
#define xstrncmp  strncmp
#define CreateFileX   CreateFileA
#define XT(a)    a
#define XCHAR    CHAR
#define get_num  get_numA
#define open_all open_allA
#pragma warning(pop)

        #include "parse_args.cpp.h"

        #include "open_all.cpp.h"

    } else {
        CmdLineW = GetCommandLineW();
        argvW = CommandLineToArgvW(CmdLineW, &argc);

        max_cached = 100;

#pragma warning(push)               
#pragma warning(disable:4005)
//#pragma warning(disable:6311)
#define argv     argvW
#define in_name  in_nameW
#define out_name out_nameW
#define log_name log_nameW
#define in_devname   in_devnameW
#define out_devname  out_devnameW
#define fill_string  fill_stringW
#define xsprintf swprintf
#define xcslen   wcslen
#define xscanf   swscanf
#define xprintf  wprintf
#define xstrcmp  wcscmp
#define xstrncmp  wcsncmp
#define CreateFileX   CreateFileW
#define XT(a)    L##a
#define XCHAR    WCHAR
#define get_num  get_numW
#define open_all open_allW
#pragma warning(pop)

        #include "parse_args.cpp.h"

        #include "open_all.cpp.h"

    }

    if(block_iobs) {
        iobs *= bs;
    }

    if((iobs < bs) || (iobs % bs)) {
        printf("I/O block size (%d) must be integral multiple of physical block size (%d)\n"
               "exiting...\n", iobs, bs);
        exit (-2);
    }
    buff = (char*)GlobalAlloc(GMEM_FIXED, iobs);
    if(!buff) {
        printf("Can't alloc %d bytes for temporary buffer\n"
               "exiting...\n", bs);
        exit (-2);
    }

    f_size = get_file_size(in_h, &in_is_dev);
    if(!f_size) {
        if(GetVersion() & 0x80000000) {
            printf("Empty source file %s\n"
                   "exiting...\n", out_nameA);
        } else {
            wprintf(L"Empty source file %s\n"
                   L"exiting...\n", out_name);
        }
        exit (-4);
    }
    if(f_size < 0) {
        if(GetVersion() & 0x80000000) {
            printf("Can't get source file size: %s\n"
                   "exiting...\n", out_nameA);
        } else {
            wprintf(L"Can't get source file size: %s\n"
                   L"exiting...\n", out_name);
        }
        exit (-4);
    }

    // block devices and too long files are not necessary to be cached
    if(!no_cache &&
       (in_is_dev || out_is_dev || (f_size >= (__int64)((unsigned __int64)1024*1024*1024*(unsigned __int64)max_cached))) ) {
        // reopen with NO_CACHE

        if(in_is_dev || out_is_dev) {
            printf("Force using NO_CACHE on block devices\n");
        } else {
            printf("Force using NO_CACHE on large file\n");
        }

        no_cache = 1;

        CloseHandle(in_h);
        in_h = NULL;
        CloseHandle(out_h);
        out_h = NULL;

        if(GetVersion() & 0x80000000) {
#pragma warning(push)               
#pragma warning(disable:4005)
#define open_all open_allA
#pragma warning(pop)
        #include "open_all.cpp.h"
        } else {
#pragma warning(push)               
#pragma warning(disable:4005)
#define open_all open_allW
        #include "open_all.cpp.h"
#pragma warning(pop)
        }
    }

    out_size = get_file_size(out_h, &out_is_dev);
    if(block_offs) {
        offs *= bs;
    }
    if(block_seek) {
        seek *= bs;
    }
    if(block_counter) {
        counter *= bs;
    }

    if(out_is_dev) {
        if(offs+counter > out_size) {
            if(GetVersion() & 0x80000000) {
                printf("Target device %s too small: %I64d bytes, required %I64d\n"
                       "exiting...\n", out_nameA, out_size, offs+counter);
            } else {
                wprintf(L"Target device %s too small: %I64d bytes, required %I64d\n"
                        L"exiting...\n", out_name, out_size, offs+counter);
            }
            exit (-5);
        }
        if(!counter && (f_size-offs > out_size)) {
            if(GetVersion() & 0x80000000) {
                printf("Target device %s too small: %I64d bytes, required %I64d\n"
                       "exiting...\n", out_nameA, out_size, offs+counter);
            } else {
                wprintf(L"Target device %s too small: %I64d bytes, required %I64d\n"
                        L"exiting...\n", out_name, out_size, offs+counter);
            }
            exit (-5);
        }
    } else 
    if(!out_is_nul && (offs > out_size)) {
        printf("Setting output file initial size to %I64d bytes... ",
               offs);
        if(!set_file_size(out_h, offs)) {
            if(GetVersion() & 0x80000000) {
                printf("\nCan't set size of target file %s to %I64d bytes\n"
                       "exiting...\n", out_nameA, f_size);
            } else {
                wprintf(L"\nCan't set size of target file %s to %I64d bytes\n"
                       L"exiting...\n", out_name, f_size);
            }
            exit (-5);
        }
        printf("Done\n");
        out_size = get_file_size(out_h, &out_is_dev);
    }
    // align offs and counter
    if(in_is_dev || out_is_dev) {
        xbs = bs;
        while(xbs) {
            if((xbs & 1) && (xbs != 1)) {
                printf("Block device: Bad block size %d bytes - must be integral multiple of 2\n",
                       offs, bs);
                //exit(-11);
            }
            xbs = xbs >> 1;
        }
        if(offs & ((unsigned __int64)(bs-1))) {
            printf("Block device: Bad output offset %I64d bytes - must be aligned on block size (%d bytes)\n",
                   offs, bs);
            exit(-10);
        }
        if(seek & ((unsigned __int64)(bs-1))) {
            printf("Block device: Bad input offset (seek) %I64d bytes - must be aligned on block size (%d bytes)\n",
                   seek, bs);
            exit(-10);
        }
    }

    seek = seek & ~((unsigned __int64)(bs-1));
    offs = offs & ~((unsigned __int64)(bs-1));
    counter = (counter + bs - 1) & ~((unsigned __int64)(bs-1));

    f_ptr = seek;
    o_ptr = offs;

    if(GetVersion() & 0x80000000) {
        printf("%s -> %s\n%I64d bytes\n",
               in_nameA, out_nameA, f_size);
    } else {
        wprintf(L"%s -> %s\n%I64d bytes\n",
               in_name, out_name, f_size);
    }
    printf("  %I64d blocks, physical block size %d bytes, I/O block size %d bytes\n",
           f_size/bs, bs, iobs);
    printf("Starting from offset %I64d bytes\n",
           seek);
    printf("  to target at offset %I64d bytes\n",
           offs);
    if(counter) {
        printf("Recovery range %I64d bytes (%I64d blocks)\n",
               counter, counter/bs);
    }

    if(counter) {
        p = copy_count/50;
    } else {
        p = f_size/50;
    }
    if(!p) p = 1;
    prc0 = -1;

    while(f_ptr <= f_size-bs) {
        if(counter && copy_count >= counter) {
            print_result();
            exit(0);
        }
        if(counter) {
            prc = (int)(copy_count/p);
        } else {
            prc = (int)(f_ptr/p);
        }
        if( prc0 != prc) {
            prc0 = prc;
            printf((prc % 10 == 9) ? "*" : ".");
        }
        if(counter && (counter-copy_count < iobs)) {
            xbs = (ULONG)(counter-copy_count);
        } else
        if(f_size - f_ptr < iobs) {
            xbs = bs;
        } else {
            xbs = iobs;
        }
        ok = copy_fragment(in_h, out_h, log_h, buff, xbs, &r, f_ptr, o_ptr);

        if(ok < 0) {
            printf("Stop on output error\n");
            print_result();
            exit(-9);
        }
        if(!ok && fall_back && (xbs > bs)) {
            bads -= xbs;
            n = xbs/bs;
            err++;
            while(n && (f_ptr <= f_size-bs)) {
                ok = copy_fragment(in_h, out_h, log_h, buff, bs, &r, f_ptr, o_ptr);
                if(ok < 0) {
                    printf("Stop on output error\n");
                    print_result();
                    exit(-9);
                }
                f_ptr += bs;
                o_ptr += bs;
                copy_count += bs;
                n--;
            }
        } else {
            err = 0;
            f_ptr += xbs;
            o_ptr += xbs;
            copy_count += xbs;
        }
        if(max_errors && err > max_errors) {
            printf("Too long unreadable area: %d bytes (%d blocks)\n", err*iobs, err*iobs/bs);
            print_result();
            exit(-8);
        }
    }

    printf("\n");
    if(f_size < f_ptr ||
        f_size - f_ptr > bs) {
        printf("Can't copy file tail (%I64d bytes)\n", f_size - f_ptr);
        exit(-7);
    }
    xbs = (ULONG)(min(iobs, f_size - f_ptr));
    if(!xbs || (counter && copy_count >= counter)) {
        print_result();
        exit(0);
    }

/*
    fill_buffer(buff, bs, fill_stringW, fill_stringA);
    set_file_pointer(in_h, f_ptr);
    set_file_pointer(out_h, f_ptr);
    ReadFile(in_h, buff, bs, &read_bytes, NULL);
    if(read_bytes != bs) {
        printf("Can't read block at offset %I64d\n", f_ptr);
        bads += bs;
    }
    WriteFile(out_h, buff, bs, &read_bytes, NULL);
    if(read_bytes != bs) {
        printf("Can't write block at offset %I64d\n", f_ptr);
    }
    copy_count += bs;
*/

    if(counter && (counter-copy_count < iobs)) {
        xbs = (ULONG)(counter-copy_count);
    } else
    if(f_size - f_ptr < iobs) {
        xbs = (ULONG)(f_size - f_ptr);
        if(in_is_dev || out_is_dev) {
          xbs &= ~(bs-1);
        }
    } else {
        xbs = iobs;
    }

    if((xbs & (bs-1)) && no_cache && !(in_is_dev || out_is_dev)) {
        CloseHandle(in_h);
        in_h = NULL;
        CloseHandle(out_h);
        out_h = NULL;

        if(GetVersion() & 0x80000000) {
#pragma warning(push)               
#pragma warning(disable:4005)
#define open_all open_allA
#pragma warning(pop)
        #include "open_all.cpp.h"
        } else {
#pragma warning(push)               
#pragma warning(disable:4005)
#define open_all open_allW
        #include "open_all.cpp.h"
#pragma warning(pop)
        }
    }

    ok = copy_fragment(in_h, out_h, log_h, buff, xbs, &r, f_ptr, o_ptr);
    if(ok < 0) {
        printf("Stop on output error\n");
        print_result();
        exit(-9);
    }
    //#define set_filler set_filler2
    //#include "copy_fragment.h"
    if(!ok && fall_back && (xbs > bs)) {
        bads -= xbs;
        n = xbs/bs;
        while(n && (f_ptr <= f_size-bs)) {
            ok = copy_fragment(in_h, out_h, log_h, buff, bs, &r, f_ptr, o_ptr);
            if(ok < 0) {
                printf("Stop on output error\n");
                print_result();
                exit(-9);
            }
            f_ptr += bs;
            o_ptr += bs;
            copy_count += bs;
            n--;
        }
    } else {
        f_ptr += xbs;
        o_ptr += xbs;
        copy_count += xbs;
    }

    print_result();
    exit(0);
} // end main()
	