

    if(argc < 3) {
        xprintf(XT("Too few arguments: %d\n"),
                argc);
        print_help();
    }

    for(i=1; i<argc; i++) {
        if(!argv[i])
            continue;
        if(argv[i][0] != '-') {
            if(!xstrncmp(argv[i], XT("if="), 3)) {
                in_name = argv[i]+3;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("ifd="), 4)) {
                xscanf(argv[i]+4, XT("%d"), &n);
                in_name = in_devname;
                xsprintf(in_devname, XT("\\\\.\\PhysicalDrive%d"), n);
                in_is_dev = 1;
                bs = 512;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("ifc="), 4)) {
                xscanf(argv[i]+4, XT("%d"), &n);
                in_name = in_devname;
                xsprintf(in_devname, XT("\\\\.\\CdRom%d"), n);
                in_is_dev = 1;
                bs = 2048;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("of="), 3)) {
                out_name = argv[i]+3;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("ofd="), 4)) {
                xscanf(argv[i]+4, XT("%d"), &n);
                out_name = out_devname;
                xsprintf(out_devname, XT("\\\\.\\PhysicalDrive%d"), n);
                out_is_dev = 1;
                bs = 512;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("ofc="), 4)) {
                xscanf(argv[i]+4, XT("%d"), &n);
                out_name = out_devname;
                xsprintf(out_devname, XT("\\\\.\\CdRom%d"), n);
                out_is_dev = 1;
                bs = 2048;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("log="), 3)) {
                log_name = argv[i]+4;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("bs="), 3)) {
                xscanf(argv[i]+3, XT("%d"), &bs);
                mlt = get_num(argv[i]+3, NULL);
                if(mlt && (mlt <= 1024)) {
                    // ok
                } else {
                    printf("Invalid value for 'bs'\n");
                    print_help();
                }
                bs *= (ULONG)mlt;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("iobs="), 5)) {
                xscanf(argv[i]+5, XT("%d"), &iobs);
                block_iobs = TRUE; // set default
                mlt = get_num(argv[i]+5, &block_iobs);
                iobs *= (ULONG)mlt;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("count="), 6)) {
                xscanf(argv[i]+6, XT("%I64d"), &counter);
                block_counter = TRUE;
                mlt = get_num(argv[i]+6, &block_counter);
                counter *= mlt;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("ioseek="), 7)) {
                xscanf(argv[i]+7, XT("%I64d"), &seek);
                block_seek = TRUE;
                mlt = get_num(argv[i]+7, &block_seek);
                seek *= mlt;
                offs = seek;
                block_offs = block_seek;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("seek="), 5)) {
                xscanf(argv[i]+5, XT("%I64d"), &seek);
                block_seek = TRUE;
                mlt = get_num(argv[i]+5, &block_seek);
                seek *= mlt;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("offs="), 5)) {
                xscanf(argv[i]+5, XT("%I64d"), &offs);
                block_offs = TRUE;
                mlt = get_num(argv[i]+5, &block_offs);
                offs *= mlt;
                continue;
            } else
            if(!xstrncmp(argv[i], XT("retry="), 6)) {
                xscanf(argv[i]+6, XT("%d"), &retry);
                continue;
            } else
            if(!in_name) {
                in_name = argv[i];
                continue;
            } else
            if(!out_name) {
                out_name = argv[i];
                continue;
            } else {
                xprintf(XT("Unknown option '%s'\n"),
                        argv[i]);
                print_help();
            }
        }
        j=1;
        break_sw = 0;
        while(!break_sw &&
              (a = argv[i][j]) && (a != ' ') && (a != '\t')) {
            switch(a) {
            case 'b' :
                switch(a) {
                case 'k':
                    i++;
                    if(!argv[i]) {
                        xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                        print_help();
                    }
                    xscanf(argv[i], XT("%d"), &bs);
                    bs *= 1024;
                    break;
                default:
                    i++;
                    if(!argv[i]) {
                        xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                        print_help();
                    }
                    xscanf(argv[i], XT("%d"), &bs);
                }
                break_sw = 1;
                break;
            case 'B' :
                a = argv[i][j+1];
                switch(a) {
                case 'k':
                    i++;
                    if(!argv[i]) {
                        xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                        print_help();
                    }
                    xscanf(argv[i], XT("%d"), &iobs);
                    iobs *= 1024;
                    break;
                default:
                    i++;
                    if(!argv[i]) {
                        xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                        print_help();
                    }
                    xscanf(argv[i], XT("%d"), &iobs);
                }
                break_sw = 1;
                break;
            case 'l' :
                i++;
                if(!argv[i]) {
                    xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                    print_help();
                }
                log_name = argv[i];
                break_sw = 1;
                break;
            case 'f' :
                fall_back = 1;
                break_sw = 1;
                break;
            case 'S' :
                i++;
                if(!argv[i]) {
                    xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                    print_help();
                }
                fill_string = argv[i];
                break_sw = 1;
                break;
            case 's':
                fill_string = XT("** BAD BLOCK **");
                break_sw = 1;
                break;
            case 'o' :
                a = argv[i][j+1];
                block_seek = FALSE;
                mlt = get_num(&(argv[i][j+1]), &block_seek);
                i++;
                if(!argv[i]) {
                    xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                    print_help();
                }
                xscanf(argv[i], XT("%I64d"), &seek);
                seek *= mlt;
                offs = seek;
                break_sw = 1;
                break;
            case 'c' :
                a = argv[i][j+1];
                block_counter = FALSE;
                mlt = get_num(&(argv[i][j+1]), &block_counter);
                i++;
                if(!argv[i]) {
                    xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                    print_help();
                }
                xscanf(argv[i], XT("%I64d"), &counter);
                counter *= mlt;
                break_sw = 1;
                break;
            case 'r' :
                i++;
                if(!argv[i]) {
                    xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                    print_help();
                }
                xscanf(argv[i], XT("%d"), &retry);
                break_sw = 1;
                break;
            case 'e' :
                i++;
                if(!argv[i]) {
                    xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                    print_help();
                }
                xscanf(argv[i], XT("%d"), &max_errors);
                break_sw = 1;
                break;
            case 'n' :
                no_cache = 1;
                break_sw = 1;
                break;
            case 'd' :
                a = argv[i][j+1];
                switch(a) {
                case 'i':
                    i++;
                    if(!argv[i]) {
                        xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                        print_help();
                    }
                    xscanf(argv[i], XT("%d"), &n);
                    in_name = in_devname;
                    xsprintf(in_devname, XT("\\\\.\\PhysicalDrive%d"), n);
                    in_is_dev = 1;
                    bs = 512;
                    break;
                case 'o':
                    i++;
                    if(!argv[i]) {
                        xprintf(XT("Missing value after '%s'\n"), argv[i-1]);
                        print_help();
                    }
                    xscanf(argv[i], XT("%d"), &n);
                    out_name = out_devname;
                    xsprintf(out_devname, XT("\\\\.\\PhysicalDrive%d"), n);
                    out_is_dev = 1;
                    bs = 512;
                    break;
                default:
                    xprintf(XT("Unknown option '%s'\n"), argv[i]);
                    print_help();
                    break;
                }
                break_sw = 1;
                break;
            case '?' :
            default:
                xprintf(XT("Unknown option '%s'\n"), argv[i]);
                print_help();
            }
            j++;
        }
    }
    // final checks
    if(!bs)
        bs = 2048;
    if(!iobs) {
        if(!block_iobs) {
            iobs = 64*1024;
        } else {
            iobs = 64*1024/bs;
        }
    }
    if(!retry) {
        retry = 1;
    }

    if(!in_name || !out_name) {
        xprintf(XT("Both source and destination are required\n"));
        print_help();
    }

    if(log_name) {
        log_h = CreateFileX(log_name, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ,
                          NULL,
                          CREATE_ALWAYS,
                          FILE_ATTRIBUTE_NORMAL /*| FILE_FLAG_NO_BUFFERING*//* | FILE_FLAG_SEQUENTIAL_SCAN*/,
                          NULL);
        if(log_h == (HANDLE)(-1)) {
            read_bytes = GetLastError();
            xprintf(XT("Can't create log file %s\n")
                   XT("exiting...\n"), log_name);
            exit (-6);
        }
    }
