.486p
.model flat
.code

include empty.h
include kb.h
include file.h
include 6502.h
include ppu.h
include data.h
include equates.h
include debug.h
include memory.h
include map00.h

public mapperinit24
;----------------------------------------------------------------------------
mapperinit24:;  VRC6: cv3j
;----------------------------------------------------------------------------
        mov [write_tbl+4*4],offset Write8000
        mov [write_tbl+5*4],offset WriteA000
        mov [write_tbl+6*4],offset WriteC000
        mov [write_tbl+7*4],offset WriteE000

        mov [irqen],0
        mov [count],0
        mov [scanlinehook],offset hook

        mov al,-1
        jmp map89ABCDEF
;----------------------------------------------------------------------------
Write8000:;
;----------------------------------------------------------------------------
        cmp edi,9000h
        jae Write9000
        if DEBUG
                cmp edi,8000h
                ja empty_W
        endif
        call map89AB
	jmp flush
Write9000:
        ;sound
        ret
;----------------------------------------------------------------------------
WriteA000:;
;----------------------------------------------------------------------------
        cmp edi,0b000h
        jae WriteB000
        ;sound
        ret
WriteB000:
        and edi,3
        cmp edi,3
        je wB03
        ;sound
        ret
wB03:
mov [prof0],eax
        test al,8
        jnz wB01
        test al,4
        jmp mirror2V
wB01:
        test al,4
        jmp mirror1
        ret
;----------------------------------------------------------------------------
WriteC000:
;----------------------------------------------------------------------------
        cmp edi,0d000h
        jae WriteD000
        if DEBUG
                cmp edi,0c000h
                jne empty_W
        endif
        call mapCD
        jmp flush
WriteD000:
        mov ebp,edi
        and edi,2000h
        and ebp,3
        shr edi,11
        or edi,ebp

	shl eax,12
	and eax,[chrmask]
	add eax,[chr_ptr]
	mov [chr_map+edi*4],eax
	jmp newchrmap
;----------------------------------------------------------------------------
WriteE000:;
;----------------------------------------------------------------------------
        cmp edi,0f000h
        jb WriteD000
        and edi,3
        jmp [writeFtbl+edi*4]
        ret
wF0:;- - - - - - - - - - - - - - -
        mov [latch],al
        ret
wF1:;- - - - - - - - - - - - - - -
        and [int_flags],not IRQ
        mov [irqen],al
        test al,2
        jz wF10
        mov al,[latch]
        mov [count],al
wF10:   ret
wF2:;- - - - - - - - - - - - - - -
        and [int_flags],not IRQ
        and [irqen],1
        jz wF20
        mov al,[latch]
        mov [count],al
        or [irqen],2
wF20:   ret

writeFtbl dd wF0,wF1,wF2,empty_W
;----------------------------------------------------------------------------
hook:;
;----------------------------------------------------------------------------
        test [irqen],2          ;timer active?
        jz h0
 
        inc [count]         ;time's up?
        jnz h0
        or [int_flags],IRQ      ;trigger IRQ
        mov al,[latch]
        mov [count],al
h0:
        ret
;----------------------------------------------------------------------------
                align 4

count           equ     mapperdata+0
latch           equ     mapperdata+1
irqen           equ     mapperdata+2
;----------------------------------------------------------------------------
        end
