.486p
.model flat
.code

include empty.h
include kb.h
include file.h
include 6502.h
include ppu.h
include data.h
include equates.h
include debug.h
include memory.h
include map00.h

public mapperinit21
public mapperinit25
;----------------------------------------------------------------------------
mapperinit21:;  gradius 2, waiwai world 2..
mapperinit25:;
;----------------------------------------------------------------------------
        mov [write_tbl+4*4],offset Write8000
        mov [write_tbl+5*4],offset WriteA000
        mov [write_tbl+6*4],offset WriteC000
        mov [write_tbl+7*4],offset WriteE000

        mov [irqen],0
        mov [countdown],0
        mov [scanlinehook],offset hook

        mov al,-1
        jmp map89ABCDEF
;----------------------------------------------------------------------------
Write8000:;
;----------------------------------------------------------------------------
        cmp edi,9000h
        jae Write9000
        if DEBUG
                cmp edi,8000h
                ja empty_W
        endif
        call map89
	jmp flush
Write9000:
        if DEBUG
                cmp edi,09007h
                ja empty_W
        endif
        and edi,7
        jmp [write9tbl+edi*4]
w90:;- - - - - - - - - - - - - - -
        test al,2
        jnz w901
        test al,1
        jmp mirror2V
w901:
        test al,1
        jmp mirror1
w91:;- - - - - - - - - - - - - - -
      ;  or [int_flags],DEBUG2
        ret
;----------------------------------------------------------------------------
WriteA000:;
;----------------------------------------------------------------------------
        cmp edi,0b000h
        jae WriteC000
if DEBUG
        cmp edi,0a000h
        ja empty_W
endif
	call mapAB
	jmp flush
;----------------------------------------------------------------------------
WriteC000:
;----------------------------------------------------------------------------
        mov ebp,edi     ;(edi=B/C/D/Exxx)
        and edi,3005h
        add edi,17ffh
        and edi,3800h
        shr edi,11

        test ebp,2
        jnz HiWrite

	and al,0fh
	and byte ptr [chr_xx+edi],0f0h
	jmp WriteDone
HiWrite:
	shl al,4
	and byte ptr [chr_xx+edi],0fh
WriteDone:
	or al,byte ptr [chr_xx+edi]
	mov byte ptr [chr_xx+edi],al
	shl eax,12
	and eax,[chrmask]
	add eax,[chr_ptr]
	mov [chr_map+edi*4],eax
	jmp newchrmap
;----------------------------------------------------------------------------
WriteE000:;
;----------------------------------------------------------------------------
        cmp edi,0f000h
        jb WriteC000
        if DEBUG
                cmp edi,0f007h
                ja empty_W
        endif
        and edi,7
        jmp [writeFtbl+edi*4]
wF0:;- - - - - - - - - - - - - - -
trace tMMC0,al
        and al,0fh
        and [latch],0f0h
        or [latch],al
        ret
wF1:;- - - - - - - - - - - - - - -
trace tMMC1,al
        and [int_flags],not IRQ
        mov [irqen],al
        mov al,[latch]
        mov [countdown],al
        ret
wF2:;- - - - - - - - - - - - - - -
trace tMMC2,al
        shl al,4
        and [latch],0fh
        or [latch],al
	ret
wF3:;- - - - - - - - - - - - - - -
trace tMMC3,al
        and [int_flags],not IRQ
	ret
;----------------------------------------------------------------------------
hook:;
;----------------------------------------------------------------------------
        test [irqen],2          ;timer active?
        jz h0
	
        inc [countdown]         ;time's up?
        jnz h0

        or [int_flags],IRQ      ;trigger IRQ
        mov al,[latch]
        mov [countdown],al
h0:
        ret
;----------------------------------------------------------------------------
                align 4
write9tbl       dd w90,w91,empty_W,empty_W,w91,w91,empty_W,empty_W
writeFtbl       dd wF0,wF1,wF2,wF3,wF1,wF1,wF3,wF3

countdown       equ     mapperdata+0    ;the counter :P
latch           equ     mapperdata+1
irqen           equ     mapperdata+2    ;counter enable
chr_xx          equ     mapperdata+3    ; 8 bytes!
;----------------------------------------------------------------------------
        end
