.486p
.model flat
.code

        include file.h
        include map00.h
        include data.h
        include empty.h
        include io.h
        include memory.h
        include equates.h
        include 6502.h
        include ppu.h
        include debug.h
        include kb.h

        public mapperinit05

;----------------------------------------------------------------------------
mapperinit05:;
;----------------------------------------------------------------------------
        mov eax,-1
        call map89ABCDEF

        mov [read_tbl+2*4],offset mapper05_R    ;intercept I/O port access
        mov [write_tbl+2*4],offset mapper05_W

        mov [scanlinehook],offset hook

        mov [prgsize],-1
        mov [irqoccur],0

        ret
;----------------------------------------------------------------------------
mapper05_R:;
;----------------------------------------------------------------------------
        cmp edi,5000h
        jb IO_R
        mov ebp,edi
        shr ebp,8
        jmp [readX+ebp*4-50h*4]
;----------------------------------------------------------------------------
mapper05_W:;
;----------------------------------------------------------------------------
        cmp edi,5000h
        jb IO_W
        mov ebp,edi
        shr ebp,8
        jmp [writeX+ebp*4-50h*4]
;----------------------------------------------------------------------------
r52xx:;
;----------------------------------------------------------------------------
        cmp edi,5217h
        ja empty_R
        jmp [read2+edi*4-5200h*4]
;----------------------------------------------------------------------------
w50xx:;         sound stuff
;----------------------------------------------------------------------------
        cmp edi,5017h
        ja empty_W
        jmp [write0+edi*4-5000h*4]
;----------------------------------------------------------------------------
w51xx:;
;----------------------------------------------------------------------------
        cmp edi,512fh
        ja empty_W
        jmp [write1+edi*4-5100h*4]
;----------------------------------------------------------------------------
w52xx:;
;----------------------------------------------------------------------------
        cmp edi,5217h
        ja empty_W
        jmp [write2+edi*4-5200h*4]
;----------------------------------------------------------------------------
w5010:;
;----------------------------------------------------------------------------
        ret
;----------------------------------------------------------------------------
w5100:;
;----------------------------------------------------------------------------
        and al,3
        mov [prgsize],al
        ret
;----------------------------------------------------------------------------
w5101:;
;----------------------------------------------------------------------------
        and al,3
        mov [chrsize],al
        ret
;----------------------------------------------------------------------------
w5104:;
;----------------------------------------------------------------------------
        ret
;----------------------------------------------------------------------------
w5105:;         mirror setting
;----------------------------------------------------------------------------
	mov ah,al
	shr al,6
	movzx edi,al
	shl edi,10	;0-3*400
	add edi,02000h+offset vram
	mov [name3_map],edi

	mov al,ah
	shr al,4
	and al,3
	movzx edi,al
	shl edi,10
	add edi,02000h+offset vram
	mov [name2_map],edi

	mov al,ah
	shr al,2
	and al,3
	movzx edi,al
	shl edi,10
	add edi,02000h+offset vram
	mov [name1_map],edi

	mov al,ah
	and al,3
	movzx edi,al
	shl edi,10
	add edi,02000h+offset vram
	mov [name0_map],edi

	ret	;Do some weirdo stuff here.

;-------
        mov edi,offset vram+2000h
        test al,10101010b
        jnz w5105_0
        
        mov [name0_map],edi
        mov [name1_map],edi
        mov [name2_map],edi
        mov [name3_map],edi

        mov edi,400h

        test al,00000001b
        jz w5105_1
        add [name0_map],edi
w5105_1:
        test al,00000100b
        jz w5105_2
        add [name1_map],edi
w5105_2:
        test al,00010000b
        jz w5105_3
        add [name2_map],edi
w5105_3:
        test al,01000000b
        jz w5105_4
        add [name3_map],edi
w5105_4:
        ret

w5105_0:                                ;exram?
if DEBUG
    ;    or [int_flags],DEBUG2
        mov [debugmsg],offset msg47
endif
        ret
;----------------------------------------------------------------------------
w5106:;
;----------------------------------------------------------------------------
        ret
;----------------------------------------------------------------------------
w5107:;
;----------------------------------------------------------------------------
        ret
;----------------------------------------------------------------------------
w5115:;
;----------------------------------------------------------------------------
        cmp [prgsize],0
        je void

        cmp [prgsize],2
        ja w5115_3

        shr al,1
        call map89AB
        jmp flush
w5115_3:
        call mapAB
        jmp flush
;----------------------------------------------------------------------------
w5116:;
;----------------------------------------------------------------------------
        cmp [prgsize],2
        jb void

        call mapCD
        jmp flush
;----------------------------------------------------------------------------
w5120:;
;----------------------------------------------------------------------------
trace tMMC0,al
        shl eax,12
        and eax,[chrmask]
        add eax,[chr_ptr]
        mov [chr_map+0],eax
        call newchrmap
        ret
w5121:
trace tMMC1,al
        shl eax,12
        and eax,[chrmask]
        add eax,[chr_ptr]
        mov [chr_map+4],eax
        call newchrmap
        ret
w5122:
trace tMMC2,al
        shl eax,12
        and eax,[chrmask]
        add eax,[chr_ptr]
        mov [chr_map+8],eax
        call newchrmap
        ret
w5123:
trace tMMC3,al
        shl eax,12
        and eax,[chrmask]
        add eax,[chr_ptr]
        mov [chr_map+12],eax
        call newchrmap
        ret
w5124:
trace tMMC4,al
        mov [chr04],al
        ret
w5125:
trace tMMC5,al
        mov [chr05],al
        ret
w5126:
trace tMMC6,al
        mov [chr06],al
        ret
w5127:
trace tMMC7,al
        mov [chr07],al
        ret
w5128:
trace tMMC8,al
        shl eax,12
        and eax,[chrmask]
        add eax,[chr_ptr]
        mov [chr_map+16],eax
        call newchrmap
        ret
w5129:
trace tMMC9,al
        shl eax,12
        and eax,[chrmask]
        add eax,[chr_ptr]
        mov [chr_map+20],eax
        call newchrmap
        ret
w512a:
trace tMMCA,al
        shl eax,12
        and eax,[chrmask]
        add eax,[chr_ptr]
        mov [chr_map+24],eax
        call newchrmap
        ret
w512b:
trace tMMCB,al
        shl eax,12
        and eax,[chrmask]
        add eax,[chr_ptr]
        mov [chr_map+28],eax
        call newchrmap
        ret
;----------------------------------------------------------------------------
w5200:;
;----------------------------------------------------------------------------
        ret
;----------------------------------------------------------------------------
w5203:;
;----------------------------------------------------------------------------
; trace tMMC0,al
;        inc al
        mov [irqline],al
        ret
;----------------------------------------------------------------------------
r5204:;
;----------------------------------------------------------------------------
 trace tMMC2,al
        mov al,[irqoccur]

        and [int_flags],not IRQ ;?
        mov [irqoccur],00h      ;?

        ret
;----------------------------------------------------------------------------
w5204:;
;----------------------------------------------------------------------------
 trace tMMC1,al
        mov [irqen],al

        ret
;----------------------------------------------------------------------------
hook:;
;----------------------------------------------------------------------------
        movzx eax,[irqline]
        cmp [scanline],eax
        jne h0

        mov [irqoccur],40h

        test [irqen],80h
        jz h0

        or [int_flags],IRQ
h0:
        ret
;----------------------------------------------------------------------------
        align 4

readX           dd      empty_R                 ;$50xx
                dd      empty_R                 ;$51xx
                dd      r52xx                   ;$52xx
                dd      empty_R                 ;$53xx
                dd      empty_R                 ;$54xx
                dd      empty_R                 ;$55xx
                dd      empty_R                 ;$56xx
                dd      empty_R                 ;$57xx
                dd      empty_R                 ;$58xx
                dd      empty_R                 ;$59xx
                dd      empty_R                 ;$5axx
                dd      empty_R                 ;$5bxx
                dd      empty_R                 ;$5cxx
                dd      empty_R                 ;$5dxx
                dd      empty_R                 ;$5exx
                dd      empty_R                 ;$5fxx

read2           dd      empty_R                 ;$5200
                dd      empty_R                 ;$5201
                dd      empty_R                 ;$5202
                dd      empty_R                 ;$5203
                dd      r5204                   ;$5204 
                dd      empty_R                 ;$5205
                dd      empty_R                 ;$5206
                dd      empty_R                 ;$5207
                dd      empty_R                 ;$5208
                dd      empty_R                 ;$5209
                dd      empty_R                 ;$520a
                dd      empty_R                 ;$520b
                dd      empty_R                 ;$520c
                dd      empty_R                 ;$520d
                dd      empty_R                 ;$520e
                dd      empty_R                 ;$520f
                dd      empty_R                 ;$5210
                dd      empty_R                 ;$5211
                dd      empty_R                 ;$5212
                dd      empty_R                 ;$5213
                dd      empty_R                 ;$5214
                dd      empty_R                 ;$5215
                dd      empty_R                 ;$5216
                dd      empty_R                 ;$5217

writeX          dd      w50xx                   ;$50xx
                dd      w51xx                   ;$51xx
                dd      w52xx                   ;$52xx
                dd      empty_W                 ;$53xx
                dd      empty_W                 ;$54xx
                dd      empty_W                 ;$55xx
                dd      empty_W                 ;$56xx
                dd      empty_W                 ;$57xx
                dd      empty_W                 ;$58xx
                dd      empty_W                 ;$59xx
                dd      empty_W                 ;$5axx
                dd      empty_W                 ;$5bxx
                dd      empty_W                 ;$5cxx
                dd      empty_W                 ;$5dxx
                dd      empty_W                 ;$5exx
                dd      empty_W                 ;$5fxx

write0          dd      empty_W                 ;$5000  sound stuff
                dd      empty_W                 ;$5001
                dd      empty_W                 ;$5002
                dd      empty_W                 ;$5003
                dd      empty_W                 ;$5004 
                dd      empty_W                 ;$5005
                dd      empty_W                 ;$5006
                dd      empty_W                 ;$5007
                dd      empty_W                 ;$5008
                dd      empty_W                 ;$5009
                dd      empty_W                 ;$500a
                dd      empty_W                 ;$500b
                dd      empty_W                 ;$500c
                dd      empty_W                 ;$500d
                dd      empty_W                 ;$500e
                dd      empty_W                 ;$500f
                dd      w5010                   ;$5010
                dd      empty_W                 ;$5011
                dd      empty_W                 ;$5012
                dd      empty_W                 ;$5013
                dd      empty_W                 ;$5014
                dd      empty_W                 ;$5015
                dd      empty_W                 ;$5016
                dd      empty_W                 ;$5017

write1          dd      w5100                   ;$5100
                dd      w5101                   ;$5101
                dd      empty_W                 ;$5102
                dd      empty_W                 ;$5103
                dd      w5104                   ;$5104 
                dd      w5105                   ;$5105
                dd      w5106                   ;$5106
                dd      w5107                   ;$5107
                dd      empty_W                 ;$5108
                dd      empty_W                 ;$5109
                dd      empty_W                 ;$510a
                dd      empty_W                 ;$510b
                dd      empty_W                 ;$510c
                dd      empty_W                 ;$510d
                dd      empty_W                 ;$510e
                dd      empty_W                 ;$510f
                dd      empty_W                 ;$5110
                dd      empty_W                 ;$5111
                dd      empty_W                 ;$5112
                dd      empty_W                 ;$5113
                dd      empty_W                 ;$5114 PRG bank
                dd      w5115                   ;$5115 PRG bank
                dd      w5116                   ;$5116 PRG bank
                dd      empty_W                 ;$5117 PRG bank
                dd      empty_W                 ;$5118
                dd      empty_W                 ;$5119
                dd      empty_W                 ;$511a
                dd      empty_W                 ;$511b
                dd      empty_W                 ;$511c
                dd      empty_W                 ;$511d
                dd      empty_W                 ;$511e
                dd      empty_W                 ;$511f
                dd      w5120                   ;$5120
                dd      w5121                   ;$5121
                dd      w5122                   ;$5122
                dd      w5123                   ;$5123
                dd      w5124                   ;$5124
                dd      w5125                   ;$5125
                dd      w5126                   ;$5126
                dd      w5127                   ;$5127
                dd      w5128                   ;$5128
                dd      w5129                   ;$5129
                dd      w512a                   ;$512a
                dd      w512b                   ;$512b
                dd      empty_W                 ;$512c
                dd      empty_W                 ;$512d
                dd      empty_W                 ;$512e
                dd      empty_W                 ;$512f

write2          dd      w5200                   ;$5200  split mode / irq stuff
                dd      empty_W                 ;$5201
                dd      empty_W                 ;$5202
                dd      w5203                   ;$5203
                dd      w5204                   ;$5204 
                dd      empty_W                 ;$5205
                dd      empty_W                 ;$5206
                dd      empty_W                 ;$5207
                dd      empty_W                 ;$5208
                dd      empty_W                 ;$5209
                dd      empty_W                 ;$520a
                dd      empty_W                 ;$520b
                dd      empty_W                 ;$520c
                dd      empty_W                 ;$520d
                dd      empty_W                 ;$520e
                dd      empty_W                 ;$520f
                dd      empty_W                 ;$5210
                dd      empty_W                 ;$5211
                dd      empty_W                 ;$5212
                dd      empty_W                 ;$5213
                dd      empty_W                 ;$5214
                dd      empty_W                 ;$5215
                dd      empty_W                 ;$5216
                dd      empty_W                 ;$5217

                align 4

prgsize         equ     mapperdata+0    ;5100
chrsize         equ     mapperdata+1    ;5101
irqen           equ     mapperdata+2    ;5204w
irqline         equ     mapperdata+3    ;5203
irqoccur        equ     mapperdata+4    ;5204r
chr00           equ     mapperdata+5    ;5120
chr01           equ     mapperdata+6    ;5121
chr02           equ     mapperdata+7    ;5122
chr03           equ     mapperdata+8    ;5123
chr04           equ     mapperdata+9    ;5124
chr05           equ     mapperdata+10   ;5125
chr06           equ     mapperdata+11   ;5126
chr07           equ     mapperdata+12   ;5127
chr08           equ     mapperdata+13   ;5128
chr09           equ     mapperdata+14   ;5129
chr0a           equ     mapperdata+15   ;512a
chr0b           equ     mapperdata+16   ;512b
;----------------------------------------------------------------------------
        end
