.486p
.model flat
.code

        include sb.h
        include ppu.h
        include data.h
        include input.h
        include joystick.h
        include font.h
        include empty.h
        include kb.h
        include equates.h
        include main.h
        include 6502.h
        include memory.h
        include vga.h
        include mouse.h
        include config.h
        include io.h
        include file.h
        include ggenie.h

        public startgui
        public drawfps
        public text
        public m3txt
        public m4txt
        public m5txt
;----------------------------------------------------------------------------
window:;        menu type box
;       in:
;               ecx=width
;               edx=height
;               edi=vscreen ptr
;       out:
;               eax,ebx,ecx,edx,edi,ebp=?
;----------------------------------------------------------------------------
        sub edi,264*5+5
        add ecx,10
        add edx,8
        mov eax,0f3f5f9fbh
        mov bl,0f8h
;----------------------------------------------------------------------------
box:;
;       in:
;               eax:bl=colors
;               ecx=width
;               edx=height
;               edi=vscreen ptr
;       out:
;               eax,ebx,ecx,edx,edi,ebp=?
;----------------------------------------------------------------------------
        push esi

        add edi,2                       ;adjust for 2 pixel border
        sub ecx,4
        mov ebp,264
        push edi                        ;save top of window
        sub ebp,ecx
        push ecx                        ;save width
        mov [xl],ecx
        shr ecx,2
        mov [xh],ecx
        and [xl],3
        lea esi,[edx-3]                 ;esi=Y count
        add edi,264

        mov edx,eax
        mov bh,bl
        mov ax,bx
        shl eax,16                      ;eax=middle color
        mov ax,bx
        shld ebx,edx,16                 ;bx,dx=border colors
box1:
        mov [edi-2],dx                  ;draw middle part
        mov ecx,[xh]
        rep stosd
        mov ecx,[xl]
        rep stosb
        mov [edi],bx
        add edi,ebp
        dec esi
        jnz box1

        mov al,dh                       ;top/bottom borders
        add al,bl
        rcr al,1
        pop ecx                         ;get width
        inc ecx
        pop esi                         ;get window top
        mov [esi-1],dl
        mov [esi-2],dl
        mov [edi-2],dl
        mov [edi-1],al
        mov [edi+263],bh
box2:   mov [esi],dl
        mov [esi+264],dh
        mov [edi],bl
        mov [edi+264],bh
        inc edi
        inc esi
        dec ecx
        jnz box2
        mov [esi+263],al
        mov [esi+264],bh
        mov [edi],bh
        mov [edi+264],bh

        pop esi
        ret

        xh dd ?
        xl dd ?
;----------------------------------------------------------------------------
htext:;         highlighted text (pushed button look)
;       in:
;               esi=text ptr
;               edi=vscreen ptr
;       out:
;               eax,ebx,edx,edi=?
;               esi=EOL
;----------------------------------------------------------------------------
        push ecx
        push ebp
        push esi
        push edi
        inc edi

        xor ecx,ecx                     ;ecx=line width
ht0:    movzx eax,byte ptr [esi]
        mov al,[lookup+eax]
        shl eax,6
        add ecx,[font+eax]              ;add up char widths
        inc esi
        cmp byte ptr [esi],1            ;end of string?
        ja ht0

        mov [htextend],edi
        mov eax,0f9faf5f7h
        mov bl,0f7h
        add ecx,4
        add [htextend],ecx
        mov edx,LINEHEIGHT+2
        sub edi,264*2+3
        call box

        pop edi
        pop esi
        call text
        pop ebp
        pop ecx
        ret

htextend        dd      ?
;----------------------------------------------------------------------------
text:;
;       in:
;               esi=text ptr
;               edi=vscreen ptr
;       out:
;               esi=EOL
;               eax,ebx,edx,edi=?
;----------------------------------------------------------------------------
t1:
        movzx ebx,byte ptr [esi]
        cmp bl,2                        ;end of string?
        jb t2

        movzx edx,[lookup+ebx]
        shl edx,6
        add dl,8

        push edi
t3:     mov al,byte ptr [font+edx]
        inc edx
        or al,al
        jz t4
        mov [edi],al
t4:     inc edi
        test dl,7
        jnz t3
        add edi,100h
        test dl,3fh
        jnz t3

        pop edi
        add edi,[font+edx-64]
        inc esi
        jmp t1
t2:
        dec esi
t5:     inc esi
        cmp byte ptr [esi],0
        jne t5
        ret
;----------------------------------------------------------------------------
drawmenu:;      draw one menu
;       in:
;               esi=menu ptr
;       out:
;               ecx=(visible) lines in menu
;               [realsel]=real selected line (not visible line#)
;               ?=?
;----------------------------------------------------------------------------
                                ;first draw the box
        xor ecx,ecx                     ;ecx=text width
        xor edx,edx                     ;edx=text height
        lea edi,[esi+11]                ;edi=text ptr-1
dm2:                                    ;calc text width/height:
        xor ebx,ebx                     ;ebx=current line width
dm0:    inc edi
        xor eax,eax
        or al,[edi]
        jz dm5                                  ;line end
        jns dm3                                 ;skip line if MSB set
dm4:    inc edi
        cmp byte ptr [edi],0
        jne dm4
        jmp dm1
dm3:    mov al,[lookup+eax]
        shl eax,6
        add ebx,[font+eax]              ;add chars in this line
        jmp dm0
dm5:    add edx,LINEHEIGHT              ;add height for 1 line
        cmp ebx,ecx                     ;compare this line with widest line
        jbe dm1
        mov ecx,ebx
dm1:    cmp byte ptr [edi+1],0
        jne dm2

        mov edi,[esi]
        call window
                                ;then draw the text
        mov ebp,[esi+4]                 ;ebp=selected line
        mov edi,[esi]                   ;edi=screen ptr
        add esi,12                      ;esi=text ptr
        xor ecx,ecx                     ;ecx=real line#
        mov [fakecount],ecx
        inc ebp
tw1:
        test byte ptr [esi],80h         ;skip if MSB=1
        jnz skipline
        push edi
        dec ebp
        jnz tw0
        call htext
        mov [realsel],ecx
        jmp tw2
tw0:    call text
tw2:    pop edi
        add edi,LINEHEIGHT*264
        inc [fakecount]
tw3:    inc esi
        inc ecx
        cmp byte ptr [esi],0
        jne tw1
        mov ecx,[fakecount]
        ret
skipline:
        inc esi
        cmp byte ptr [esi],0
        jne skipline
        jmp tw3

fakecount       dd ?           ;visible lines
realsel         dd ?           ;real selected line
;----------------------------------------------------------------------------
drawmenus:;     redraw screen and all menus in menulist
;
;       in:
;               ?
;       out:
;               ecx=lines in last menu
;----------------------------------------------------------------------------
        mov esi,offset vscreen2                 ;draw NES screen
        mov edi,offset vscreen
        mov ecx,264*240/4
        rep movsd

        mov edi,offset vscreen+8+264*214+10     ;print version
        mov esi,offset version
        call text

        xor eax,eax                             ;eax=menu#
dw2:
        mov esi,[menulist+eax*4]
        push eax
        call drawmenu
        pop eax
        inc eax
        cmp eax,[menus]
        jb dw2
dw1:
        ret
;----------------------------------------------------------------------------
drawfilemenu:;
;       in:
;               esi=file ptr list
;       out:
;               ?
;----------------------------------------------------------------------------        
        mov edi,[esi]                   ;edi=screen ptr
        mov ecx,[esi+16]                ;ecx=width
        mov edx,[esi+20]                ;edx=height
        call window

        mov edi,[esi]                   ;edi=screen ptr
        mov eax,[esi+4]                 ;get line offset
        mov ebp,[esi+8]                 ;ebp=selected line
        sub ebp,eax
        xor ecx,ecx                     ;ecx=line count
        mov [sel],ebp
        lea ebp,[esi+24+eax*4]          ;ebp=starting line
dwfm4:
        push edi
        mov esi,[ebp]
        add ebp,4
        cmp ecx,[sel]
        jne dwfm3
        call htext
        jmp dwfm5
dwfm3:  call text
dwfm5:  pop edi
        add edi,LINEHEIGHT*264
        inc ecx
        cmp dword ptr [ebp],0
        je dwfm2
        cmp ecx,MAXLINESINFILEMENU
        jb dwfm4
dwfm2:
        ret

sel     dd      ?                       ;selected line
;----------------------------------------------------------------------------
domenu:;        do new menu
;
;       in:
;               esi=menu ptr
;               edi=screen ptr
;       out:
;               ?
;----------------------------------------------------------------------------
        xor ebp,ebp
domenu2:                                ;ebp=selected line
        mov [esi],edi
        mov eax,[menus]                 ;add to menulist
        mov [menulist+eax*4],esi
        inc [menus]
gi5:
        mov [esi+4],ebp                 ;store selected line
        push esi
        push ebp
        call drawmenus                  ;draw all menus
        push ecx
        call [pageflip]
        pop ecx                         ;ecx=lines in active menu
        pop ebp                         ;ebp=selected line
        pop esi                         ;esi=menu ptr
gi0:
        xor al,al
gi4:    or al,[kb_last]                 ;wait for keypress
        jz gi4
        mov [kb_last],0

        cmp al,KB_UP                    ;up:
        jne gi1
        dec ebp                                 ;update line
        jns gi5
        lea ebp,[ecx-1]
        jmp gi5                                 ;and redraw
gi1:
        cmp al,KB_DOWN                  ;down:
        jne gi2
        inc ebp
        cmp ebp,ecx
        jb gi5
        xor ebp,ebp                             ;update line
        jmp gi5                                 ;and redraw
gi2:
        cmp al,KB_ENTER                 ;enter:
        jne gi3
        mov edi,[esi+8]                         ;get function list
        push esi
        push ebp
        mov ebp,[realsel]
        call [edi+ebp*4]                        ;call line func, ebp=(real) line
        pop ebp
        pop esi
        jc gi6                                  ;exit if menu function returned with CF
        jmp gi5
gi3:
        cmp al,KB_ESC                   ;esc:
        jne gi0
gi6:
        dec [menus]                     ;remove this menu from list
        ret                             ;and exit this menu
;----------------------------------------------------------------------------
startgui:;
;       in:
;               ?
;       out:
;               ?
;----------------------------------------------------------------------------
        call closemovie                         ;stop movie recording
        call stopmovie                          ;or playing
        call sb_pause                           ;this also stops WAV recording

        mov esi,offset vscreen                  ;save nes screen in vscreen2
        mov edi,offset vscreen2
        mov ecx,264*240/4
        rep movsd

        mov [menus],0

        mov esi,offset main                     ;do main menu
        mov edi,offset vscreen+8+34*264+12
        call domenu

        call sb_resume
        ret
;----------------------------------------------------------------------------
reset:;
;----------------------------------------------------------------------------
        or [int_flags],RES
        stc
        ret
;----------------------------------------------------------------------------
lcmp:;          cmp [[edi]],[[ebp]]
;       out:
;               eax,ebx,ecx,edx=?
;----------------------------------------------------------------------------
        mov ebx,[edi]
        mov edx,[ebp]

        mov al,[ebx]                    ;check head first
        mov ah,[edx]
        cmp al,DIRTYPE+1
        jb lc0
        mov al,DIRTYPE+1
lc0:    cmp ah,DIRTYPE+1
        jb lc1
        mov ah,DIRTYPE+1
lc1:    cmp al,ah
        jne lc3

        xor ecx,ecx                     ;now do the rest
lc2:    inc ecx
        mov al,[ebx+ecx]
        mov ah,[edx+ecx]

        cmp al,97                       ;(case insensitive)
        jb lc4
        cmp al,122
        ja lc4
        add al,'A'-'a'
lc4:
        cmp ah,97
        jb lc5
        cmp ah,122
        ja lc5
        add ah,'A'-'a'
lc5:
        cmp al,ah
        jnz lc3
        or al,al
        jnz lc2
lc3:
        ret
;----------------------------------------------------------------------------
dofilemenu:;
;       in:
;               esi=file list
;               edi=screen ptr
;               ebp=end of file list
;       out:
;               eax=filename ptr
;               cf=1 on ESC
;----------------------------------------------------------------------------        
        ;[ptrlist+0]=screen ptr
        ;[ptrlist+4]=top line displayed
        ;[ptrlist+8]=selected line
        ;[ptrlist+12]=total lines
        ;[ptrlist+16]=window width
        ;[ptrlist+20]=window height

        mov [ebp+SCREENPTR],edi     ;keep screen ptr
        mov dword ptr [ebp+FIRSTLINE],0
        mov [list],esi
        mov [ptrlist],ebp
;-------                            ;sort list-
        add ebp,STRUCTEND               ;build ptr list
dfm30:  cmp byte ptr [esi],0
        je dfm32
        mov [ebp],esi
        add ebp,4
dfm31:  inc esi
        cmp byte ptr [esi],0
        jne dfm31
        inc esi
        jmp dfm30
dfm32:  mov dword ptr [ebp],0

dfm33:  sub ebp,4                       ;do some sorting
        mov edi,[ptrlist]
        add edi,STRUCTEND
        cmp edi,ebp
        jae dfm36
dfm34:  call lcmp
        jbe dfm35
        mov eax,[edi]
        xchg eax,[ebp]
        mov [edi],eax
dfm35:  add edi,4
        cmp edi,ebp
        je dfm33
        jmp dfm34
dfm36:
;-------                            ;calc window size
        xor ecx,ecx                     ;ecx=max width
        xor edx,edx                     ;edx=line count
        mov ebp,[ptrlist]               ;list ptr
        add ebp,STRUCTEND
dfm20:
        mov edi,[ebp]                   ;edi=text ptr
        add ebp,4
        xor ebx,ebx                     ;current width
dfm21:  movzx eax,byte ptr [edi]        ;calc text width/height:
        mov al,[lookup+eax]
        shl eax,6
        add ebx,[font+eax]              ;add chars in this line
        inc edi
        cmp byte ptr [edi],1                    ;line end
        ja dfm21
        dec edi
dfm24:  inc edi
        cmp byte ptr [edi],0                    ;true line end
        jne dfm24
        cmp ebx,ecx                     ;compare this line with widest line
        jbe dfm22
        mov ecx,ebx
dfm22:  inc edx                         ;count line
        cmp dword ptr [ebp],0
        jne dfm20

        mov ebp,[ptrlist]
        mov [ebp+TOTALLINES],edx
        mov [ebp+MENUWIDTH],ecx         ;this should be range checked
        mov eax,LINEHEIGHT
        cmp edx,MAXLINESINFILEMENU      ;range check window size
        jbe dfm23
        mov edx,MAXLINESINFILEMENU
dfm23:  mul edx
        mov [ebp+MENUHEIGHT],eax
;---
dfm10:
        xor ebp,ebp                     ;ebp=selected line
dfm8:                                   ;draw menu
        mov esi,[ptrlist]
        cmp ebp,[esi+FIRSTLINE]                 ;some sanity checking ..
        jae dfm14                                       ;if ebp<firstline,
        mov [esi+FIRSTLINE],ebp                         ;  firstline=ebp
dfm14:
        cmp ebp,[esi+TOTALLINES]
        jb dfm7                                         ;if ebp>total
        mov ebp,[esi+TOTALLINES]                        ;  ebp=total
        dec ebp
dfm7:
        mov [esi+SELECTED],ebp                          ;store selected
        sub ebp,MAXLINESINFILEMENU-1
        js dfm15
        cmp [esi+FIRSTLINE],ebp                         ;if first>selected-max
        jae dfm15                                       ;  first=selected-max
        mov [esi+FIRSTLINE],ebp
dfm15:
        call drawmenus                  ;draw other menus
        mov esi,[ptrlist]
        call drawfilemenu               ;draw this menu
        call [pageflip]
dfm0:
        mov esi,[ptrlist]
        mov ebp,[esi+SELECTED]          ;ebp=selected line
        xor eax,eax
dfm4:   or al,[kb_last]                 ;wait for keypress
        jz dfm4
        mov [kb_last],0

        cmp al,KB_UP                    ;up:
        jne dfm1
        dec ebp
        js dfm10
        jmp dfm8
dfm1:
        cmp al,KB_DOWN                  ;down:
        jne dfm2
        inc ebp
        jmp dfm8
dfm2:
        cmp al,KB_HOME                  ;home:
        je dfm10
dfm9:
        cmp al,KB_END                   ;end:
        jne dfm11
        mov ebp,-1
        jmp dfm8
dfm11:
        cmp al,KB_PGUP                  ;pageup:
        jne dfm12
        sub ebp,MAXLINESINFILEMENU
        js dfm10
        jmp dfm8
dfm12:
        cmp al,KB_PGDN                  ;pagedown:
        jne dfm13
        add ebp,MAXLINESINFILEMENU
        jmp dfm8
dfm13:
        cmp al,KB_ENTER                 ;enter:
        jne dfm3
        mov eax,[esi+STRUCTEND+ebp*4]           ;eax=name ptr
        mov esi,eax
dfm40:  inc esi                                 ;restore hidden extension
        cmp byte ptr [esi],1
        jne dfm41
        mov byte ptr [esi],'.'
dfm41:  cmp byte ptr [esi],0
        jne dfm40
        clc
        ret
dfm3:
        cmp al,KB_ESC                   ;esc:
        jne dfm5
        stc
        ret                                     ;exit this menu
dfm5:
        cmp al,KB_BACKSPACE             ;back:
        jne dfm19
        mov eax,[list]
        add eax,3
        cmp dword ptr [eax],DIRTYPE+002e2e00h   ;".." should be 2nd entry
        jne dfm0
        clc
        ret
dfm19:
        mov al,[kb_asctable+eax]        ;alpha:
        cmp al,'0'
        jb dfm0
        cmp al,'Z'
        ja dfm0
        cmp al,'9'
        jbe dfm6
        cmp al,'A'
        jb dfm0

dfm6:   mov ah,al                               ;al=[0-9,A-Z]
        or ah,20h                               ;ah=[0-9,a-z]
        mov ebp,-1                              ;ebp=line#
        add esi,STRUCTEND
dfm16:  mov edi,[esi]
        add esi,4
        inc ebp
        or edi,edi
        jz dfm0
        cmp byte ptr [edi],DIRTYPE              ;scan list..
        jbe dfm16
        cmp al,[edi+1]
        je dfm17
        cmp ah,[edi+1]
        jne dfm16
dfm17:                                          ;ebp=1st line starting with al|ah
        mov esi,[ptrlist]
        mov edi,ebp
        mov eax,[esi+FIRSTLINE]                 ;eax=first
        sub edi,eax                             ;skip if selected<first
        js dfm8
        cmp edi,MAXLINESINFILEMENU              ;skip if line is visible
        jb dfm8
        mov eax,ebp                             ;first=selected
        mov edi,[esi+TOTALLINES]
        sub edi,MAXLINESINFILEMENU
        cmp eax,edi                             ;if first>total-max
        jb dfm18                                ;  first=total-max
        mov eax,edi
dfm18:  mov [esi+FIRSTLINE],eax
        jmp dfm8

list    dd ?
ptrlist dd ?

SCREENPTR       equ 0
FIRSTLINE       equ 4
SELECTED        equ 8
TOTALLINES      equ 12
MENUWIDTH       equ 16
MENUHEIGHT      equ 20
STRUCTEND       equ 24
;----------------------------------------------------------------------------
listfiles:;     find files and add to list
;       in:
;               bl=type head
;               cx=attrib
;               edx=name
;               edi=list start
;       out:
;               edi=list end
;               ...=...?
;----------------------------------------------------------------------------
        call findfirst
        jc lf9
lf0:
        mov byte ptr [edi],bl           ;type (file,dir,drive,etc)
        inc edi
lf1:
        mov al,[esi]
        inc esi
        mov [edi],al
        inc edi
        or al,al
        jnz lf1

        or ecx,ecx
        jnz lf2
        mov byte ptr [edi-5],1          ;hide extension
lf2:
        call findnext
        jnc lf0
        call findclose
        clc
lf9:
        mov byte ptr [edi],0            ;end of list
        ret
;----------------------------------------------------------------------------
loadmenu:;
;----------------------------------------------------------------------------
        mov bl,DIRTYPE                  ;list dirs
        mov ecx,1010h
        mov edx,offset wilddir
        mov edi,offset tmp
        call listfiles
        jc lm0

        mov bl,NESTYPE                  ;list *.nes
        xor ecx,ecx
        mov edx,offset wildnes
        call listfiles

        mov bl,NSFTYPE                  ;list *.nsf
        xor ecx,ecx
        mov edx,offset wildnsf
        call listfiles

        mov bl,FDSTYPE                  ;list *.fds
        xor ecx,ecx
        mov edx,offset wildfds
        call listfiles

        mov esi,offset tmp
        lea ebp,[edi+4]
        mov edi,[htextend]
        and ebp,-4                      ;(dword align)
        push edi
        call dofilemenu
        pop edi
        jc lm0                          ;(escaped out)

        cmp byte ptr [eax],DIRTYPE      ;dir?
        jne lm1
        mov [htextend],edi
        lea edx,[eax+1]
        call cd                                 ;chdir
        jc lm0
        jmp loadmenu
lm1:                                    ;rom file
        push eax
        call closerom                           ;unload current ROM
        pop eax
        lea edi,[eax+1]
lm2:
        call loadcart                           ;try to load
        jnc cpu_init                            ;execute if ok
lm0:
        clc
        ret

wilddir db '*',0
wildnes db '*.NES',0
wildnsf db '*.NSF',0
wildfds db '*.FDS',0
;----------------------------------------------------------------------------
palmenu:;
;----------------------------------------------------------------------------
        call savedir
        call exedir

        mov bl,PALTYPE
        xor ecx,ecx
        mov edx,offset wildpal
        mov edi,offset tmp
        call listfiles
        jc pm0

        mov esi,offset tmp
        lea ebp,[edi+4]
        mov edi,[htextend]
        and ebp,-4                      ;(dword align)
        call dofilemenu
        jc pm0                          ;(escaped out)

        lea edx,[eax+1]                 ;open..
pm4:   ; inc eax
       ; cmp byte ptr [eax],0
       ; jne pm4
       ; mov [eax],'LAP.'
       ; mov byte ptr [eax+4],0
        xor cl,cl
        call f_open
        jc pm0
        mov ecx,64*3                    ;read..
        mov edx,offset tmp
        call f_read
        call f_close
        mov ecx,64                      ;copy..
        mov esi,offset tmp
        mov edi,offset palette
pm3:    mov eax,[esi]
        shr eax,2
        and eax,3f3f3fh
        add esi,3
        mov [edi],eax
        add edi,4
        dec ecx
        jnz pm3
        call pal_init                   ;set..
pm0:
        call restoredir
        clc
        ret

wildpal         db '*.PAL',0
;----------------------------------------------------------------------------
configmenu:;
;----------------------------------------------------------------------------
;        xor [vwait],1
;        call toggleV
        xor [showfps],1                 ;put text in correct checked state
        call toggleF
        xor [border0],1
        call toggle0
        xor [border232],1
        call toggle232
        mov [newborder],0

        mov esi,offset config
        mov edi,[htextend]
        call domenu
        clc
        ret
;----------------------------------------------------------------------------
toggleV:;
;----------------------------------------------------------------------------
        xor [vwait],1
        mov al,UNCHECK
        jz vOFF
        mov al,CHECK
vOFF:
;        mov [vtxt],al
        clc
        ret
;----------------------------------------------------------------------------
toggleF:;
;----------------------------------------------------------------------------
        xor [showfps],1
        mov al,UNCHECK
        jz fOFF
        mov al,CHECK
fOFF:
        mov [ftxt],al
        clc
        ret
;----------------------------------------------------------------------------
toggle0:;
;----------------------------------------------------------------------------
        mov [newborder],1
        xor [border0],1
        mov al,CHECK
        jz tb0
        mov al,UNCHECK
tb0:
        mov [txt0],al
        clc
        ret
;----------------------------------------------------------------------------
toggle232:;
;----------------------------------------------------------------------------
        mov [newborder],1
        xor [border232],1
        mov al,CHECK
        jz tb232
        mov al,UNCHECK
tb232:
        mov [txt232],al
        clc
        ret
;----------------------------------------------------------------------------
vidmenu:;
;----------------------------------------------------------------------------
        mov esi,offset vidmodes
        mov edi,[htextend]
        call domenu
        clc
        ret
;----------------------------------------------------------------------------
vpick:;
;----------------------------------------------------------------------------
        mov [vidmode],ebp
        call gfxmode

        stc
        ret
;----------------------------------------------------------------------------
soundmenu:;
;----------------------------------------------------------------------------
        xor [soundmask],11111b
        call ch1switch
        call ch2switch
        call ch3switch
        call ch4switch
        call ch5switch

        mov esi,offset sndlist
        mov edi,[htextend]
        call domenu
        clc
        ret
;----------------------------------------------------------------------------
ch1switch:;
;----------------------------------------------------------------------------
        mov al,1
        mov edi,offset ch1txt
        jmp chXswitch
ch2switch:;
        mov al,2
        mov edi,offset ch2txt
        jmp chXswitch
ch3switch:;
        mov al,4
        mov edi,offset ch3txt
        jmp chXswitch
ch4switch:;
        mov al,8
        mov edi,offset ch4txt
        jmp chXswitch
ch5switch:;
        mov al,16
        mov edi,offset ch5txt
chXswitch:
        xor [soundmask],al
        and al,[soundmask]
        mov al,UNCHECK
        jz chOFF
        mov al,CHECK
chOFF:
        mov [edi],al
        clc
        ret
;----------------------------------------------------------------------------
volmenu:;
;----------------------------------------------------------------------------
        movzx ebp,[soundvol]
        dec ebp
        mov esi,offset vollist
        mov edi,[htextend]
        call domenu2
        clc
        ret
;----------------------------------------------------------------------------
volset:;
;----------------------------------------------------------------------------
        mov eax,ebp
        inc al
        mov [soundvol],al
        call changevol
        stc
        ret
;----------------------------------------------------------------------------
ctrlmenu:;
;----------------------------------------------------------------------------
        sub ebp,CTRLMENUNUM                     ;ebp=controller#
        mov esi,offset ctl
        mov eax,[ctlmask+ebp*4]
        mov edi,[htextend]

        mov bl,7fh                              ;show/hide lines
        and [zaptxt],bl
        and [pdltxt],bl
        and [vstxt],bl
        and [ppadtxt],bl
        or [zaptxt],al
        or [vstxt],ah
        shr eax,16
        or [pdltxt],al
        or [ppadtxt],ah ;al

        mov [controlnum],ebp                    ;save controller#
        call domenu

        mov [joymask],0
        clc
        ret

        align 4
ctlmask         dd 80800080h,00008000h,80808080h,80808080h
controlnum      dd ?
;----------------------------------------------------------------------------
noconfig:
;----------------------------------------------------------------------------
        mov al,JOYPAD
        mov ah,UNPLUGGED
nc0:                                    ;al=type, ah=
        mov edi,[controlnum]
        mov [inputtype+edi],ah
nc1:                                    ;al=type
        mov edi,[controlnum]
        mov [control0type+edi],al
        call ctrlsetup
        stc
        ret
;----------------------------------------------------------------------------
kbconfig:
;----------------------------------------------------------------------------
        mov edi,[htextend]
        mov ecx,CONFIG_W
        mov edx,CONFIG_H
        call window
        mov esi,offset kbtxt0
        mov edi,[htextend]
        add edi,CONFIG_TEXT0_Y+9
        call text
        mov esi,offset kbtxt1
        mov edi,[htextend]
        add edi,CONFIG_TEXT1_Y+25
        call text

        mov edi,[controlnum]
        shl edi,5
        xor ecx,ecx
        mov bl,1
kc3:
        pushad
        call flashbuttons
        popad
        call readkb
        jc kc2
        jz kc3
kc2:    mov [control0config+edi+ecx],al

        inc cl
        shl bl,1
        jnz kc3

        mov al,JOYPAD
        mov ah,KEYBOARD
        jmp nc0
;----------------------------------------------------------------------------
readkb:;        check keyboard for input
;       out:
;               AL=scancode
;               (CF=1)  esc pressed
;               (ZF=1)  nothing pressed
;----------------------------------------------------------------------------
        mov al,[kb_last]
        or al,al
        jz rk2
        cmp al,KB_ESC
        je rk1
;        cmp al,KB_BREAK                 ;..ignore invalid keys
;        je rk0
;        cmp al,KB_F1
;        je rk0
;        cmp al,KB_F2
;        je rk0
;        cmp al,KB_F3
;        je rk0
;        cmp al,KB_F4
;        je rk0
;        cmp al,KB_F5
;        je rk0
;        cmp al,KB_F6
;        je rk0
;        cmp al,KB_F7
;        je rk0
;        cmp al,KB_F8
;        je rk0
;        cmp al,KB_1
;        je rk0
;        cmp al,KB_2
;        je rk0
;        cmp al,KB_3
;        je rk0
;        cmp al,KB_4
rk0:    mov [kb_last],0
rk2:    clc
        ret
rk1:    stc
        mov [kb_last],0
        ret
;----------------------------------------------------------------------------
flashbuttons:
;       in:
;               bl=button mask
;       out:
;               everything=?
;----------------------------------------------------------------------------
        call db0
        xor bl,bl
db0:
        xor esi,esi
        mov edi,[htextend]
        mov edx,8
db2:
        mov ebp,offset blackbuttons
        shr bl,1
        jnc db3
        mov ebp,offset greenbuttons
db3:    add edi,[blackbuttons+esi]
        add esi,4
        mov ecx,7
db1:
        mov eax,[esi+ebp]
        mov [edi],eax
        mov eax,[esi+ebp+4]
        mov [edi+4],eax
        add edi,264
        add esi,8
        dec ecx
        jnz db1
        dec edx
        jnz db2
        
        push [vwait]
        mov [vwait],1                   ;force vret
        call [pageflip]
        pop [vwait]
        ret
;----------------------------------------------------------------------------
readbuttons:;   read joystick buttons
;       out:
;               eax=button# (0-3)
;               edx=?
;               (zf=1: nothing pressed)
;----------------------------------------------------------------------------
        mov edx,[joybuttons]
        xor [last],edx
        jz rb1
        bsf eax,edx
        shr eax,3
        or edx,edx
rb1:
        mov [last],edx
        ret

        align 4

last    dd      0
;----------------------------------------------------------------------------
joy0config:;
;----------------------------------------------------------------------------
        mov edi,[htextend]
        mov ecx,CONFIG_W
        mov edx,CONFIG_H
        call window
        mov esi,offset joytxt0
        mov edi,[htextend]
        add edi,CONFIG_TEXT0_Y+3
        call text                       ;'center'
        mov esi,offset joytxt1
        mov edi,[htextend]
        add edi,CONFIG_TEXT1_Y+7
        call text
        xor bl,bl
        call flashbuttons

        or [joymask],00110000b          ;(for axis reading)

j0c0:   call joy_load
        call readkb                     ;abort on esc
        jc j0c99
j0c9:   call readbuttons                ;wait for button
        jz j0c0

        mov eax,[joy0x]                 ;init calibration stuff
        mov ebx,[joy0y]
        mov [xmin],eax
        mov [xmid],eax
        mov [xmax],eax
        mov [ymin],ebx
        mov [ymid],ebx
        mov [ymax],ebx

        mov edi,[htextend]
        mov ecx,CONFIG_W
        mov edx,CONFIG_H
        call window
        mov esi,offset joytxt2
        mov edi,[htextend]
        add edi,CONFIG_TEXT0_Y+5
        call text                       ;'circle'
        mov esi,offset joytxt3
        mov edi,[htextend]
        add edi,CONFIG_TEXT1_Y+7
        call text

j0c2:
        xor bl,bl
        mov al,byte ptr [joy0axis]
        bt eax,5
        rcl bl,1
        bt eax,7
        rcl bl,1
        bt eax,4
        rcl bl,1
        bt eax,6
        rcl bl,1
        call flashbuttons

        call joy_load

        mov eax,[joy0x]
        mov ebx,[joy0y]

        cmp eax,[xmin]
        ja j0c3
        mov [xmin],eax
j0c3:   cmp eax,[xmax]
        jb j0c4
        mov [xmax],eax
j0c4:   cmp ebx,[ymin]
        ja j0c5
        mov [ymin],ebx
j0c5:   cmp ebx,[ymax]
        jb j0c6
        mov [ymax],ebx
j0c6:
        mov eax,[xmin]
        mov ebx,[ymin]
        mov ecx,[xmid]
        mov edx,[ymid]
        add eax,ecx
        add ebx,edx
        shr eax,1
        shr ebx,1
        mov [joy0xmid],eax
        mov [joy0ymid],ebx
        add ecx,[xmax]
        add edx,[ymax]
        shr ecx,1
        shr edx,1
        mov [joy0xmax],ecx
        mov [joy0ymax],edx

        call readbuttons
        jz j0c2                          ;wait for button press

        mov edi,[htextend]
        mov ecx,CONFIG_W
        mov edx,CONFIG_H
        call window
        mov esi,offset joytxt4          ;'press button'
        mov edi,[htextend]
        add edi,CONFIG_TEXT0_Y+2
        call text
        mov esi,offset joytxt5
        mov edi,[htextend]
        add edi,CONFIG_TEXT1_Y+10
        call text

        mov edi,[controlnum]
        shl edi,5
        xor ecx,ecx
        mov bl,10h
j0c7:
        pushad
        call joy_load
        call flashbuttons
        popad
        call readbuttons
        jnz j0c8
        call readkb
        jc j0c8
        jz j0c7
j0c8:   mov [control0config+edi+ecx],al

        inc cl
        shl bl,1
        jnz j0c7

        mov al,JOYPAD
        mov ah,JOYSTICK0
        jmp nc0
j0c99:
        stc
        ret

xmin    dd      ?                       ;temp vars for calibration
xmid    dd      ?
xmax    dd      ?
ymin    dd      ?
ymid    dd      ?
ymax    dd      ?
;----------------------------------------------------------------------------
joy1config:;    lazy cut-n-paste :P
;----------------------------------------------------------------------------
        mov edi,[htextend]
        mov ecx,CONFIG_W
        mov edx,CONFIG_H
        call window
        mov esi,offset joytxt0
        mov edi,[htextend]
        add edi,CONFIG_TEXT0_Y+3
        call text                       ;'center'
        mov esi,offset joytxt1
        mov edi,[htextend]
        add edi,CONFIG_TEXT1_Y+7
        call text
        xor bl,bl
        call flashbuttons

        or [joymask],11000000b          ;(for axis reading)

j1c0:   call joy_load
        call readkb                     ;abort on esc
        jc j1c99
j1c9:   call readbuttons                ;wait for button
        jz j1c0

        mov eax,[joy1x]                 ;init calibration stuff
        mov ebx,[joy1y]
        mov [xmin],eax
        mov [xmid],eax
        mov [xmax],eax
        mov [ymin],ebx
        mov [ymid],ebx
        mov [ymax],ebx

        mov edi,[htextend]
        mov ecx,CONFIG_W
        mov edx,CONFIG_H
        call window
        mov esi,offset joytxt2
        mov edi,[htextend]
        add edi,CONFIG_TEXT0_Y+5
        call text                       ;'circle'
        mov esi,offset joytxt3
        mov edi,[htextend]
        add edi,CONFIG_TEXT1_Y+7
        call text

j1c2:
        xor bl,bl
        mov al,byte ptr [joy1axis]
        bt eax,5
        rcl bl,1
        bt eax,7
        rcl bl,1
        bt eax,4
        rcl bl,1
        bt eax,6
        rcl bl,1
        call flashbuttons

        call joy_load

        mov eax,[joy1x]
        mov ebx,[joy1y]

        cmp eax,[xmin]
        ja j1c3
        mov [xmin],eax
j1c3:   cmp eax,[xmax]
        jb j1c4
        mov [xmax],eax
j1c4:   cmp ebx,[ymin]
        ja j1c5
        mov [ymin],ebx
j1c5:   cmp ebx,[ymax]
        jb j1c6
        mov [ymax],ebx
j1c6:
        mov eax,[xmin]
        mov ebx,[ymin]
        mov ecx,[xmid]
        mov edx,[ymid]
        add eax,ecx
        add ebx,edx
        shr eax,1
        shr ebx,1
        mov [joy1xmid],eax
        mov [joy1ymid],ebx
        add ecx,[xmax]
        add edx,[ymax]
        shr ecx,1
        shr edx,1
        mov [joy1xmax],ecx
        mov [joy1ymax],edx

        call readbuttons
        jz j1c2                          ;wait for button press

        mov edi,[htextend]
        mov ecx,CONFIG_W
        mov edx,CONFIG_H
        call window
        mov esi,offset joytxt4          ;'press button'
        mov edi,[htextend]
        add edi,CONFIG_TEXT0_Y+2
        call text
        mov esi,offset joytxt5
        mov edi,[htextend]
        add edi,CONFIG_TEXT1_Y+10
        call text

        mov edi,[controlnum]
        shl edi,5
        xor ecx,ecx
        mov bl,10h
j1c7:
        pushad
        call joy_load
        call flashbuttons
        popad
        call readbuttons
        jnz j1c8
        call readkb
        jc j1c8
        jz j1c7
j1c8:   mov [control0config+edi+ecx],al

        inc cl
        shl bl,1
        jnz j1c7

        mov al,JOYPAD
        mov ah,JOYSTICK1
        jmp nc0
j1c99:
        stc
        ret
;----------------------------------------------------------------------------
snesconfig:
;----------------------------------------------------------------------------
        mov esi,offset lptmenu
        mov edi,[htextend]
        jmp domenu
;----------------------------------------------------------------------------
lptpick:
;----------------------------------------------------------------------------
        mov edi,[controlnum]
        shl edi,5
        mov eax,[lptlist+ebp*4]
        mov dword ptr [control0config+edi],eax

        mov esi,offset padmenu
        mov edi,[htextend]
        call domenu

        mov al,JOYPAD
        mov ah,SNESPAD
        jmp nc0

lptlist dd 378h,278h,3bch
;----------------------------------------------------------------------------
padpick:
;----------------------------------------------------------------------------
        mov edi,[controlnum]
        shl edi,5
        mov ax,[padbit+ebp*2]
        mov word ptr [control0config+4+edi],ax
        stc
        ret

padbit  dw 0ff07h
        dw 0ff06h
        dw 0ff05h
        dw 0ff04h
        dw 00008h
;----------------------------------------------------------------------------
zapconfig:
;----------------------------------------------------------------------------
        mov [mouseXmin],-7
        mov [mouseXmax],263
        mov [mouseYmin],-7
        mov [mouseYmax],247

        mov al,ZAPPER
        jmp nc1
;----------------------------------------------------------------------------
vszapconfig:
;----------------------------------------------------------------------------
        mov [mouseXmin],-7
        mov [mouseXmax],263
        mov [mouseYmin],-7
        mov [mouseYmax],247

        mov al,VSZAP
        jmp nc1
;----------------------------------------------------------------------------
paddleconfig:
;----------------------------------------------------------------------------
        mov [mouseXmin],98
        mov [mouseXmax],242

        mov al,PADDLE
        jmp nc1
;----------------------------------------------------------------------------
ppadconfig:
;----------------------------------------------------------------------------
        mov al,POWERPAD
        jmp nc1
;----------------------------------------------------------------------------
cheatmenu:
;----------------------------------------------------------------------------
        mov edi,[htextend]
        mov ecx,50
        mov edx,11
        call window
c1:
        mov eax,0f9faf5f7h
        mov bl,0f0h
        mov edi,[htextend]
        sub edi,2+264*2
        mov ecx,54
        mov edx,13
        call box

        mov edi,[htextend]
        add edi,1*264+1
        mov esi,offset txt
        call text

        call [pageflip]
c2:
        call getch              ;read kb
        mov esi,[curs]
        cmp al,13               ;enter?
        je c3
        cmp al,27               ;esc?
        je c0
        cmp al,8                ;backspace?
        je c5
;                               ;normal key:
        cmp esi,8                       ;max 8 chars
        je c2
        mov ecx,15
        call gcmp                       ;valid letter code?
        jnz c2
        xor ah,ah
        mov word ptr [txt+esi],ax
        inc [curs]
        jmp c1
c3:                             ;enter
        mov esi,offset txt
        call GGadd
        mov [curs],0
        mov byte ptr [txt],0
        jmp c0
c5:                             ;backspace
        or esi,esi
        jz c2
        dec [curs]
        mov byte ptr [txt+esi-1],0
        jmp c1
c0:
        clc
        ret
gcmp:
        cmp al,[GGchars+ecx]
        je c4
        dec ecx
        jns gcmp
c4:     ret

txt db 30 dup (0)
curs dd 0
;----------------------------------------------------------------------------
drawfps:;
;----------------------------------------------------------------------------
        cmp [showfps],0
        jne fps0
        ret
fps0:
        mov eax,[fps]
        call fps3
        mov byte ptr [esi],0
        mov esi,offset strbuff
        mov edi,offset vscreen+8+264*21+10
        jmp text
fps3:;- - - - - - - - - - - - - - - - - - - - - - - write decimal# to strbuff
        mov ecx,10
        mov esi,offset strbuff
fps1:
        xor edx,edx
        div ecx
        or eax,eax
        jz fps2
        push edx
        call fps1
        pop edx
fps2:
        mov al,dl
        add al,'0'
        mov [esi],al
        inc esi
        ret

strbuff db 8 dup (0)
;----------------------------------------------------------------------------

CHECK           equ 2
UNCHECK         equ 3
DIRTYPE         equ 4
NESTYPE         equ 5
NSFTYPE         equ 6
FDSTYPE         equ 7
PALTYPE         equ 8

LINEHEIGHT              equ 9           ;height of one menu line
MAXLINESINFILEMENU      equ 19
CONFIG_W                equ 80          ;controller config window
CONFIG_H                equ 49
CONFIG_TEXT0_Y          equ 264*30
CONFIG_TEXT1_Y          equ 264*39

        align 4

menulist        dd 8 dup (?)                    ;menu list
menus           dd ?                            ;items in menulist

version         db 'loopyNes ',??date,0 ;'.5X',0

kbtxt0          db 'hit key for lit',0
kbtxt1          db 'control',0
joytxt0         db 'center stick and',0
joytxt1         db 'press a button',0
joytxt2         db 'circle stick and',0
joytxt3         db 'press a button',0
joytxt4         db 'hit key or button',0
joytxt5         db 'for lit control',0

main            dd ?                            ;screen pos
                dd ?                            ;current selection
                dd mfunc                        ;line function list
                db 'LOAD',0
                db 'CONFIG',0
                db 'CHEAT',0
                db 'RESET',0
                db 'EXIT',0
                db 0
mfunc           dd loadmenu
                dd configmenu
                dd cheatmenu
                dd reset
                dd _exit

config          dd ?
                dd ?
                dd cfunc
;           atxt db '-AUTO RATE',0
;           vtxt db '-VSYNC',0
           ftxt db '-SHOW FPS',0
        txt0    db '-LINES 0-7',0
        txt232  db '-LINES 232-239',0
                db 'VIDEO MODE',0
                db 'SOUND',0
                db 'PALETTE',0
                db 'CONTROLLER 1',0
                db 'CONTROLLER 2',0
                db 'CONTROLLER 3',0
                db 'CONTROLLER 4',0
                db 0
cfunc: ;         dd toggleA
       ;         dd toggleV
                dd toggleF
                dd toggle0
                dd toggle232
                dd vidmenu
                dd soundmenu
                dd palmenu
           blah dd ctrlmenu
                dd ctrlmenu
                dd ctrlmenu
                dd ctrlmenu
CTRLMENUNUM=(blah-cfunc)/4

lptmenu         dd ?
                dd ?
                dd lptfunc
                db 'LPT1',0
                db 'LPT2',0
                db 'LPT3',0
                db 0
lptfunc         dd lptpick
                dd lptpick
                dd lptpick

padmenu         dd ?
                dd ?
                dd padfunc
                db 'PAD 1',0
                db 'PAD 2',0
                db 'PAD 3',0
                db 'PAD 4',0
                db 'PAD 5',0
                db 0
padfunc         dd padpick
                dd padpick
                dd padpick
                dd padpick
                dd padpick

vidmodes        dd ?
                dd ?
                dd vfunc
                db '320*200',0
                db '256*240',0
                db '256*240 (WIDE)',0
                db '256*240 (LINES)',0
     m3txt      db '320*240 (LFB)',0
     m4txt      db '320*480 (LINE)',0
     m5txt      db 'SUCKS',0
                db 0
vfunc           dd vpick
                dd vpick
                dd vpick
                dd vpick
                dd vpick
                dd vpick

sndlist         dd ?
                dd ?
                dd sndfunc
         ch1txt db '-SQUARE 1',0
         ch2txt db '-SQUARE 2',0
         ch3txt db '-TRIANGLE',0
         ch4txt db '-NOISE',0
         ch5txt db '-PCM',0
                db 'VOLUME..',0
                db 0
sndfunc         dd ch1switch
                dd ch2switch
                dd ch3switch
                dd ch4switch
                dd ch5switch
                dd volmenu

vollist         dd ?
                dd ?
                dd volfunc
                db '1',0
                db '2',0
                db '3',0
                db '4',0
                db '5',0
                db '6',0
                db '7',0
                db '8',0
                db '9',0
                db '10',0
                db 0
volfunc         dd volset
                dd volset
                dd volset
                dd volset
                dd volset
                dd volset
                dd volset
                dd volset
                dd volset
                dd volset

ctl             dd ?
                dd ?
                dd ctlfunc
                db 'NONE',0
                db 'KEYBOARD',0
                db 'JOYSTICK 1',0
                db 'JOYSTICK 2',0
                db 'SNESPAD',0
zaptxt          db 'ZAPPER',0
vstxt           db 'ZAPPER (VS)',0
pdltxt          db 'PADDLE',0
ppadtxt         db 'POWER PAD',0
                db 0
ctlfunc         dd noconfig
                dd kbconfig
                dd joy0config
                dd joy1config
                dd snesconfig
                dd zapconfig
                dd vszapconfig
                dd paddleconfig
                dd ppadconfig

blackbuttons    dd 264*11+10
                db 0f8h,0f6h,0f6h,0f6h,0f6h,0f8h,0f8h,0f8h      ;left
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f6h,0f8h,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h,0f8h
                db 0f8h,0fah,0fah,0fah,0fah,0f8h,0f8h,0f8h
                dd -264*13+6
                db 0f8h,0f6h,0f6h,0f6h,0f6h,0f6h,0f8h,0f8h      ;up
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0fah,0f8h,0f8h
                db 0f8h,0f8h,0fah,0fah,0fah,0f8h,0f8h,0f8h
                dd -264*1+6
                db 0f8h,0f8h,0f6h,0f6h,0f6h,0f6h,0f8h,0f8h      ;right
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0f8h,0fah,0fah,0fah,0fah,0f8h,0f8h
                dd -264*1-6
                db 0f8h,0f8h,0f6h,0f6h,0f6h,0f8h,0f8h,0f8h      ;down
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0f6h,0f8h,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0fah,0fah,0fah,0fah,0fah,0f8h,0f8h
                dd -264*13+17
                db 0f8h,0f8h,0f8h,0f8h,0f6h,0f6h,0f8h,0f8h      ;select
                db 0f8h,0f8h,0f8h,0f6h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0f8h,0f6h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0fah,0f8h,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0fah,0f8h,0f8h,0f8h
                db 0f6h,0f0h,0f0h,0fah,0f8h,0f8h,0f8h,0f8h
                db 0f8h,0fah,0fah,0f8h,0f8h,0f8h,0f8h,0f8h
                dd -264*7+8
                db 0f8h,0f8h,0f8h,0f8h,0f6h,0f6h,0f8h,0f8h      ;start
                db 0f8h,0f8h,0f8h,0f6h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0f8h,0f6h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0fah,0f8h,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0fah,0f8h,0f8h,0f8h
                db 0f6h,0f0h,0f0h,0fah,0f8h,0f8h,0f8h,0f8h
                db 0f8h,0fah,0fah,0f8h,0f8h,0f8h,0f8h,0f8h
                dd -264*7+11
                db 0f8h,0f8h,0f6h,0f6h,0f6h,0f8h,0f8h,0f8h      ;B
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0f6h,0f8h,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0fah,0f8h,0f8h
                db 0f8h,0f8h,0fah,0fah,0fah,0f8h,0f8h,0f8h
                dd -264*7+9
                db 0f8h,0f8h,0f6h,0f6h,0f6h,0f8h,0f8h,0f8h      ;A
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0f6h,0f8h,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f6h,0f0h,0f0h,0f0h,0f0h,0f0h,0fah,0f8h
                db 0f8h,0f6h,0f0h,0f0h,0f0h,0fah,0f8h,0f8h
                db 0f8h,0f8h,0fah,0fah,0fah,0f8h,0f8h,0f8h

greenbuttons    dd ?
                db 0f8h,0f6h,0f6h,0f6h,0f6h,0f8h,0f8h,0f8h      ;left
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0f6h,0f8h,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0fah,0f8h,0f8h
                db 0f8h,0fah,0fah,0fah,0fah,0f8h,0f8h,0f8h
                dd ?
                db 0f8h,0f6h,0f6h,0f6h,0f6h,0f6h,0f8h,0f8h      ;up
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0fah,0f8h,0f8h
                db 0f8h,0f8h,0fah,0fah,0fah,0f8h,0f8h,0f8h
                dd ?
                db 0f8h,0f8h,0f6h,0f6h,0f6h,0f6h,0f8h,0f8h      ;right
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f8h,0f8h,0fah,0fah,0fah,0fah,0f8h,0f8h
                dd ?
                db 0f8h,0f8h,0f6h,0f6h,0f6h,0f8h,0f8h,0f8h      ;down
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0f6h,0f8h,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f8h,0fah,0fah,0fah,0fah,0fah,0f8h,0f8h
                dd ?
                db 0f8h,0f8h,0f8h,0f8h,0f6h,0f6h,0f8h,0f8h      ;select
                db 0f8h,0f8h,0f8h,0f6h,0eeh,0eeh,0fah,0f8h
                db 0f8h,0f8h,0f6h,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0fah,0f8h,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0fah,0f8h,0f8h,0f8h
                db 0f6h,0eeh,0eeh,0fah,0f8h,0f8h,0f8h,0f8h
                db 0f8h,0fah,0fah,0f8h,0f8h,0f8h,0f8h,0f8h
                dd ?
                db 0f8h,0f8h,0f8h,0f8h,0f6h,0f6h,0f8h,0f8h      ;start
                db 0f8h,0f8h,0f8h,0f6h,0eeh,0eeh,0fah,0f8h
                db 0f8h,0f8h,0f6h,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0fah,0f8h,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0fah,0f8h,0f8h,0f8h
                db 0f6h,0eeh,0eeh,0fah,0f8h,0f8h,0f8h,0f8h
                db 0f8h,0fah,0fah,0f8h,0f8h,0f8h,0f8h,0f8h
                dd ?
                db 0f8h,0f8h,0f6h,0f6h,0f6h,0f8h,0f8h,0f8h      ;B
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0f6h,0f8h,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0fah,0f8h,0f8h
                db 0f8h,0f8h,0fah,0fah,0fah,0f8h,0f8h,0f8h
                dd ?
                db 0f8h,0f8h,0f6h,0f6h,0f6h,0f8h,0f8h,0f8h      ;A
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0f6h,0f8h,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f6h,0eeh,0eeh,0eeh,0eeh,0eeh,0fah,0f8h
                db 0f8h,0f6h,0eeh,0eeh,0eeh,0fah,0f8h,0f8h
                db 0f8h,0f8h,0fah,0fah,0fah,0f8h,0f8h,0f8h

;----------------------------------------------------------------------------
        end

