.486p
.model flat
.code

        include main.h
        include data.h
        include file.h
        include input.h
        include equates.h
        include empty.h

        public loadconfig
        public saveconfig
        public joy0xmid
        public joy0xmax
        public joy0ymid
        public joy0ymax
        public joy1xmid
        public joy1xmax
        public joy1ymid
        public joy1ymax
        public mouseXmin
        public mouseXmax
        public mouseYmin
        public mouseYmax
        public control0type
        public control1type
        public control0config
        public control1config
        public control2config
        public control3config
        public inputtype
        public vwait
        public showfps
        public vidmode
        public palette
        public soundvol
        public soundmask
        public border0
        public border232
;----------------------------------------------------------------------------
loadconfig:;    load config data from EXE
;       in:
;               ?
;       out:
;               ?
;----------------------------------------------------------------------------
        mov al,'d'                      ;check -d param
        call getswitch
        jnc lc9

        mov edx,[argv]
        mov edx,[edx]                   ;edx=exe name

        mov cl,0
        call f_open                     ;open exe
        jc lc9
        mov al,02h
        mov edx,-CONFIGSIZE
        call f_seek
        jc lc8                          ;seek to config area

        mov ecx,CONFIGSIZE
        mov edx,offset tmp              ;read config
        call f_read

        cmp dword ptr [tmp],CONFIG_ID   ;check for valid ID
        jne lc8

        mov ecx,CONFIGSIZE
        mov esi,offset tmp
        mov edi,offset config
        rep movsb

lc8:    call f_close
lc9:
        call ctrlsetup

        ret
;----------------------------------------------------------------------------
saveconfig:;            write config data to EXE
;       in:
;               ?
;       out:
;               ?
;----------------------------------------------------------------------------
        mov edx,[argv]
        mov edx,[edx]                   ;edx=exe name

        mov cl,2                        ;open exe
        call f_open        
        jc sc19
        mov al,2                        ;seek to config area
        mov edx,-CONFIGSIZE
        call f_seek
        jc sc18
        mov ecx,4                       ;read ID
        mov edx,offset tmp
        call f_read

        mov al,02h
        xor edx,edx
        cmp dword ptr [tmp],CONFIG_ID   ;if ID exists
        jne sc0
        mov edx,-CONFIGSIZE                     ;overwrite old config
sc0:    call f_seek
        jc sc18                         ;seek to config area

        mov [configID],CONFIG_ID
        mov ecx,CONFIGSIZE
        mov edx,offset config           ;write config
        call f_write
sc18:   call f_close
sc19:   ret
;----------------------------------------------------------------------------
                align 4

config:         ;stuff saved to .EXE

CONFIG_ID       equ 12345678h
configID        dd 0

palette label dword                     ;current palette
include palette.txt                     ;(0RGB*64)

                                        ;joystick calibration:
joy0xmid        dd ?                       ;lowest value for x center position
joy0xmax        dd ?                       ;lowest value for x right position
joy0ymid        dd ?                       ;lowest value for y center position
joy0ymax        dd ?                       ;lowest value for y up position
joy1xmid        dd ?                       ;..
joy1xmax        dd ?
joy1ymid        dd ?
joy1ymax        dd ?

mouseXmin       dd ?
mouseXmax       dd ?
mouseYmin       dd ?
mouseYmax       dd ?

control0config  db KB_LEFT,KB_UP,KB_RIGHT,KB_DOWN,KB_TAB,KB_ENTER,KB_LSHIFT,KB_Z
                db 24 dup (0)           ;last dword is used for serialload
control1config  db 32 dup (0)
control2config  db 32 dup (0)
control3config  db 32 dup (0)

control0type    db JOYPAD               ;control type (SNSS ID)
control1type    db JOYPAD
                dw ?                    ;(space holder)

inputtype       db KEYBOARD,UNPLUGGED,UNPLUGGED,UNPLUGGED

vwait           dd 0                    ;VRET wait on pageflip
vidmode         dd 1                    ;graphics mode

showfps         db 0                    ;display FPS
soundvol        db 5                    ;SB volume (1-10, 5 is normal)
soundmask       db 11111b               ;sound channel mask

border0         db 1                    ;hide lines 0-7
border232       db 1                    ;hide lines 232-239

CONFIGSIZE      equ $-config

;----------------------------------------------------------------------------
        end
