function Keyboard(eventManager) {
  this._eventManager = eventManager;
  this._events = [];
  this._keys = {};
  this._turboInterval = null; // Turbo fire function
  this._listen();
}

Keyboard.Key = {};
Keyboard.Key.SPACE = 32;
Keyboard.Key.LEFT = 37;
Keyboard.Key.UP = 38;
Keyboard.Key.RIGHT = 39;
Keyboard.Key.DOWN = 40;
Keyboard.Key.S = 83;
Keyboard.Key.SELECT = 17; // Original select (Ctrl)
Keyboard.Key.TURBO = 16; // Turbo fire key
Keyboard.Key.START = 13;

Keyboard.Event = {};
Keyboard.Event.KEY_PRESSED = 'Keyboard.Event.KEY_PRESSED';
Keyboard.Event.KEY_RELEASED = 'Keyboard.Event.KEY_RELEASED';

Keyboard.prototype._listen = function () {
  var self = this;
  $(document).keydown(function (event) {
    if (event.which === Keyboard.Key.TURBO) { 
      if (!self._turboInterval) {
        self._turboInterval = setInterval(function() {
          self._events.push({name: Keyboard.Event.KEY_PRESSED, key: Keyboard.Key.SPACE});
        }, 100); // Speed of fire
      }
    } else if (!self._keys[event.which]) {
      self._keys[event.which] = true;
      self._events.push({name: Keyboard.Event.KEY_PRESSED, key: event.which});
    }
    event.preventDefault();
  });
  $(document).keyup(function (event) {
    if (event.which === Keyboard.Key.TURBO) { 
      if (self._turboInterval) {
        clearInterval(self._turboInterval);
        self._turboInterval = null;
      }
    } else if (self._keys[event.which]) {
      self._keys[event.which] = false;
      self._events.push({name: Keyboard.Event.KEY_RELEASED, key: event.which});
    }
    event.preventDefault();
  });
};

Keyboard.prototype.fireEvents = function () {
  this._events.forEach(function (event) {
    this._eventManager.fireEvent(event);
  }, this);
  this._events = [];
};
