/*-
 * Copyright (c) 2001, 2002 Alex A. Telyatnikov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * /ntsavevmod.cpp ,v 1.0 beta 2001/12/26 23:55:26
 *
 *
 * DisplaySetting customizer                                           
 *                                                                     
 *                                                                     
 * After installing this software in NT4/w2k system                    
 * Display Settings become customizable                                
 *                                                                     
 * Now user-defined setings are stored in                              
 * [HKCU\Control Panel\Display1]                                       
 *                                                                     
 * System-default setting could be found at                            
 * [HKLM\SYSTEM\CurrentControlSet\Hardware Profiles\                   
 *   Current\System\CurrentControlSet\Services\<YourDisplayDriverName>]
 *
 *
 */

#include "windows.h"
#include "winuser.h"

#include <stdio.h>

DEVMODE DisplayMode;
UCHAR Computername[MAX_COMPUTERNAME_LENGTH+2];

#define REG_NAME_BPP    "BitsPerPel"
#define REG_NAME_XRES   "XResolution"
#define REG_NAME_YRES   "YResolution"
#define REG_NAME_VSYNC  "VRefresh"
#define REG_NAME_FLG    "Flags"
#define REG_NAME_MULTI  "MultiHomed"

#define CUR_DISPLAY_NAME     "Display1"
#define CUR_DISPLAY_DEV_NAME "\\\\.\\" CUR_DISPLAY_NAME

#define REG_KEY_CONTROL_PANEL   "Control Panel"
#define REG_KEY_DISPLAY         CUR_DISPLAY_NAME
#define REG_KEY_SYS_DISPLAY     "SYSTEM\\CurrentControlSet\\Hardware Profiles\\Current\\System\\CurrentControlSet\\Services"
#define REG_KEY_NTSVM_CTL       "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Controls Folder\\Display"


LONG
RegQueryLongValue(
  HKEY hKey,            // handle to key
  LPCTSTR lpValueName,  // value name
  LPDWORD lpReserved,   // reserved
  LPDWORD lpType,       // type buffer
  LPBYTE lpData,        // data buffer
  LPDWORD lpcbData      // size of data buffer
  )
{
   DWORD cbData = sizeof(LONG);
   LONG RetVal;
   
   RetVal = RegQueryValueEx(hKey, lpValueName , lpReserved, lpType, lpData, lpcbData ? lpcbData : &cbData);
   return RetVal;
}

void
SaveSettings() {

    HKEY hDisplaySettings;
    HKEY hNtSVmCtl = NULL;
    HKEY hKey;
    HKEY hKey2 = NULL;
    LONG lRes= 0;
    ULONG MultiHomed = 0;
    ULONG MultiHomed2 = 0;

    lRes = RegOpenKeyEx(HKEY_CURRENT_USER,
        REG_KEY_CONTROL_PANEL,
        0, KEY_CREATE_SUB_KEY | KEY_WRITE, &hDisplaySettings);
    if(lRes != ERROR_SUCCESS)
        return;

    lRes = RegOpenKeyEx(HKEY_LOCAL_MACHINE,
        REG_KEY_NTSVM_CTL,
        0, KEY_READ, &hNtSVmCtl);
    if(lRes != ERROR_SUCCESS) {
        hNtSVmCtl = NULL;
    }

    lRes = RegOpenKeyEx(hDisplaySettings,
        REG_KEY_DISPLAY,
        0, KEY_CREATE_SUB_KEY | KEY_WRITE | KEY_READ, &hKey);
    if (lRes != ERROR_SUCCESS) {
        lRes = RegCreateKeyEx(hDisplaySettings,
            REG_KEY_DISPLAY,
            NULL, NULL, 0, KEY_CREATE_SUB_KEY | KEY_WRITE | KEY_READ,
            NULL, &hKey, NULL);
        if (lRes != ERROR_SUCCESS) {
            RegCloseKey(hDisplaySettings);
            return;
        }
    }

    lRes = RegQueryLongValue(hKey, REG_NAME_MULTI , NULL, NULL, (PUCHAR)&(MultiHomed), NULL);
    if(lRes != ERROR_SUCCESS) {
        MultiHomed = 0;
    }
    lRes = RegQueryLongValue(hNtSVmCtl, REG_NAME_MULTI , NULL, NULL, (PUCHAR)&(MultiHomed2), NULL);
    if(lRes == ERROR_SUCCESS) {
        MultiHomed = MultiHomed2;
    }

    if(MultiHomed) {
        lRes = MAX_COMPUTERNAME_LENGTH+1;
        if(!GetComputerName((PCHAR)&Computername, (PULONG)&lRes)) {
            RegCloseKey(hDisplaySettings);
            RegCloseKey(hKey);
            return;
        }
        hKey2 = hKey;
        lRes = RegOpenKeyEx(hKey2,
            (PCHAR)&Computername,
            0, KEY_WRITE, &hKey);
        if(lRes != ERROR_SUCCESS) {
            lRes = RegCreateKeyEx(hKey2,
                (PCHAR)&Computername,
                NULL, NULL, 0, KEY_WRITE, NULL, &hKey, NULL);
            if (lRes != ERROR_SUCCESS) {
                MultiHomed = 0;
                hKey = hKey2;
                hKey2 = NULL;
            }
        }
    }

    EnumDisplaySettings(CUR_DISPLAY_DEV_NAME, ENUM_CURRENT_SETTINGS, &DisplayMode);

    RegSetValueEx(hKey, REG_NAME_BPP   , NULL, REG_DWORD, (PUCHAR)&(DisplayMode.dmBitsPerPel), sizeof(LONG) );
    RegSetValueEx(hKey, REG_NAME_XRES  , NULL, REG_DWORD, (PUCHAR)&(DisplayMode.dmPelsWidth), sizeof(LONG) );
    RegSetValueEx(hKey, REG_NAME_YRES  , NULL, REG_DWORD, (PUCHAR)&(DisplayMode.dmPelsHeight), sizeof(LONG) );
    RegSetValueEx(hKey, REG_NAME_VSYNC , NULL, REG_DWORD, (PUCHAR)&(DisplayMode.dmDisplayFrequency), sizeof(LONG) );
    RegSetValueEx(hKey, REG_NAME_FLG   , NULL, REG_DWORD, (PUCHAR)&(DisplayMode.dmDisplayFlags), sizeof(LONG) );

    RegCloseKey(hDisplaySettings);
    RegCloseKey(hKey);
    if(hKey2)
        RegCloseKey(hKey2);
    if(hNtSVmCtl)
        RegCloseKey(hNtSVmCtl);
}

void
RestoreSettings() {

    HKEY hDisplaySettings;
    HKEY hNtSVmCtl = NULL;
    HKEY hKey;
    HKEY hKey2 = NULL;
    ULONG lRes= 0;
    ULONG MultiHomed = 0;
    ULONG MultiHomed2 = 0;

    lRes = RegOpenKeyEx(HKEY_CURRENT_USER,
        REG_KEY_CONTROL_PANEL,
        0, KEY_READ, &hDisplaySettings);
    if(lRes != ERROR_SUCCESS)
        return;

    lRes = RegOpenKeyEx(HKEY_LOCAL_MACHINE,
        REG_KEY_NTSVM_CTL,
        0, KEY_READ, &hNtSVmCtl);
    if(lRes != ERROR_SUCCESS) {
        hNtSVmCtl = NULL;
    }

    lRes = RegOpenKeyEx(hDisplaySettings,
        REG_KEY_DISPLAY,
        0, KEY_READ, &hKey);
    if(lRes != ERROR_SUCCESS) {
        RegCloseKey(hDisplaySettings);
        return;
    }

    lRes = RegQueryLongValue(hKey, REG_NAME_MULTI , NULL, NULL, (PUCHAR)&(MultiHomed), NULL);
    if(lRes != ERROR_SUCCESS) {
        MultiHomed = 0;
    }
    lRes = RegQueryLongValue(hNtSVmCtl, REG_NAME_MULTI , NULL, NULL, (PUCHAR)&(MultiHomed2), NULL);
    if(lRes == ERROR_SUCCESS) {
        MultiHomed = MultiHomed2;
    }

    if(MultiHomed) {
        lRes = MAX_COMPUTERNAME_LENGTH+1;
        if(!GetComputerName((PCHAR)&Computername, (PULONG)&lRes)) {
            RegCloseKey(hDisplaySettings);
            RegCloseKey(hKey);
            return;
        }
        hKey2 = hKey;
        lRes = RegOpenKeyEx(hKey2,
            (PCHAR)&Computername,
            0, KEY_READ, &hKey);
        if(lRes != ERROR_SUCCESS) {
            MultiHomed = 0;
            hKey = hKey2;
            hKey2 = NULL;
        }
    }

    EnumDisplaySettings(CUR_DISPLAY_DEV_NAME, ENUM_CURRENT_SETTINGS, &DisplayMode);

    RegQueryLongValue(hKey, REG_NAME_BPP   , NULL, NULL, (PUCHAR)&(DisplayMode.dmBitsPerPel),       NULL);
    RegQueryLongValue(hKey, REG_NAME_XRES  , NULL, NULL, (PUCHAR)&(DisplayMode.dmPelsWidth),        NULL);
    RegQueryLongValue(hKey, REG_NAME_YRES  , NULL, NULL, (PUCHAR)&(DisplayMode.dmPelsHeight),       NULL);
    RegQueryLongValue(hKey, REG_NAME_VSYNC , NULL, NULL, (PUCHAR)&(DisplayMode.dmDisplayFrequency), NULL);
    RegQueryLongValue(hKey, REG_NAME_FLG   , NULL, NULL, (PUCHAR)&(DisplayMode.dmDisplayFlags),     NULL);

    DisplayMode.dmFields = 
        DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT | DM_DISPLAYFLAGS | DM_DISPLAYFREQUENCY;
    ChangeDisplaySettingsEx(CUR_DISPLAY_DEV_NAME,  &DisplayMode, NULL, 
        CDS_SET_PRIMARY, NULL);
    ChangeDisplaySettingsEx(CUR_DISPLAY_DEV_NAME,  &DisplayMode, NULL, 
        CDS_UPDATEREGISTRY, NULL);

    RegCloseKey(hDisplaySettings);
    RegCloseKey(hKey);
    if(hKey2)
        RegCloseKey(hKey2);
    if(hNtSVmCtl)
        RegCloseKey(hNtSVmCtl);
}

BOOL WINAPI 
LogoffHandler(
    DWORD dwCtrlType   //  control signal type
    )
{
//    __asm int 3;
    SaveSettings();
    return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
extern "C" int WINAPI WinMain(HINSTANCE hInstance, 
    HINSTANCE /*hPrevInstance*/, LPTSTR lpCmdLine, int /*nShowCmd*/)
{
    HKEY hRegKey = 0;
//    HANDLE hRegChg = 0;
    LONG RegChg = 0;

    Sleep(1000);
    RestoreSettings();
    Sleep(2000);
    RestoreSettings();
    Sleep(3000);
    RestoreSettings();
    Sleep(5000);
    RestoreSettings();
    Sleep(10000);
//    SaveSettings();

    SetConsoleCtrlHandler(LogoffHandler, TRUE);

    RegChg = RegOpenKeyEx(HKEY_LOCAL_MACHINE,
        REG_KEY_SYS_DISPLAY,
        0, KEY_READ, &hRegKey);
    if(RegChg != ERROR_SUCCESS)
        return 0;

    while(1) {
        RegChg = RegNotifyChangeKeyValue(hRegKey, TRUE, REG_NOTIFY_CHANGE_LAST_SET, NULL, FALSE);
        if(RegChg != ERROR_SUCCESS)
            break;
        SaveSettings();
    }

    // When we get here, the service has been stopped
    return 0;
}

