import java.awt. *;
import java.awt.event.*;
import javax.swing. *;

public class ModifyLinuxDialog extends javax.swing.JDialog
{   static final int CANCEL = 0;
    static final int OK = 1;

    int status = CANCEL;


    public ModifyLinuxDialog(Frame parentFrame, boolean isNew, String fileName, String fileDate, String fileLength,
			     String uid, String gid, String access)
    {   super(parentFrame);
	// This code is automatically generated by Visual Cafe when you add
	// components to the visual environment. It instantiates and initializes
	// the components. To modify the code, only use code syntax that matches
	// what Visual Cafe can generate, or Visual Cafe may be unable to back
	// parse your Java file into its visual environment.
	//{{INIT_CONTROLS
		setModal(true);
		setTitle("LTOOL Modify Linux file or directory");
		getContentPane().setLayout(new GridLayout(9,2,0,0));
		setSize(366,392);
		setVisible(false);
		Text1Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text1Label.setText("Name:");
		getContentPane().add(Text1Label);
		Text1Label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text1Label.setBounds(0,0,183,43);
		getContentPane().add(fileNameField);
		fileNameField.setFont(new Font("SansSerif", Font.BOLD, 12));
		fileNameField.setBounds(183,0,183,43);
		Text2Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text2Label.setText("Modification date:");
		getContentPane().add(Text2Label);
		Text2Label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text2Label.setBounds(0,43,183,43);
		fileDateField.setEditable(false);
		fileDateField.setOpaque(false);
		getContentPane().add(fileDateField);
		fileDateField.setFont(new Font("SansSerif", Font.BOLD, 12));
		fileDateField.setBounds(183,43,183,43);
		Text3Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text3Label.setText("Length:");
		getContentPane().add(Text3Label);
		Text3Label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text3Label.setBounds(0,86,183,43);
		getContentPane().add(fileLengthLabel);
		fileLengthLabel.setFont(new Font("SansSerif", Font.BOLD, 12));
		fileLengthLabel.setBounds(183,86,183,43);
		GidPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(GidPanel);
		GidPanel.setBounds(0,129,183,43);
		JLabel1.setText("GID     ");
		GidPanel.add(JLabel1);
		JLabel1.setFont(new Font("SansSerif", Font.BOLD, 12));
		JLabel1.setBounds(40,7,34,15);
		GidField.setText("                            ");
		GidPanel.add(GidField);
		GidField.setFont(new Font("SansSerif", Font.BOLD, 12));
		GidField.setBounds(79,5,64,19);
		UidPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(UidPanel);
		UidPanel.setBounds(183,129,183,43);
		JLabel2.setText("UID     ");
		UidPanel.add(JLabel2);
		JLabel2.setFont(new Font("SansSerif", Font.BOLD, 12));
		JLabel2.setBounds(40,7,34,15);
		UidField.setText("                            ");
		UidPanel.add(UidField);
		UidField.setFont(new Font("SansSerif", Font.BOLD, 12));
		UidField.setBounds(79,5,64,19);
		Text4label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text4label.setText("Type:");
		getContentPane().add(Text4label);
		Text4label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text4label.setBounds(0,172,183,43);
		FileTypePanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(FileTypePanel);
		FileTypePanel.setBounds(183,172,183,43);
		DirBox.setText("Dir");
		DirBox.setActionCommand("Directory");
		DirBox.setEnabled(false);
		FileTypePanel.add(DirBox);
		DirBox.setBounds(18,5,41,23);
		LinkBox.setText("Link");
		LinkBox.setActionCommand("Read only");
		LinkBox.setEnabled(false);
		FileTypePanel.add(LinkBox);
		LinkBox.setBounds(64,5,49,23);
		DevBox.setText("Dev");
		DevBox.setActionCommand("Directory");
		DevBox.setEnabled(false);
		FileTypePanel.add(DevBox);
		DevBox.setBounds(118,5,46,23);
		Text5abel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text5abel.setText("User access rights");
		getContentPane().add(Text5abel);
		Text5abel.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text5abel.setBounds(0,215,183,43);
		UAccPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(UAccPanel);
		UAccPanel.setBounds(183,215,183,43);
		rBoxU.setText("r");
		rBoxU.setActionCommand("Directory");
		UAccPanel.add(rBoxU);
		rBoxU.setBounds(38,5,30,23);
		wBoxU.setText("w");
		wBoxU.setActionCommand("Read only");
		UAccPanel.add(wBoxU);
		wBoxU.setBounds(73,5,35,23);
		xBoxU.setText("x");
		xBoxU.setActionCommand("Directory");
		UAccPanel.add(xBoxU);
		xBoxU.setBounds(113,5,32,23);
		Text6label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text6label.setText("Group access rights");
		getContentPane().add(Text6label);
		Text6label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text6label.setBounds(0,258,183,43);
		GAccPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(GAccPanel);
		GAccPanel.setBounds(183,258,183,43);
		rBoxG.setText("r");
		rBoxG.setActionCommand("Directory");
		GAccPanel.add(rBoxG);
		rBoxG.setBounds(38,5,30,23);
		wBoxG.setText("w");
		wBoxG.setActionCommand("Read only");
		GAccPanel.add(wBoxG);
		wBoxG.setBounds(73,5,35,23);
		xBoxG.setText("x");
		xBoxG.setActionCommand("Directory");
		GAccPanel.add(xBoxG);
		xBoxG.setBounds(113,5,32,23);
		Text7label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text7label.setText("World access rights");
		getContentPane().add(Text7label);
		Text7label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text7label.setBounds(0,301,183,43);
		WAccPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(WAccPanel);
		WAccPanel.setBounds(183,301,183,43);
		rBoxW.setText("r");
		rBoxW.setActionCommand("Directory");
		WAccPanel.add(rBoxW);
		rBoxW.setBounds(38,5,30,23);
		wBoxW.setText("w");
		wBoxW.setActionCommand("Read only");
		WAccPanel.add(wBoxW);
		wBoxW.setBounds(73,5,35,23);
		xBoxW.setText("x");
		xBoxW.setActionCommand("Directory");
		WAccPanel.add(xBoxW);
		xBoxW.setBounds(113,5,32,23);
		okButton.setText("OK");
		okButton.setOpaque(false);
		okButton.setActionCommand("OK");
		okButton.setMnemonic((int)'O');
		getContentPane().add(okButton);
		okButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		okButton.setBounds(0,344,183,43);
		cancelButton.setText("Cancel");
		cancelButton.setActionCommand("Cancel");
		getContentPane().add(cancelButton);
		cancelButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		cancelButton.setBounds(183,344,183,43);
		//}}
	if (isNew)
        {   setTitle("LTOOL New Linux directory or symlink");
	    DirBox.setEnabled(true);
	    DirBox.setSelected(true);
	    LinkBox.setEnabled(true);
	}
	fileNameField.setText(fileName);
	 fileDateField.setText(fileDate);
	 fileLengthLabel.setText(fileLength);
	 GidField.setText(gid);
	 UidField.setText(uid);

	if (access.startsWith("d"))
	     DirBox.setSelected(true);
	if (access.startsWith("l"))
	     LinkBox.setSelected(true);
	if (!access.startsWith("-") && !access.startsWith("d") && !access.startsWith("l"))
	     DevBox.setSelected(true);

	if (access.length() >= 10)
        {   if (access.substring(1, 2).equals("r"))
		rBoxU.setSelected(true);
	    if (access.substring(2, 3).equals("w"))
		wBoxU.setSelected(true);
	    if (access.substring(3, 4).equals("x"))
		xBoxU.setSelected(true);
	    if (access.substring(4, 5).equals("r"))
		rBoxG.setSelected(true);
	    if (access.substring(5, 6).equals("w"))
		wBoxG.setSelected(true);
	    if (access.substring(6, 7).equals("x"))
		xBoxG.setSelected(true);
	    if (access.substring(7, 8).equals("r"))
		rBoxW.setSelected(true);
	    if (access.substring(8, 9).equals("w"))
		wBoxW.setSelected(true);
	    if (access.substring(9).equals("x"))
		xBoxW.setSelected(true);
	}
	//{{REGISTER_LISTENERS
	SymWindow aSymWindow = new SymWindow();
	this.addWindowListener(aSymWindow);
	SymAction lSymAction = new SymAction();
	okButton.addActionListener(lSymAction);
	cancelButton.addActionListener(lSymAction);
	DirBox.addActionListener(lSymAction);
	LinkBox.addActionListener(lSymAction);
	//}}
    }


    public int getStatus()
    {   return status;
    }

    public String getFileName()
    {   return fileNameField.getText();
    }

    public String getUid()
    {   return UidField.getText();
    }

    public String getGid()
    {   return GidField.getText();
    }

    public String getAccess()
    {   int accessU = 0, accessG = 0, accessW = 0;
	if (rBoxU.isSelected())
	     accessU = accessU + 4;
	if (wBoxU.isSelected())
	     accessU = accessU + 2;
	if (xBoxU.isSelected())
	     accessU = accessU + 1;
	if (rBoxG.isSelected())
	     accessG = accessG + 4;
	if (wBoxG.isSelected())
	     accessG = accessG + 2;
	if (xBoxG.isSelected())
	     accessG = accessG + 1;
	if (rBoxW.isSelected())
	     accessW = accessW + 4;
	if (wBoxW.isSelected())
	     accessW = accessW + 2;
	if (xBoxW.isSelected())
	     accessW = accessW + 1;

	 return (new Integer(accessU)).toString() + (new Integer(accessG)).toString() + (new Integer(accessW)).toString();
    }

    public boolean isDirectory()
    {   return DirBox.isSelected();
    }

    public boolean isLink()
    {   return LinkBox.isSelected();
    }

    public String getTargetName()
    {   return fileDateField.getText();
    }


    public void setVisible(boolean b)
    {   if (b)
        {   Rectangle bounds = (getParent()).getBounds();
	    Dimension size = getSize();
	     setLocation(bounds.x + (bounds.width - size.width) / 2,
			 bounds.y + (bounds.height - size.height) / 2);
	}
	super.setVisible(b);
    }

    public void addNotify()
    {								// Record the size of the window prior to calling parents addNotify.
	Dimension d = getSize();

	 super.addNotify();

	if (fComponentsAdjusted)
	     return;
	// Adjust components according to the insets
	Insets insets = getInsets();
	 setSize(insets.left + insets.right + d.width, insets.top + insets.bottom + d.height);
	Component components[] = getContentPane().getComponents();
	for (int i = 0; i < components.length; i++)
        {   Point p = components[i].getLocation();
	     p.translate(insets.left, insets.top);
	     components[i].setLocation(p);
	}
	fComponentsAdjusted = true;
    }

    // Used for addNotify check.
    boolean fComponentsAdjusted = false;

    //{{DECLARE_CONTROLS
	javax.swing.JLabel Text1Label = new javax.swing.JLabel();
	javax.swing.JTextField fileNameField = new javax.swing.JTextField();
	javax.swing.JLabel Text2Label = new javax.swing.JLabel();
	javax.swing.JTextField fileDateField = new javax.swing.JTextField();
	javax.swing.JLabel Text3Label = new javax.swing.JLabel();
	javax.swing.JLabel fileLengthLabel = new javax.swing.JLabel();
	javax.swing.JPanel GidPanel = new javax.swing.JPanel();
	javax.swing.JLabel JLabel1 = new javax.swing.JLabel();
	javax.swing.JTextField GidField = new javax.swing.JTextField();
	javax.swing.JPanel UidPanel = new javax.swing.JPanel();
	javax.swing.JLabel JLabel2 = new javax.swing.JLabel();
	javax.swing.JTextField UidField = new javax.swing.JTextField();
	javax.swing.JLabel Text4label = new javax.swing.JLabel();
	javax.swing.JPanel FileTypePanel = new javax.swing.JPanel();
	javax.swing.JCheckBox DirBox = new javax.swing.JCheckBox();
	javax.swing.JCheckBox LinkBox = new javax.swing.JCheckBox();
	javax.swing.JCheckBox DevBox = new javax.swing.JCheckBox();
	javax.swing.JLabel Text5abel = new javax.swing.JLabel();
	javax.swing.JPanel UAccPanel = new javax.swing.JPanel();
	javax.swing.JCheckBox rBoxU = new javax.swing.JCheckBox();
	javax.swing.JCheckBox wBoxU = new javax.swing.JCheckBox();
	javax.swing.JCheckBox xBoxU = new javax.swing.JCheckBox();
	javax.swing.JLabel Text6label = new javax.swing.JLabel();
	javax.swing.JPanel GAccPanel = new javax.swing.JPanel();
	javax.swing.JCheckBox rBoxG = new javax.swing.JCheckBox();
	javax.swing.JCheckBox wBoxG = new javax.swing.JCheckBox();
	javax.swing.JCheckBox xBoxG = new javax.swing.JCheckBox();
	javax.swing.JLabel Text7label = new javax.swing.JLabel();
	javax.swing.JPanel WAccPanel = new javax.swing.JPanel();
	javax.swing.JCheckBox rBoxW = new javax.swing.JCheckBox();
	javax.swing.JCheckBox wBoxW = new javax.swing.JCheckBox();
	javax.swing.JCheckBox xBoxW = new javax.swing.JCheckBox();
	javax.swing.JButton okButton = new javax.swing.JButton();
	javax.swing.JButton cancelButton = new javax.swing.JButton();
	//}}

    class SymWindow extends java.awt.event.WindowAdapter
    {   public void windowClosing(java.awt.event.WindowEvent event)
        {   Object object = event.getSource();
	    if (object == ModifyLinuxDialog.this)
		 jAboutDialog_windowClosing(event);
	}
    }

    void jAboutDialog_windowClosing(java.awt.event.WindowEvent event)
    {								// to do: code goes here.

	jAboutDialog_windowClosing_Interaction1(event);
    }

    void jAboutDialog_windowClosing_Interaction1(java.awt.event.WindowEvent event)
    {   try
	{							// JAboutDialog Hide the JAboutDialog
	    this.setVisible(false);
	}
	catch(Exception e)
        {
        }
    }

    class SymAction implements java.awt.event.ActionListener
    {   public void actionPerformed(java.awt.event.ActionEvent event)
        {   Object object = event.getSource();
	    if (object == okButton)
		 okButton_actionPerformed(event);
	    else if (object == cancelButton)
		 cancelButton_actionPerformed(event);
	    else if (object == DirBox)
		 DirBox_actionPerformed(event);
	    else if (object == LinkBox)
		 LinkBox_actionPerformed(event);
	}
    }

    void okButton_actionPerformed(java.awt.event.ActionEvent event)
    {   status = OK;
	try
	{							// JAboutDialog Hide the JAboutDialog
	    this.setVisible(false);
	}
	catch(Exception e)
        {
        }
    }

    void cancelButton_actionPerformed(java.awt.event.ActionEvent event)
    {   status = CANCEL;
	try
	{							// JAboutDialog Hide the JAboutDialog
	    this.setVisible(false);
	}
	catch(Exception e)
        {
        }
    }

    void DirBox_actionPerformed(java.awt.event.ActionEvent event)
    {   LinkBox.setSelected(!DirBox.isSelected());
	if (LinkBox.isSelected())
        {   Text2Label.setText("Symlink target:");
	    fileDateField.setOpaque(true);
	    fileDateField.setText(" ");
	    fileDateField.setEditable(true);
	} else
        {   Text2Label.setText("");
	    fileDateField.setOpaque(false);
	    fileDateField.setText(" ");
	    fileDateField.setEditable(false);
	}
    }

    void LinkBox_actionPerformed(java.awt.event.ActionEvent event)
    {   DirBox.setSelected(!LinkBox.isSelected());
	if (LinkBox.isSelected())
        {   Text2Label.setText("Symlink target:");
	    fileDateField.setOpaque(true);
	    fileDateField.setText(" ");
	    fileDateField.setEditable(true);
	} else
        {   Text2Label.setText("");
	    fileDateField.setOpaque(false);
	    fileDateField.setText(" ");
	    fileDateField.setEditable(false);
	}
    }

    //This is only used for debugging purposes to run as stand alone program
    static public void main(String args[])
    {	JFrame myFrame = new JFrame("ModifyDosDialog Test");
        myFrame.setSize(600,400);
        myFrame.setVisible(true);
    	ModifyLinuxDialog myDialog = new ModifyLinuxDialog(myFrame, false, "fileName", "fileDate", "fileLength",
			     "uid", "gid", "-r---w---x");
    	myDialog.setVisible(true);
    	myFrame.addWindowListener(new WindowAdapter()
        {   public void windowClosing(WindowEvent e)
            {   System.exit(0);
	    }
	});
    }

}

