import java.awt. *;
import java.awt.event. *;
import java.io. *;

import javax.swing. *;
import javax.swing.event. *;


//######Help dialog box########################################################
class HelpBox extends JDialog
{   int currentFilePointer;

    static final int maxFiles = 4;
    String[] currentFileCache = new String[maxFiles];

    public HelpBox(Frame parent, boolean modal, String baseDirectory)
    {								//{{INIT_CONTROLS
		setTitle("LTOOLgui Help");
		getContentPane().setLayout(new BorderLayout(0,0));
		setSize(800,600);
		setVisible(false);
		getContentPane().add(BorderLayout.CENTER, scrollPane);
		scrollPane.setBounds(0,0,800,465);
		JPanel1.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.SOUTH, JPanel1);
		JPanel1.setBounds(0,565,800,35);
		overviewButton.setText("Overview");
		overviewButton.setActionCommand("Overview");
		JPanel1.add(overviewButton);
		overviewButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		overviewButton.setBounds(188,5,87,25);
		PrevButton.setText("Previous");
		JPanel1.add(PrevButton);
		PrevButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		PrevButton.setBounds(280,5,85,25);
		NextButton.setText("   Next    ");
		JPanel1.add(NextButton);
		NextButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		NextButton.setBounds(370,5,81,25);
		JLabel1.setText("                            ");
		JPanel1.add(JLabel1);
		JLabel1.setBounds(456,10,84,15);
		closeButton.setText("Close");
		closeButton.setActionCommand("Close");
		JPanel1.add(closeButton);
		closeButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		closeButton.setBounds(545,5,67,25);
		//}}

	_view.setEditable(false);
	_view.setBounds(0, 0, 800, 565);
	scrollPane.setViewportView(_view);

	currentFileCache[0] = baseDirectory+"ltoolgui1.htm";
	currentFileCache[1] = baseDirectory+"ltoolgui2.htm";
	currentFileCache[2] = baseDirectory+"ltoolgui3.htm";
	currentFileCache[3] = baseDirectory+"ltoolgui4.htm";

	currentFileCache[0].replace('/',File.separatorChar);
	currentFileCache[1].replace('/',File.separatorChar);
	currentFileCache[2].replace('/',File.separatorChar);
	currentFileCache[3].replace('/',File.separatorChar);

	currentFilePointer=0;

	showCurrentFile();

	//{{REGISTER_LISTENERS
	SymAction lSymAction = new SymAction();
	closeButton.addActionListener(lSymAction);
	SymHyperlink lSymHyperlink = new SymHyperlink();
	_view.addHyperlinkListener(lSymHyperlink);
	overviewButton.addActionListener(lSymAction);
	PrevButton.addActionListener(lSymAction);
	NextButton.addActionListener(lSymAction);
	//}}
    }


    //{{DECLARE_CONTROLS
	javax.swing.JScrollPane scrollPane = new javax.swing.JScrollPane();
	javax.swing.JPanel JPanel1 = new javax.swing.JPanel();
	javax.swing.JButton overviewButton = new javax.swing.JButton();
	javax.swing.JButton PrevButton = new javax.swing.JButton();
	javax.swing.JButton NextButton = new javax.swing.JButton();
	javax.swing.JLabel JLabel1 = new javax.swing.JLabel();
	javax.swing.JButton closeButton = new javax.swing.JButton();
	//}}
    JEditorPane _view = new JEditorPane();

    class SymAction implements java.awt.event.ActionListener
    {   public void actionPerformed(java.awt.event.ActionEvent event)
        {   Object object = event.getSource();
	    if (object == closeButton)
		 closeButton_actionPerformed(event);
	    else if (object == overviewButton)
		 overviewButton_actionPerformed(event);
			else if (object == PrevButton)
				PrevButton_actionPerformed(event);
			else if (object == NextButton)
				NextButton_actionPerformed(event);
	}
    }

    void closeButton_actionPerformed(java.awt.event.ActionEvent event)
    {   setVisible(false);
    }


    class SymHyperlink implements javax.swing.event.HyperlinkListener
    {   public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent event)
        {   Object object = event.getSource();
	    if (object == _view)
		 View_hyperlinkUpdate(event);
	}
    }

    void searchFileInCache(String newFile)
    {   String searchFile = newFile.replace('/',File.separatorChar);
        
    	for (int i=0; i < maxFiles; i++)
        {   currentFileCache[i].replace('/',File.separatorChar);
//          System.out.println("search="+searchFile+"   current="+currentFileCache[i]);
            if (searchFile.indexOf(currentFileCache[i]) != -1)
            {	currentFilePointer=i;

//            	System.out.println("--- found i="+i);
            	return;
            }
        }
	JOptionPane.showMessageDialog(this, "Invalid help "+searchFile, "LTOOLS", JOptionPane.ERROR_MESSAGE);
    }

    void showCurrentFile()
    {   try
        {
	    _view.setPage(currentFileCache[currentFilePointer]);
	}
	catch(IOException e)
        {   System.out.println("Could not find " + currentFileCache[currentFilePointer] + " " + e);
	}
	ManageNavigationButtons();
    }

    void View_hyperlinkUpdate(javax.swing.event.HyperlinkEvent event)
    {   if (event.getEventType()!=HyperlinkEvent.EventType.ACTIVATED)
    	    return;

	searchFileInCache(event.getURL().toString());
    	showCurrentFile();
    }

    void overviewButton_actionPerformed(java.awt.event.ActionEvent event)
    {   currentFilePointer=0;
    	showCurrentFile();
    }

/*
    //This is for testing only to run HelpBox as standalone program
    static public void main(String args[])
    {	JFrame myFrame = new JFrame("HelpBox Test");
        myFrame.setSize(600,200);
    	myFrame.setVisible(true);
    	HelpBox myBox = new HelpBox(myFrame,false);
    	myBox.setVisible(true);
    	myFrame.addWindowListener(new WindowAdapter()
        {   public void windowClosing(WindowEvent e)
            {   System.exit(0);
	    }
	});
    }
*/

	void ManageNavigationButtons()
	{	if (currentFilePointer==0)
		    PrevButton.setEnabled(false);
		else
		    PrevButton.setEnabled(true);

		if (currentFilePointer==(maxFiles-1))
		    NextButton.setEnabled(false);
		else
		    NextButton.setEnabled(true);
	}

	void PrevButton_actionPerformed(java.awt.event.ActionEvent event)
	{
		currentFilePointer--;
		if (currentFilePointer < 0)
		{   currentFilePointer=0;
		}
		showCurrentFile();

	}

	void NextButton_actionPerformed(java.awt.event.ActionEvent event)
	{
		currentFilePointer++;
		if (currentFilePointer > (maxFiles-1))
		    currentFilePointer=maxFiles-1;
		showCurrentFile();
	}
}

