' This file has no copyright assigned and is placed in the Public Domain
' This mouse demo is based on a serial mouse demo by Tony Burchan
'
defint a-z

dim I(50) as word
screen 12

'***************
'Create the mouse cursor and grab it.
pat$ = "FCF8F0D8CC860300" 'this is an arrow shaped cursor pattern

for ln = 1 to 16 step 2
  line (0,int(ln/2))-(16,int(ln/2)),15,,val("&H" & mid$(pat$,ln,2))
next ln

get (7, 0)-(16,8),I
line (0,0)-(639,479),15,BF 'generate a background
put (0%,0%), I, xor 'erase the original cursor image
locate 1,1 : print "  ";

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h)
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'indicate iso
  int_interval    as byte  'int
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

buffer$=repeat$(64,chr$(0))   'return data here

color 15,1 : cls
locate 14,20 : input "Please enter device address: ", devadd%
cls
locate 14,12 : print "Press any key to stop program - move your mouse now"
delay 2
cls

while not instat

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=1
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=strptr(buffer$)
  urb.buffer_seg=strseg(buffer$)
  urb.buffer_length=8
  urb.actual_length=8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=4 '10 'should read from device descriptor
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

OX% = PX% 'save old positions
OY% = PY%

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

if urb.actual_length >0 then
 B%=ascii(mid$(buffer$,1,1))
 RX%=ascii(mid$(buffer$,2,1))
 RY%=ascii(mid$(buffer$,3,1))
 Opt%=ascii(mid$(buffer$,4,1))

 if rx%>0 then
  if rx%>127 then rx%=(256-rx%) * -1 'signed byte
  PX%=PX%+RX%
  if px%<1 then px%=1
  if px%>630 then px%=630
 end if
 if ry%>0 then
  if ry%>127 then ry%=(265-ry%) * -1 'signed byte
  ry%=ry%/1.35
  PY%=PY%+RY%
  if py%<1 then py%=1
  if py%>470 then py%=470
 end if
 if opt%>127 then opt%=(256-opt%) * -1 'signed byte

 if (ox%+oy%)>0 then locate 1,1 : print "  "
 put (OX%, OY%), I, xor 'erase last cursor image
 put (PX%, PY%), I, xor 'draw new cursor image
end if
 locate 28,1 : print "Button:" B%,"X-Pos:" PX%,"Y-Pos:" PY%, "Wheel:" Opt% "     ";

wend

end

