'This demo sends data to a USB/serial adapter and reads data from it
'It is implemented as a simple terminal application. The data entered
'at the keyboard is send to the remote siut echoed on the screen in
'inverted color. The data received from the remote site is displayed in
'standard color.
'

defint a-z

cls

input "Please enter device address: ", devadd%


'devadd%=2

'prolific standard
in_endpoint%=3
out_endpoint%=2

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

dim buffer as string*1025
buffer=repeat$(1025,chr$(0)) 'return data here

'*************************************************************************************************
'definitions done start code now

gosub do_set_line_coding
gosub do_get_line_coding
gosub do_set_control_line_state
'gosub do_vendor_01_8
'gosub do_vendor_01_5
'gosub do_vendor_01_0

cls
print "Simple TTY-Terminal at 38.400 baud - press ESC to exit"
print

save_in_endpoint%=in_endpoint%
in_endpoint%=1 'query interrupt endpoint
gosub do_in
print "Line status in hex: ";
for i=1 to 2
print hex$(ascii(mid$(buffer,i,1))) " ";
next i
print

in_endpoint%=save_in_endpoint%

while (1)
        gosub do_in
        if urb.actual_length>0 then
           color 7,0
	   print mid$(buffer,1,urb.actual_length);
        end if
	while instat
           myinput$ = inkey$
           if myinput$=chr$(27) then goto quitloop 'ESC
           color 0,7
           print myinput$; 'echo typed characters on screen in invers
           buf_len%=1
           mid$(buffer,1,1)=myinput$
           gosub do_out
        wend
wend
quitloop:

end
'*************************************************************************************************
'*************************************************************************************************
do_in:
'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64 '128 '32 '16
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'transaction error?
if urb.status >1 then
	'print hex$(urb.status);
end if

return

'*************************************************************************************************
do_out:
'outputs data in buffer

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=buf_len%
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        end
end if

'transaction error?
if urb.status >1 then
	'print hex$(urb.status);
end if

buffer=repeat$(1025,chr$(0)) 'clear buffer again

return

'*************************************************************************************************

do_get_line_coding:

device_request.bmRequestType=&HA1
device_request.bRequest=&H21
device_request.wValue=&H00
device_request.wIndex=0
device_request.wLength=&H7

'set up get Line Coding request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(buffer)
  urb.buffer_off=varptr(buffer)
  urb.buffer_length=18
  urb.actual_length=64
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        locate 24,23
        input "Press enter to continue", a$
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        locate 24,23
        input "Press enter to continue", a$
        end
end if

$if 0
a$=mid$(buffer,1,4)
print "Status: " a$
a%=ascii(mid$(a$,1,1))
print hex$(a%) " " bin$(a%)
$endif

return

'*************************************************************************************************

do_set_line_coding:

device_request.bmRequestType=&H21
device_request.bRequest=&H20
device_request.wValue=&H00
device_request.wIndex=0
device_request.wLength=&H7

'set up get Line Coding request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=0 'varseg(buffer)
  urb.buffer_off=0 'varptr(buffer)
  urb.buffer_length=0
  urb.actual_length=0
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        locate 24,23
        input "Press enter to continue", a$
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        locate 24,23
        input "Press enter to continue", a$
        end
end if

'now send line coding structure - 38400 baud 8-N-1
save_in_endpoint%=in_endpoint%
save_out_endpoint%=out_endpoint%
'&H01C200=115200baud,&HE100=57600baud,&H9600=38400,&H4B00=19200,
'&H2580=9600,&H12C0=4800,&H0960=2400,&H04B0=1200baud
'so chr$(&H00)+chr$(&H96) = &H9600 (little endian) = 38400 baud
'chr$(8) = 8bit
mid$(buffer,1,7)=chr$(&H00)+chr$(&H96)+chr$(0)+chr$(0)+chr$(0)+chr$(0)+chr$(8)
out_endpoint%=0
buf_len%=7
gosub do_out
'acknowledge with in
in_endpoint%=0
gosub do_in
in_endpoint%=save_in_endpoint%
out_endpoint%=save_out_endpoint%

return

'*************************************************************************************************

do_set_control_line_state:

device_request.bmRequestType=&H21
device_request.bRequest=&H22
device_request.wValue=&H03
device_request.wIndex=0
device_request.wLength=&H0

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(buffer)
  urb.buffer_off=varptr(buffer)
  urb.buffer_length=0
  urb.actual_length=0
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        locate 24,23
        input "Press enter to continue", a$
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        locate 24,23
        input "Press enter to continue", a$
        end
end if

return

'*************************************************************************************************

do_vendor_01_0:

device_request.bmRequestType=&H40
device_request.bRequest=&H01
device_request.wValue=&H00
device_request.wIndex=&H61
device_request.wLength=&H0

gosub do_the_request

return

'*************************************************************************************************

do_vendor_01_5:

device_request.bmRequestType=&H40
device_request.bRequest=&H01
device_request.wValue=&H0505
device_request.wIndex=&H1311
device_request.wLength=&H0

gosub do_the_request

return

'*************************************************************************************************

do_vendor_01_8:

device_request.bmRequestType=&H40
device_request.bRequest=&H01
device_request.wValue=&H0808
device_request.wIndex=&H0
device_request.wLength=&H0

gosub do_the_request

return

'*************************************************************************************************

do_vendor_01_9:

device_request.bmRequestType=&H40
device_request.bRequest=&H01
device_request.wValue=&H0909
device_request.wIndex=&H0
device_request.wLength=&H0

gosub do_the_request

return

'*************************************************************************************************
do_the_request:

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(buffer)
  urb.buffer_off=varptr(buffer)
  urb.buffer_length=0
  urb.actual_length=0
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        locate 24,23
        input "Press enter to continue", a$
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        locate 24,23
        input "Press enter to continue", a$
        end
end if

return

