'global Variables

dim usb_buffer as shared string*&H4000 '16kb
usb_buffer=repeat$(&H4000,chr$(0)) 'return data here


'Start of data structures ************************************************

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h)
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as shared urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as shared setuptype

type read_command  '31 byte
'first cbw fields  '15 byte
   signature      as dword
   tag            as dword
   tlength        as dword
   flags          as byte
   cbwlun         as byte
   clength        as byte
'now command fields '16 byte
   operation_code as byte
   lun            as byte
   lbahi          as word 'bytes 2+3 (zero based)
   lbalo          as word 'bytes 4+5 (zero based)
   reserved       as byte
   blocks         as word
   controls       as byte
   padding1       as word
   padding2       as word
   padding3       as word
end type

dim read_command_request as shared read_command


type inquiry_command  '31 byte
'first cbw fields  '15 byte
   signature      as dword
   tag            as dword
   tlength        as dword
   flags          as byte
   cbwlun         as byte
   clength        as byte
'now command fields '16 byte
   operation_code as byte
   lun            as byte
   lba            as dword
   reserved       as byte
   blocks         as word
   controls       as byte
   padding1       as word
   padding2       as word
   padding3       as word
end type

dim inquiry_command_request as shared inquiry_command

type device_descriptor_type
   bLength		as byte
   bDescriptorType	as byte
   bcdUSB		as word
   bDeviceClass		as byte
   bDeviceSubClass	as byte
   bDeviceProtocol	as byte
   bMaxPacketSize	as byte
   idVendor		as word
   idProduct		as word
   bcdDevice		as word
   iManufacturer	as byte
   iProduct		as byte
   iSerialNumber	as byte
   bNumConfigurations	as byte
end type

dim device_descriptor_ptr as shared device_descriptor_type ptr

'End of data structures ************************************************

'********************************************************************
function build_run_urb(token%,da%,ep%,bl%,al%,sbo%,sbs%) shared public
'
'sets up an URB and calls int 65h to run the transaction
'
'input: transaction_token(token%), device address(da%), endpoint(ep%),
'       buffer_length(bl%), actual_length(al%),setup_buffer_offset(sbo%),
'       setup_buffer_segment(sbs%)
'
'output: global variable usb_buffer filled
'
'
  if da%=0 then exit function 'invalid

  urb.transaction_token=token%
  urb.chain_end_flag=0
  urb.dev_add=da%
  urb.end_point=ep%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(usb_buffer)
  urb.buffer_seg=varseg(usb_buffer)
  urb.buffer_length=bl%
  urb.actual_length=al%
  urb.setup_buffer_off=sbo%
  urb.setup_buffer_seg=sbs%
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

end function
'********************************************************************
function build_cbw (tl%,fl%,lun%,cl%,oc%,byval lbanr???,blcks%) shared public
'
'sets up a CBW for the bulk-only protocol used with mass storage devices
'
'input: tlength(tl%), flags(fl%), clength(cl%), operation code(oc%),
'       lba number(lbanr%),blocks(blcks%),
'
'output: CBW written into global variable usb_buffer 
'
'
read_command_request.signature=&H43425355
read_command_request.tag=&H82A36008
read_command_request.tlength=tl%
read_command_request.flags=fl%
read_command_request.cbwlun=lun%
read_command_request.clength=cl%
'now command fields
read_command_request.operation_code=oc%
read_command_request.lun=lun%
'convert lbanumber??? to big endian
lbanumberlo??=lbanr??? AND &H0000FFFF
rotate right lbanumberlo??,8
shift right lbanr???,16
lbanumberhi??=lbanr???
rotate right lbanumberhi??,8
read_command_request.lbalo=lbanumberlo?? '0
read_command_request.lbahi=lbanumberhi?? '0
'print "LBAhi:" hex$(read_command_request.lbahi) " ";
'print "LBAlo:" hex$(read_command_request.lbalo) " ";
read_command_request.reserved=0
read_command_request.blocks=blcks% 'big endian
rotate right read_command_request.blocks,8
'print "Blocks:" hex$(read_command_request.blocks)
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

mid$(usb_buffer,1,64)=read_command_request

end function
'********************************************************************
function get_maxpaketsize(da%,seg controller%,seg speed%,seg maxpaketlen_ctrl%,seg maxpaketlen_bulk%)
'
'checks whether EHCI is used for the device address da% and then retrieves
'the device_descriptor to read the paket lenght for control transactions
'the paket length for bulk transactions is set whether ehci is used or not
'
'input: device address(da%), maxpaketlength for ctrl pakets(maxpaketlen_ctrl%),
'       maxpaketlength for bulk pakets(maxpaketlen_bulk%)
'
'output: maxpaketlen_ctrl% and maxpaketlen_bulk% filled
'
'

'first check for ehci
reg 1,7 'set ax to 7
build_run_urb &HFF,da%,0,0,0,0,0

controller%=urb.transaction_token 'ascii code of E,O or U
speed%=urb.next_urb_off           'H,F or L speed

if controller%=0 then exit function 'illegal device address

if controller%=&H45 then 'ehci
        maxpaketlen_ctrl%=64  'fixed for 2.0
        maxpaketlen_bulk%=512 'fixed for 2.0
else
        maxpaketlen_ctrl%=8  'try with lowest possible value for 1.1
        maxpaketlen_bulk%=64 'fixed for 1.1
end if

'request 8 byte device descriptor to get maxpaketlen_ctrl%
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0100
device_request.wIndex=0
device_request.wLength=8

build_run_urb &H2D,da%,0,8,maxpaketlen_ctrl%,varptr(device_request),varseg(device_request)
'build_run_urb(token%,da%,ep%,bl%,al%,sbo%,sbs%)

'let the device_descriptor_type structure point to the usb_buffer
device_descriptor_ptr = varptr32(usb_buffer)

maxpaketlen_ctrl%=@device_descriptor_ptr.bMaxPacketSize 'for 2.0 and 1.1

end function
'********************************************************************
