' This file has no copyright assigned and is placed in the Public Domain
' This sample prints "Printed by DOSUSB" on an Epson LQ-590 matrix printer.
' There are some ESC/P control codes before and after the text output.
'
defint a-z

dev_add%=1
in_endpoint%=2
out_endpoint%=1

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte  'does another urb follow this urb in memory?
                           'zero=no,one=yes
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by DOSUSB
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long
dim urb as urbtype

dim buffer  as string*1024
buffer=repeat$(1024,chr$(0))

'Initialize printer
b$=chr$(27)+"@"+chr$(13)+chr$(10)
'Select printer
b$=b$+chr$(27)+chr$(17)+chr$(13)+chr$(10)
'Select NLQ mode
b$=b$+chr$(27)+"x1"+chr$(13)+chr$(10)
'Select US character set
b$=b$+chr$(27)+"R0"+chr$(13)+chr$(10)
'Select normal character set
b$=b$+chr$(27)+"%"+chr$(0)+chr$(13)+chr$(10)

b$=b$+"Printed by DOSUSB"+chr$(&H0C)

'Initialize printer
b$=b$+chr$(27)+"@"+chr$(13)+chr$(10)

mid$(buffer,16)=b$ 'send some Null chars to flush buffer
packetlen%=1024    'terminate with Null chars
gosub do_out

end

do_out:  'public subroutine

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=dev_add%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=packetlen%
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DOSUSB
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

return
