defint a-z

' This file has no copyright assigned and is placed in the Public Domain

$include "pbdosusb.inc"

print
print "Device addresses assigned by DOSUSB"
print

for devadd%=1 to 198

maxpaketlen_ctrl%=8 'start with that

get_maxpaketsize devadd%,controller%,speed%,maxpaketlen_ctrl%,maxpaketlen_bulk%
'get_maxpaketsize(da%,controller%,speed%,maxpaketlen_ctrl%,maxpaketlen_bulk%)

if controller%=0 then goto do_end 'last device

'request full device descriptor
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0100
device_request.wIndex=0
device_request.wLength=&H12 '18 'hex 12

build_run_urb &H2D,devadd%,0,18,maxpaketlen_ctrl%,varptr(device_request),varseg(device_request)
'build_run_urb(token%,da%,ep%,bl%,al%,sbo%,sbs%)

'invalid device address?
if urb.error_code=1 then
        locate 14,23
	print "Invalid device address"
        locate 24,23
        input "Press enter to continue", a$
        goto do_end
end if

'transaction error?
if urb.status >1 then
        locate 14,23
	print "Device does not respond"
        locate 24,23
        input "Press enter to continue", a$
        goto do_end
end if

'let the device_descriptor_type structure point to the inbuffer
device_descriptor_ptr = varptr32(usb_buffer)

'retrieve string(product) descriptors

print "Device address: " devadd% "   ";

if @device_descriptor_ptr.iProduct > 0 then
   'get string descriptor
   device_request.bmRequestType=&H80
   device_request.bRequest=&H06
   device_request.wValue=&H0300 + @device_descriptor_ptr.iProduct
   device_request.wIndex=&H0409
   device_request.wLength=&HDF

'   build_run_urb &H2D,devadd%,0,&HDF,maxpaketlen_ctrl%,varptr(device_request),varseg(device_request)
   build_run_urb &H2D,devadd%,0,64,maxpaketlen_ctrl%,varptr(device_request),varseg(device_request)
   print "Product: ";
   a%=ascii(mid$(usb_buffer,1,1)) 'get length in bytes
   usb_buffer=mid$(usb_buffer,3,a%-2) 'skip length bytes and cut off excess
   usb_buffer=remove$(usb_buffer,chr$(0)) 'unicode -> ascii conversion
   print mid$(usb_buffer,1,(a%-2)/2) 'divide by 2 since unicode chars
end if

next devadd%

do_end:

end

