'this sample makes just one call to DOSUSB to read out the whole
'device descriptor and displays it on the screen.
'enums stands for short enumeration sample
'
defint a-z

devadd%=1 'set as needed

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved - int
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

dim inbuffer as string*1024
inbuffer=repeat$(1024,chr$(0)) 'return data here

'request full device descriptor
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0100
device_request.wIndex=0
device_request.wLength=&H12 '18 'hex 12

'set up device descriptor request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer)
  urb.buffer_off=varptr(inbuffer)
  urb.buffer_length=18
  urb.actual_length=64
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call DosUSB
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        locate 14,23
	print "Invalid device address"
        locate 24,23
        input "Press enter to continue", a$
        goto do_end
end if

'transaction error?
if urb.status >1 then
        locate 14,23
	print "Device does not respond"
        locate 24,23
        input "Press enter to continue", a$
        goto do_end
end if

'the device descriptor is read into the inbuffer string variable now
'print : print left$(inbuffer,18) : print 'for test

'*********************************************************************
'now display the data read by calling DOSUSB on the screen
'*********************************************************************

type device_descriptor_type
   bLength		as byte
   bDescriptorType	as byte
   bcdUSB		as word
   bDeviceClass		as byte
   bDeviceSubClass	as byte
   bDeviceProtocol	as byte
   bMaxPacketSize	as byte
   idVendor		as word
   idProduct		as word
   bcdDevice		as word
   iManufacturer	as byte
   iProduct		as byte
   iSerialNumber	as byte
   bNumConfigurations	as byte
end type

dim device_descriptor_ptr as device_descriptor_type ptr

'let the device_descriptor_type structure point to the inbuffer
device_descriptor_ptr = varptr32(inbuffer)

cls
print
print "Device Descriptor:"
print "Length:                " @device_descriptor_ptr.bLength
print "Descriptor type:       " @device_descriptor_ptr.bDescriptorType
print "USB specification nr.: " @device_descriptor_ptr.bcdUSB
print "Class code:            " @device_descriptor_ptr.bDeviceClass;
if @device_descriptor_ptr.bDeviceClass=0 then
 print "Class code specified by interface"
elseif @device_descriptor_ptr.bDeviceClass=1 then
 print "Audio device"
elseif @device_descriptor_ptr.bDeviceClass=2 then
 print "Modem device"
elseif @device_descriptor_ptr.bDeviceClass=3 then
 print "Human interface device - mouse, keyboard, etc."
elseif @device_descriptor_ptr.bDeviceClass=6 then
 print "Scanner / imaging device"
elseif @device_descriptor_ptr.bDeviceClass=7 then
 print "Printer"
elseif @device_descriptor_ptr.bDeviceClass=8 then
 print "Mass storage device"
elseif @device_descriptor_ptr.bDeviceClass=9 then
 print "Hub"
elseif @device_descriptor_ptr.bDeviceClass=&H0B then
 print "Chip/smart card interface device"
elseif @device_descriptor_ptr.bDeviceClass=&H0E then
 print "Video device"
elseif @device_descriptor_ptr.bDeviceClass=&HE0 then
 print "Bluetooth"
elseif @device_descriptor_ptr.bDeviceClass=255 then
 print "Vendor specified class code"
else
 print
end if
print "Subclass code:         " @device_descriptor_ptr.bDeviceSubClass
print "Protocol code:         " @device_descriptor_ptr.bDeviceProtocol
print "Max Packet size:       " @device_descriptor_ptr.bMaxPacketSize
print "Vendor ID:             " @device_descriptor_ptr.idVendor
print "Product ID:            " @device_descriptor_ptr.idProduct
print "Device release nr.:    " @device_descriptor_ptr.bcdDevice
print "Index of manufacturer: " @device_descriptor_ptr.iManufacturer
print "Index of product:      " @device_descriptor_ptr.iProduct
print "Index of serial nr.:   " @device_descriptor_ptr.iSerialNumber
print "Nr. of configurations: " @device_descriptor_ptr.bNumConfigurations

do_end:

end
