'This sample reads a sector of a USB memory stick using
'the bulk only protocol.

defint a-z

$include "pbdosusb.inc"

dim sbuffer as string*512
sbuffer=repeat$(512,chr$(0)) 'return data here

TYPE BPBRec
    Jmp                         AS STRING * 3
    OEM  			AS STRING * 8
    SectorSize                  AS WORD
    SectorsPerCluster           AS BYTE
    ReservedSectors		AS WORD
    FATs			AS BYTE
    Directoryentries		AS WORD
    Sectors			AS WORD
    Media			AS BYTE
    SectorsPerFAT               AS WORD
    SectorsPerTrack		AS WORD
    Heads			AS WORD
    HiddenSectors		AS DWORD
    TotalSectors		AS DWORD
    DriveNr                     AS BYTE
    Reserved			AS BYTE
    Ext 			AS BYTE
    Serial			AS DWORD
    VLabel			AS STRING * 11
    FileSys			AS STRING * 8
    GAPto32                     AS WORD
    DriveNr32                   AS BYTE
    Reserved32			AS BYTE
    Ext32 			AS BYTE
    Serial32			AS DWORD
    VLabel32			AS STRING * 11
    FileSys32			AS STRING * 8
'    Bootcode                    AS STRING * 451
END TYPE

Union bootunion
bootsector as BPBRec
bootsector_asciiz as asciiz * 90
End Union

dim bpb as shared bootunion

'check for ehci
maxpacketlen=64 'default
reg 1,7 'set ax to 7
build_run_urb &HFF,1,0,0,0,0,0
if urb.transaction_token=69 then maxpacketlen=512

color 15,1 : cls
if maxpacketlen=512 then locate 25,76 : print "EHCI"
locate 12,20 : input "Please enter device address: ", devadd%
locate 14,20 : print "Use USBVIEW to determine these endpoints:"
locate 16,20 : input "Please enter bulk IN  endpoint : ", in_endpoint%
locate 18,20 : input "Please enter bulk OUT endpoint: ", out_endpoint%

do_it_again:

cls

print "Note: Diskspy reads the physical sector number disregarding partitions"
input "Please enter sector number (enter for 0):", lbanumber$
if lbanumber$="" then
	lbanumber???=0
else
	lbanumber???=val(ltrim$(lbanumber$))
end if

do_it_again_2:

'gosub get_max_lun

gosub do_inquiry

gosub do_request_sense

gosub test_unit_ready

gosub do_read

bpb.bootsector_asciiz = mid$(sbuffer$,1,90) 'fill bpb.bootsector

for i=1 to 256 '512
print hex$(ascii(mid$(sbuffer,i,1))) " ";
if i mod 16 = 0 then print
next i

if urb.error_code >1 then '1=nyet
	print "Error:" urb.error_code
        end
end if

'now output the data read *******************************

cls
print
print "Sector "+str$(lbanumber???)+": "
print "      0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F"

for k=0 to 31
a$="000"+ltrim$(hex$(k))+"0 "
if len(a$)=7 then a$=mid$(a$,2)
print a$;
for i=1 to 16
	position%=k*16+i
	a$=ltrim$(hex$(ascii(mid$(sbuffer,position%,1))) )
        if len(a$)=1 then a$="0"+a$
        print a$ " " ;
next i
print mid$(sbuffer,k*16+1,16)
if k=21 then print "Press any key to continue.."; : junk$=input$(1) : print
next k

if lbanumber???=0 then
        gosub printmbr
end if

usb_buffer=repeat$(maxpacketlen,chr$(0)) 'return data here

reenter:
input "Please enter p or n for prev/next sector, s to enter sector nr, q to quit: ", a$
if a$="" then goto reenter
if ucase$(a$)="Q" then end
if ucase$(a$)="S" then goto do_it_again 'query sector number again
if ucase$(a$)="P" then
        cls
	if lbanumber???>0 then lbanumber???=lbanumber???-1
	goto do_it_again_2
end if
if ucase$(a$)="N" then
	cls
	lbanumber???=lbanumber???+1
	goto do_it_again_2
end if

'input ; "Read another sector Y/N" a$
'if ucase$(a$)="Y" then goto do_it_again

end

'**********************************************************
'subroutines
'**********************************************************
do_read:  'needs lbanumber???

'set up bulk read command incl. cbw
if maxpacketlen=512 then
	build_cbw &H200,&H80,0,&H0C,&H28,lbanumber???,&H01
else
	build_cbw &H200,&H80,0,&H0C,&H28,lbanumber???,&H08
	'build_cbw (tl%,fl%,lun%,cl%,oc%,lbanr???,blcks%)
end if

'set up out request
build_run_urb &HE1,devadd%,out_endpoint%,31,maxpacketlen,0,0

'has device changed?
if urb.error_code=5 then
	print "Device has been removed"
        end
end if

usb_buffer=repeat$(maxpacketlen,chr$(0)) 'return data here

if maxpacketlen=512 then
	build_run_urb &H69,devadd%,in_endpoint%,maxpacketlen,maxpacketlen,0,0
        mid$(sbuffer,1,512)=usb_buffer
else

	i=0
	while i<8 'leave if 8 ( 8*64=512 )

	'set up in request
	build_run_urb &H69,devadd%,in_endpoint%,64,64,0,0

	if urb.status=0 then
		incr i
        	midpos=1+(i-1)*64
                mid$(sbuffer,midpos)=usb_buffer
	elseif urb.status<>&H88 then
		exit loop 'do not incr if 88
	end if
wend

end if

'read CSW
build_run_urb &H69,devadd%,in_endpoint%,13,maxpacketlen,0,0

return
'********************************************************************
get_max_lun:

'get max lun
device_request.bmRequestType=&HA1
device_request.bRequest=&HFE
device_request.wValue=&H0000
device_request.wIndex=&H0000
device_request.wLength=&H0001

build_run_urb &H2D,devadd%,0,1,8,varptr(device_request),varseg(device_request)
'build_run_urb(token%,da%,ep%,bl%,al%,sbo%,sbs%)

'invalid device address?
if urb.error_code=1 then
	print "Invalid device address"
        end
end if

'has device changed?
if urb.error_code=5 then
	print "Device has been removed"
        end
end if

'has device changed?
if urb.error_code>1 then
	print "Error " urb.error_code
        end
end if

'transaction error?
if urb.status >1 then
	print "Device does not respond"
        end
end if

'print
'print "Logical units:" left$(usb_buffer,urb.actual_length)

return
'********************************************************************
do_inquiry:

'set up inquiry command incl. cbw
build_cbw &H24,&H80,0,&H0C,&H12,&H2400,0
'build_cbw (tl%,fl%,lun%,cl%,oc%,lbanr???,blcks%)

'set up out request
build_run_urb &HE1,devadd%,out_endpoint%,31,31,0,0

'transaction error?
if urb.status >1 then print "URB Status 1: " hex$(urb.status)

usb_buffer=repeat$(maxpacketlen,chr$(0)) 'return data here

'set up in request
build_run_urb &H69,devadd%,in_endpoint%,36,maxpacketlen,0,0

'transaction error?
if urb.status >1 then print "URB Status 2: " hex$(urb.status)

'print
'print "Inquiry:" left$(usb_buffer,urb.actual_length)

'set up in request - to read CSW
build_run_urb &H69,devadd%,in_endpoint%,13,maxpacketlen,0,0

'transaction error?
if urb.status >1 then print "URB Status 3: " hex$(urb.status)

'print
'print "CSW:" left$(usb_buffer,urb.actual_length)

return
'********************************************************************
do_request_sense:

'set up request sense command incl. cbw
build_cbw &H12,&H80,0,&H0C,&H03,&H1200,0
'build_cbw (tl%,fl%,lun%,cl%,oc%,lbanr???,blcks%)

build_run_urb &HE1,devadd%,out_endpoint%,31,31,0,0

usb_buffer=repeat$(maxpacketlen,chr$(0)) 'return data here

build_run_urb &H69,devadd%,in_endpoint%,maxpacketlen,maxpacketlen,0,0

'print
'print "Request sense:" left$(usb_buffer,urb.actual_length)

'set up in request - to read CSW
build_run_urb &H69,devadd%,in_endpoint%,maxpacketlen,maxpacketlen,0,0

'print
'print "CSW:" left$(usb_buffer,urb.actual_length)

return
'********************************************************************
test_unit_ready:

'set up test unit ready command incl. cbw
build_cbw 0,0,0,&H0C,0,0,0
'build_cbw (tl%,fl%,lun%,cl%,oc%,lbanr???,blcks%)

build_run_urb &HE1,devadd%,out_endpoint%,31,31,0,0

'usb_buffer=repeat$(64,chr$(0)) 'return data here
'build_run_urb(&H69,devadd%,in_endpoint%,64,64,0,0)

'read CSW
build_run_urb &H69,devadd%,in_endpoint%,maxpacketlen,maxpacketlen,0,0

'print
'print "CSW:" left$(usb_buffer,urb.actual_length)

return
'********************************************************************
printmbr:

if left$(bpb.bootsector.FileSys32,3)="FAT" then

print "Press any key to continue.."; : junk$=input$(1) : print
print : print
print : print "Sector Size: " bpb.bootsector.SectorSize, "Sectors per Cluster: " bpb.bootsector.SectorsPerCluster
print : print "Reserved Sectors: " bpb.bootsector.ReservedSectors, "Nr. of FATs: " bpb.bootsector.FATs
print : print "Directory Entries: " bpb.bootsector.Directoryentries, "Sectors: " bpb.bootsector.Sectors
print : print "Media: " hex$(bpb.bootsector.Media) " hex",, "Sectors per FAT: " bpb.bootsector.SectorsPerFAT
print : print "Sectors per Track: " bpb.bootsector.SectorsPerTrack, "Heads: " bpb.bootsector.Heads
print : print "Hidden Sectors: " bpb.bootsector.HiddenSectors, "Total Sectors: " bpb.bootsector.TotalSectors
if left$(bpb.bootsector.FileSys32,5)="FAT32" then
print : print "DriveNr: " bpb.bootsector.DriveNr32,, "Ext: " hex$(bpb.bootsector.Ext32) " hex"
print : print "Serial: " hex$(bpb.bootsector.Serial32) " hex", "VLabel : " bpb.bootsector.VLabel32
print : print "FileSys: " bpb.bootsector.FileSys32
else 'FAT12/16
print : print "DriveNr: " bpb.bootsector.DriveNr,, "Ext: " hex$(bpb.bootsector.Ext) " hex"
print : print "Serial: " hex$(bpb.bootsector.Serial) " hex", "VLabel : " bpb.bootsector.VLabel
print : print "FileSys: " bpb.bootsector.FileSys
end if
print
print "Press any key to continue.."; : junk$=input$(1) : print
end if 'left$ FAT
return
'********************************************************************
pressany:
        print "Press any key to continue.."; : junk$=input$(1) : print
return