;this version queries the printer status before executing the output
;command from DOS.
;it will not report, if paper empty while executing the command,
;the printer will send NAKs and this driver will wait for the
;situation to be cleared by the user - who probably is interested
;whether his print is done
;
;change lines 153/154 to print to "PRNUSB" or "LPT1"
;
;****************************************************************
;*    This is a Printer Device Driver for the DOSUSB driver    *
;*                                                              *
;*    Compile: tasm prnusb.asm                                  *
;*    Link:    tlink prnusb.obj /t,prnusb.sys                   *
;****************************************************************

     cseg	segment   para public    'code'
     org 0000h

;showflag equ 1
showflag equ 0

     printer	proc      far
		assume    cs:cseg, es:cseg, ds:cseg

;structures ****************************************************

rh		struc		;request header 
rh_len		db	?	;len of packet
rh_unit		db	?     	;unit code 
				;(block devices only)
rh_cmd		db	?     	;device driver command
rh_status	dw	?     	;returned by device driver 
rh_res1		dd	?     	;reserved
rh_res2		dd	?     	;reserved
rh		ends	      	;

rh0		struc		;Initialization (command 0)
rh0_rh		db	size rh dup (?)	;fixed portion
rh0_nunits	db	?     	;number of units 
				;(block devices only)
rh0_brk_ofs	dw	?     	;offset address for break
rh0_brk_seg	dw	?     	;segment address for break
rh0_bpb_tbo	dw	?     	;offset address of pointer
				;to BPB array
rh0_bpb_tbs	dw	?     	;segment address of pointer 
				;to BPB array
rh0_drv_ltr	db	?     	;first available drive 
				;(DOS 3+) (block only)
rh0		ends	      	;

rh3		struc		;IOCTL_INPUT (command 3)
rh3_rh		db	size rh dup(?)	;fixed portion
rh3_media	db	?     	;media descriptor from DPB
rh3_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh3_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh3_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh3_start	dw	?     	;start sector number 
				;(block only)
rh3		ends	      	;

rh8		struc		;OUTPUT (command 8)
rh8_rh		db	size rh dup(?)	;fixed portion
rh8_media	db	?     	;media descriptor from DPB
rh8_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh8_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh8_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh8_start	dw	?     	;start sector number 
				;(block only)
rh8		ends	      	;

rh9		struc		;OUTPUT_VERIFY (command 9)
rh9_rh		db	size rh dup(?)	;fixed portion
rh9_media	db	?     	;media descriptor from DPB
rh9_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh9_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh9_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh9_start	dw	?     	;start sector number (block only)
rh9		ends	      	;

rh10		struc		;Output_Status (command 10)
rh10_len	db	?     	;len of packet
rh10_unit	db	?     	;unit code 
				;(block devices only)
rh10_cmd	db	?     	;device driver command
rh10_status	dw	?     	;returned by device driver 
rh10_res1	dd	?     	;reserved
rh10_res2	dd	?     	;reserved
rh10		ends	      	;

rh12		struc		;IOCTL_OUTPUT (command 12)
rh12_rh		db	size rh dup(?)	;fixed portion
rh12_media	db	?     	;media descriptor from DPB
rh12_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh12_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh12_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh12_start	dw	?     	;start sector number 
				;(block only)
rh12		ends	      	;

rh16		struc		;OUTPUT_BUSY (command 16)
rh16_rh		db	size rh dup (?)	;fixed portion
rh16_media	db	?     	;media descriptor
rh16_buf_ofs 	dw	?     	;offset address of 
				;data transfer area
rh16_buf_seg 	dw	?     	;segment address of 
				;data transfer area
rh16_count	dw	?     	;byte count returned 
				;from device driver
rh16		ends	      	;

;commands that do not have unique portions to the request header:
;	INPUT_STATUS 	(command 6)
;	INPUT_FLUSH	(command 7)
;	OUTPUT_STATUS	(command 10)
;	OUTPUT_FLUSH	(command 11)
;	OPEN		(command 13)
;	CLOSE		(command 14)
;	REMOVEABLE	(command 15)
;	 


;****************************************************************
;*      MAIN PROCEDURE CODE                                     *
;****************************************************************

     begin:

;****************************************************************
;*      DEVICE HEADER REQUIRED BY DOS                           *
;****************************************************************

next_dev       dd   -1             ;no other drivers following
attribute      dw   08000h         ;char
strategy       dw   dev_strategy   ;Strategy routine address
interrupt      dw   dev_interrupt  ;Interrupt routine address
;dev_name       db   'PRNUSB  '     ;name of our Printer driver
dev_name       db   'LPT1    '     ;name of our Printer driver

;****************************************************************
;*      WORK SPACE FOR OUR DEVICE DRIVER                        *
;****************************************************************

rh_ofs	dw   	?    	;offset address of the request header
rh_seg	dw   	?	;segment address of the request header

devicenr   db 1
endpointnr db 2

bytes_to_print   dw 0
bytes_done       dw 0

retry_count dw 0

showptr    dw 0

;define data type of URB
urbstruc struc
  transaction_token db ? ;control, in, out 
  chain_end_flag  db ?  
  dev_add         db ?
  end_point       db ?
  error_code      db ?  ;error codes returned by DOSUSB
  status          db ?  ;status byte returned by controller
  transaction_flags dw ?  ;reserved
  buffer_off      dw ?  ;for in/out
  buffer_seg      dw ?  ;for in/out
  buffer_length   dw ?  ;for in/out
  actual_length   dw ?  ;for in/out
  setup_buffer_off dw ? ;for control
  setup_buffer_seg dw ? ;for control
  start_frame     dw ?  ;reserved 
  nr_of_packets   dw ?  ;iso
  int_interval    db ?  ;int
  error_count     db ?  ;reserved 
  timeout         dw ?  ;reserved
  next_urb_off    dw ?  ;reserved
  next_urb_seg    dw ?  ;reserved
urbstruc ends ;32 byte long 

;define urb with this type
urb     urbstruc <> 

class_req   db  0A1h,01h 
            dw  0000h,0000h,0001h

temp_buffer db  8 dup(0)

prtstatus db 0

maxpacketsize_ctrl dw 8  ;64 for ehci
maxpacketsize_bulk dw 64 ;512 for ehci
ehci_flag db 0

;****************************************************************
;*      THE STRATEGY PROCEDURE                                  *
;****************************************************************

dev_strategy:  mov  cs:rh_seg,es   ;save the segment address
               mov  cs:rh_ofs,bx   ;save the offset address
               ret                 ;return to DOS

;****************************************************************
;*      THE INTERRUPT PROCEDURE                                 *
;****************************************************************

;device interrupt handler - 2nd call from DOS

dev_interrupt:

        pushf                   ;save machine state on entry
        push    ds
        push    es
        push    ax
        push    bx
        push    cx
        push    dx
        push    di
        push    si

        cld
        
        mov     ax,cs:rh_seg    ;restore ES as saved by STRATEGY call
        mov     es,ax           ;
        mov     bx,cs:rh_ofs    ;restore BX as saved by STRATEGY call

;jump to appropriate routine to process command

        mov     al,es:[bx].rh_cmd       ;get request header header command

if showflag
	mov cl,al
        call show ;show commands sent by DOS
endif



        ;rol     al,1                    ;times 2 for index into word table
        shl     al,1                    ;times 2 for index into word table
        lea     di,cmdtab               ;function (command) table address
        mov     ah,0                    ;clear hi order
        add     di,ax                   ;add the index to start of table
        jmp     word ptr[di]            ;jump indirect

;CMDTAB is the command table that contains the word address
;for each command. The request header will contain the
;command desired. The INTERRUPT routine will jump through an
;address corresponding to the requested command to get to
;the appropriate command processing routine.

CMDTAB  label   byte            ;* = char devices only
        dw      INITIALIZATION  ; initialization
        dw      done            ; media check (block only)
        dw      done            ; build bpb
        dw      done            ; ioctl in
        dw      done            ; input (read)
        dw      done            ;*non destructive input no wait
        dw      done            ;*input status
        dw      done            ;*input flush
        dw      OUTPUT          ; output (write)
        dw      OUTPUT          ; output (write) with verify
        dw      done            ;*output status
        dw      done            ;*output flush
        dw      done            ; ioctl output
        dw      done            ; device open
        dw      done            ; device close
        dw      done            ; removeable media
        dw      OUTPUT          ; output til busy

;****************************************************************
;*      YOUR LOCAL PROCEDURES                                   *
;****************************************************************
do_out proc near

mov bytes_done,0
mov retry_count,0

repeat_out:
mov ax,es:[bx].rh8_count ;load output count
cmp ax,bytes_done ;all done?
ja not_all_done
mov cs:urb.status,0
ret  ;exit function

not_all_done:
sub ax,bytes_done       ;how many left?
mov bytes_to_print,ax   ;bytes_to_print
cmp ax,maxpacketsize_bulk
jbe bytes_ok            ;less or equal the max
mov ax,maxpacketsize_bulk
mov bytes_to_print,ax   ;max packet size for bulk

bytes_ok:               ;also retry label!

;set up URB for out transaction
mov urb.transaction_token,0E1h
mov urb.chain_end_flag,0
mov al,devicenr
mov urb.dev_add,al
mov al,endpointnr
mov urb.end_point,al
mov urb.error_code,0
mov urb.status,0
mov urb.transaction_flags,0
mov ax,es:[bx].rh8_buf_ofs  ;load offset address
add ax,bytes_done           ;start at this offset if 64 max
mov urb.buffer_off,ax
mov ax,es:[bx].rh8_buf_seg  ;load segment address
mov urb.buffer_seg,ax
;mov ax,es:[bx].rh8_count ;load output count
mov ax,bytes_to_print
mov urb.buffer_length,ax
mov ax,maxpacketsize_bulk
mov urb.actual_length,ax
mov urb.setup_buffer_off,0
mov urb.setup_buffer_seg,0
mov urb.start_frame,0
mov urb.nr_of_packets,0
mov urb.int_interval,0
mov urb.error_count,0
mov urb.timeout,0
mov urb.next_urb_off,0
mov urb.next_urb_seg,0

;now call DOSUSB
mov dx,offset urb
int 65h

;transaction successful?
inc retry_count        ;always inc error counter
cmp retry_count,32000  ;allow for 32000 NAK's 
jae error_out          ;yes, report error to DOS
cmp urb.status,0       ;transaction OK?
je  transaction_ok     ;yes
cmp urb.status,88h     ;NAK?
jne error_out          ;no, different error - exit without retry
jmp bytes_ok           ;got NAK, retry

transaction_ok:
mov retry_count,0      ;reset error counter
mov ax,bytes_to_print
add bytes_done,ax     ;count how many done
jmp repeat_out

error_out:  ;if urb.status is <> 0, an error will be reported to DOS 
mov ax,800Ah  ;return write error

if 0 ;can't get DOS to handle these errors right 
xor ax,ax ;clear
mov bl,urb.status ;readstatus destroys urb.status
push bx
call readstatus ;find out if printer reports an error
pop bx
mov urb.status,bl ;restore - need in 8 command function

cmp ax,0
je test_for_done ;no error found
ret ;error found

test_for_done:
;no error, continue - forever!!!
mov retry_count,0
jmp bytes_ok

endif

ret

do_out endp

;***************************************************************
;query printer for errors
;returns status read in prtstatus and DOS-return word in AX reg
;set carry if status not read successfully

readstatus proc near
push es
push bx

mov cs:retry_count,0

repeat_get_status:
;set up URB for ctrl+in+out transaction
mov cs:urb.transaction_token,2Dh
mov cs:urb.chain_end_flag,0
mov al,cs:devicenr
mov cs:urb.dev_add,al
mov cs:urb.end_point,0 ;control e.p.
mov cs:urb.error_code,0
mov cs:urb.status,0
mov cs:urb.transaction_flags,0
mov ax,offset cs:temp_buffer ;load temp buffer offset address
mov cs:urb.buffer_off,ax
mov ax,cs                 ;load segment address
mov cs:urb.buffer_seg,ax
mov cs:urb.buffer_length,8
mov ax,maxpacketsize_ctrl
mov cs:urb.actual_length,ax
mov ax,offset cs:class_req 
mov cs:urb.setup_buffer_off,ax
mov ax,cs
mov cs:urb.setup_buffer_seg,ax
mov cs:urb.start_frame,0
mov cs:urb.nr_of_packets,0
mov cs:urb.int_interval,0
mov cs:urb.error_count,0
mov cs:urb.timeout,0
mov cs:urb.next_urb_off,0
mov cs:urb.next_urb_seg,0

;now call DOSUSB
push cs
pop ds
mov dx,offset cs:urb
int 65h

;read successful?
inc cs:retry_count        ;always inc error counter
cmp cs:retry_count,5      ;already four retries?
jae get_status_err
cmp cs:urb.status,0       ;transaction OK?
je  get_status_ok ;yes
cmp cs:urb.status,88h      ;NAK?
jne get_status_err ;no, different error - exit without retry
jmp repeat_get_status     ;got NAK, retry

get_status_ok:
mov al,byte ptr temp_buffer[0]
mov cs:prtstatus,al

if showflag
mov cl,31 ;"O"
call show
mov cl,al
call show
endif

xor ax,ax ;clear

test cs:prtstatus,00100000b ;paper empty bit
jz test_for_select ;jmp if bit in prtstatus NOT set
mov ax,8009h  ;paper empty
jmp prtstatus_check_done

test_for_select:
test cs:prtstatus,00010000b ;selected bit set = no error
jnz test_for_error ;jmp if bit in prtstatus IS set
mov ax,8002h  ;device not ready
jmp prtstatus_check_done

test_for_error:
test cs:prtstatus,00001000b ;is that bit set = no error! ?
jnz prtstatus_check_done ;jmp if bit in prtstatus IS set
mov ax,800Ah  ;write error

prtstatus_check_done:
clc
mov cs:retry_count,0
pop bx
pop es
ret

get_status_err:
xor ax,ax ;clear
stc
mov cs:retry_count,0
pop bx
pop es
ret

readstatus endp

;**********************************************************
do_check proc near
        ;check if interrupt 65h is set or uninitalized
        ;return dx=1 if installed
        xor dx,dx ;zero = default
        xor ax,ax
        mov es,ax ;set to zero
        mov bx,es:194h ;read offset into bx
        mov ax,es:196h ;read segment
        mov es,ax      ;segment in es
        mov     ax,es  ;test if 0:0 vector -> no driver
        or      ax,bx
        jz      not_loaded
        mov     ax,es:[bx]
        cmp     al,0CFh ;IRET?
        je      not_loaded
        mov dx,1 ;installed
not_loaded:

ret
do_check endp
;***************************************************************************
check_for_ehci proc near

mov cs:urb.transaction_token,0FFh
mov cs:urb.chain_end_flag,0
mov cs:urb.dev_add,1
mov cs:urb.end_point,0
mov cs:urb.error_code,0
mov cs:urb.status,0
mov cs:urb.transaction_flags,0
mov cs:urb.buffer_off,0
mov cs:urb.buffer_seg,0
mov cs:urb.buffer_length,0
mov cs:urb.actual_length,0
mov cs:urb.setup_buffer_off,0
mov cs:urb.setup_buffer_seg,0
mov cs:urb.start_frame,0
mov cs:urb.nr_of_packets,0
mov cs:urb.int_interval,0
mov cs:urb.error_count,0
mov cs:urb.timeout,0
mov cs:urb.next_urb_off,0
mov cs:urb.next_urb_seg,0

mov ax,7 ;set ax to 7 for ehci/ohci/uhci check

;now call DOSUSB
push cs
pop ds
mov dx,offset cs:urb
int 65h

cmp cs:urb.transaction_token,69
jne cfe_noehci
cmp cs:urb.next_urb_off,048h ;"H"?
jne cfe_noehci
mov cs:ehci_flag,1
mov cs:maxpacketsize_bulk,512
mov cs:maxpacketsize_ctrl,64
cfe_noehci:

ret
check_for_ehci endp
;***************************************************************************
read_commandline proc near
;determine length of command line first
        ;rh0_bpb_tbo     dw      ?       ;offset address of pointer
        ;rh0_bpb_tbs     dw      ?       ;segment address of pointer 
        cld
        push es
        mov di,es:[bx].rh0_bpb_tbo  ;position of command_string
        mov cx,es:[bx].rh0_bpb_tbs  ;segment
        mov es,cx
        mov al,0Dh  ;CR
        xor cx,cx
        mov cl,80   ;read 80 max
 repne  scasb
        pop es
        mov dx,di
        sub dx,es:[bx].rh0_bpb_tbo
        ;check if valid length read
        cmp dx,0
        ja chl0
        jmp read_commandline_done
chl0:
        cmp dx,80
        jb chl1
        jmp read_commandline_done
chl1:
        cld
        push es
        mov di,es:[bx].rh0_bpb_tbo  ;position of command_string
        mov cx,es:[bx].rh0_bpb_tbs  ;segment
        mov es,cx
        mov al,'/' 
        xor cx,cx
        mov cl,dl ;length in dx
 repne  scasb
        cmp cx,0 ;not found?
        jne nc0f ;jmp if found
        pop es   ;therefore no jcxz
        jmp nextcommand1  ;not found
nc0f:
        mov ax,es:[di] ;now read that byte
        and al,11011111b                        ;convert to upper case
        cmp al,45h ;E?
        jne nc0a
        mov ax,es:[di+1] ;read endpoint number
        sub ax,30h ;just one number max 9
        mov cs:endpointnr,al
        jmp nc0b
nc0a:
        cmp al,44h ;D?
        jne nc0b
        mov ax,es:[di+1] ;read device number
        sub ax,30h ;just one number max 9
        mov cs:devicenr,al
nc0b:
        pop es
        ;now test for next command
nextcommand1:
        cld
        push es
        ;leave di and continue there
        ;mov di,es:[bx].rh0_bpb_tbo  ;position of command_string
        mov cx,es:[bx].rh0_bpb_tbs  ;segment
        mov es,cx
        mov al,'/' 
        xor cx,cx
        mov cl,dl ;length 
 repne  scasb
        cmp cx,0 ;not found?
        jne nc1f ;jmp if found
        pop es   ;therefore no jcxz
        jmp nextcommand2  ;not found
nc1f:
        mov ax,es:[di] ;now read that byte
        cmp al,45h ;E?
        jne nc1a
        mov ax,es:[di+1] ;read endpoint number
        sub ax,30h ;just one number max 9
        mov cs:endpointnr,al
        jmp nc1b
nc1a:
        cmp al,44h ;D?
        jne nc1b
        mov ax,es:[di+1] ;read device number
        sub ax,30h ;just one number max 9
        mov cs:devicenr,al
nc1b:
        pop es
        ;now test for next command
nextcommand2:

;check if values read ok
cmp devicenr,0
ja dnext1      ;ok
mov devicenr,1 ;default
dnext1:
cmp devicenr,10
jb dnext2      ;ok
mov devicenr,1 ;default
dnext2:
cmp endpointnr,0
ja enext1        ;ok
mov endpointnr,2 ;default
enext1:
cmp endpointnr,10
jb enext2        ;ok
mov endpointnr,2 ;default
enext2:
read_commandline_done:

ret
read_commandline endp

;******************************************************
if showflag
show proc near ;show number in cl
	      ;pusha                 ; Register sichern
	      push  di
	      push  ax
	      push  es
	      push  cx
	      push  ax

	      push  0B800h          ; Video-Segment
	      pop   es              ; ES auf Video-RAM
	      mov   di, 450         ; StartOffset
	      xor   ch,ch           ; clear high byte
	      inc showptr
	      inc showptr
	      mov ax,showptr
	      add di,ax

	      cld
	      mov   ax, es:[di]     ; Farbe ermitteln
	      mov   al,cl           ; write number to show
	      add   al,48           ; convert to ascii
	      stosw                 ; write to es:di

	      pop   ax
	      pop   cx
	      pop   es
	      pop   ax
	      pop   di
	      ;popa
ret
show endp
endif
;****************************************************************
;*      DOS COMMAND PROCESSING                                  *
;****************************************************************

;command 0      Initialization  *********************************
Initialization:
        call    read_commandline
        call    initial                 ;display message
        lea     ax,initial              ;set Break Addr. at initial
        mov     es:[bx].rh0_brk_ofs,ax  ;store offset address
        mov     es:[bx].rh0_brk_seg,cs  ;store segment address
        jmp     done                    ;set done status and exit


;command 8      Output  *****************************************
Output:

	mov	cx,es:[bx].rh8_count	;load output count
        jcxz    out_done                ;no bytes to print - leave

        push    cs
        pop     ds   ;set ds to cs

;check if usb driver installed
        push es
        push bx
        call do_check
        ;call check_for_ehci ;fills maxpacketsize with 512 and ehci_flag,1
        pop bx
        pop es
        cmp dx,1 ;    urb.transaction_token,47h
        je check_ok
        mov     ax,800Ah                ;write error
        mov     cx,0 ;cs:bytes_done
        mov     es:[bx].rh8_count,cx    ;return output count 
	jmp	load_status		;load status & exit

check_ok:

        push es
        push bx
        call readstatus ;find out if printer reports an error first
        pop bx
        pop es
        cmp ax,0
        je out_continue
        ;ax is filled with error return code for DOS

        if showflag
        push es
        push bx
        mov cl,17 ;"A"
        call show
        mov cl,al
        call show
        pop bx
        pop es
        endif

        mov     es:[bx].rh8_count,0     ;return output count 0
        jmp	load_status		;load status & exit

out_continue:
        push    cs
        pop     ds   ;set ds to cs
        push es
        push bx
        call do_out ;now seg/off/bytes read from header in do_out proc
        pop bx
        pop es
        cmp cs:urb.status,0 ;ok?
        je out_done
        ;now return error
        ;ax is filled with error return code for DOS

        if showflag
        push es
        push bx
        mov cl,16 ;"@"
        call show
        mov cl,cs:urb.status
        call show
        pop bx
        pop es
        endif

        mov     cx,cs:bytes_done        ;have to return these
        mov     es:[bx].rh8_count,cx    ;return output count
        jmp	load_status		;load status & exit

out_done:  
        mov     ax,0                    ;no error
	jmp	load_status		;load status & exit

;****************************************************************
;*      ERROR EXIT                                              *
;****************************************************************

isunknown: 
	or	es:[bx].rh_status,8003h	;set error bit and error code
	jmp	done			;set done and exit

;****************************************************************
;*      COMMON EXIT                                             *
;****************************************************************
load_status:
	mov	cx,cs:rh_seg		;restore request header 
	mov	es,cx			; segment to es
	mov	cx,cs:rh_ofs		;restore offset also
	xchg	bx,cx			;switch them
        mov     es:[bx].rh_status,ax    ;return status, ax filled above
        ;mov     es:[bx].rh8_count,cx    ;return output count - leave it
	jmp	done			;set done bit and exit

done:   or      es:[bx].rh_status,0100h ;set done bit

	pop	si			;restore all registers
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
        popf
	ret				;return to DOS

;****************************************************************
;*      END OF PROGRAM                                          *
;****************************************************************

;this procedure is called from the Initialization command and
;is executed only once. We tell DOS that the next available
;memory location (Break Address) is here. This allows DOS to over
;write this code; we save space.

initial	proc	near	;display message on console
	lea	dx,msg1	;message to be displayed
	mov	ah,9	;display
	int	21h	;DOS call

        mov  ah,02          ;
        mov  dl,devicenr    ;
        add  dl,48          ;convert to ascii
        int  21h            ;

        lea     dx,msg2 ;message to be displayed
	mov	ah,9	;display
	int	21h	;DOS call

        mov  ah,02          ;
        mov  dl,endpointnr  ;
        add  dl,48          ;convert to ascii
        int  21h            ;

        lea     dx,crlf ;message to be displayed
	mov	ah,9	;display
	int	21h	;DOS call

	ret		;return to caller
initial	endp

msg1    db      0dh,0ah,"Printer device driver for DosUSB, Version 1.2",0dh,0ah
;        db      "Not supporting GDI or Windows printers!",0dh,0ah
        db      "Device number: $"
msg2    db      " Endpoint number: $"
crlf    db      0dh,0ah,"(can be set with /DX and /EX)",0dh,0ah,0ah,"$"

printer	endp		;end of printer procedure
cseg	ends		;end of cseg segment
	end	begin	;end of program

