
; "LISTDEVS.ASM" | FASM (R) code
; Compiles into "LISTDEVS.COM" | 2'047 Byte's
; (CL) 2010-03-24 by DOS386 | Abuse at your own risk !!!

; WARNING: This tool does one arguably exotic task very well !!!!!!!!!!!!!!!!

; http://board.flatassembler.net/topic.php?t=N/A
; http://dosusb.net

; ----------------------------------------------------------------------

define pope  pop
define popef popf

macro movntq mdst, msrc {
  if mdst eq cs
    err "CS is not a valid destination"
  end if
  if mdst in <ds,es,ss> & msrc in <cs,ds,es,ss>
    push  msrc
    pope  mdst
  else
    if mdst in <ax,bx,cx,dx,si,di,bp> & msrc eq 0
      xor  mdst, mdst
    else
      mov  mdst, msrc
    end if
  end if
} ; endmacro

macro cmpntq minp, mref {
  if minp in <bl,cl,dl,ah,bh,ch,dh,ax,bx,cx,dx,si,di,bp> & mref eq 0
    test minp, minp
  else
    cmp  minp, mref
  end if
} ; endmacro

; ----------------------------------------------------------------------

; What it is supposed to do:
; Checks for DOSUSB presence and lists devices enumerated by DOSUSB
; Properly implements the driver detection, can use any INT from $60 to $67
; Lists "only" 99 devices at most but this shouldn't ever be a REAL problem
; Does not provide full info (use "USBVIEW.EXE" for more), just the most
; important stuff, including HOT endpoint's
; Commandline: none
; Interactivity: none

; ----------------------------------------------------------------------

; System requirements for running:

; - FreeDOS 1.1, EDR-DOS 7.01.08, RxDOS 7.30 or compatible
; - At least 80386 CPU (not checked)
; - "DOSUSB" driver by Georg Potthast 2010-03-24 or newer (carefully checked)
; - 2 KiB of free HD space to hold the "LISTDEVS.COM" binary

; System requirements for compiling:

; - FreeDOS 1.1, EDR-DOS 7.01.08, RxDOS 7.30 or compatible
; - At least 80386 CPU
; - FASM 1.69.12 or better
; - Some MiB's free RAM

; ----------------------------------------------------------------------

; usb_buffer (1 KiB)

; Needed for all calls to DOSUSB

; urb {
;   transaction_token  UINT8  +  0 | Control:$2D In:$69 Out:$E1 AX:$FF
;   chain_end_flag     UINT8  +  1
;   dev_add            UINT8  +  2 | 1 to 198 ??? | ZERO is INVALID
;   end_point          UINT8  +  3
;   error_code         UINT8  +  4 | Returned by JDOSUSB
;   status             UINT8  +  5 | Returned by JDOSUSB
;   transaction_flags  UINT16 +  6 | Reserved
;   buffer_off         UINT16 +  8 | For in/out
;   buffer_seg         UINT16 + 10 | For in/out
;   buffer_length      UINT16 + 12 | For in/out
;   actual_length      UINT16 + 14 | For in/out
;   setup_buffer_off   UINT16 + 16 | For control
;   setup_buffer_seg   UINT16 + 18 | For control
;   start_frame        UINT16 + 20 | Reserved
;   nr_of_packets      UINT16 + 22 | ISO (strange)
;   int_interval       UINT8  + 24 | Reserved
;   error_count        UINT8  + 25 | Reserved
;   timeout            UINT16 + 26 | Reserved
;   next_urb_off       UINT16 + 28 | Return value: speeed "H" or "F" or "L"
;   next_urb_seg       UINT16 + 30 | Reserved
; } Total 32 Byte's size | 20 Entries

; Needed additionally for most calls to DOSUSB

; device_request {
;   bmRequestType  UINT8
;   bRequest       UINT8
;   wValue         UINT16
;   wIndex         UINT16
;   wLength        UINT16
; } Total 8 Byte's size | 5 Entries

; This is to evaluate "device_descriptor" in the output buffer

; device_descriptor {
;   bLength             UINT8  +  0
;   bDescriptorType     UINT8  +  1
;   bcdUSB              UINT16 +  2
;   bDeviceClass        UINT8  +  4 | Usually ZERO (by interface)
;   bDeviceSubClass     UINT8  +  5
;   bDeviceProtocol     UINT8  +  6
;   bMaxPacketSize      UINT8  +  7
;   idVendor            UINT16 +  8
;   idProduct           UINT16 + 10
;   bcdDevice           UINT16 + 12
;   iManufacturer       UINT8  + 14
;   iProduct            UINT8  + 15
;   iSerialNumber       UINT8  + 16
;   bNumConfigurations  UINT8  + 17
; } Total 18 Byte's size | 14 Entries

; This is to evaluate "configuration_descriptor" in the output buffer

; configuration_descriptor {
;   bLength             UINT8  + 0 | Subblock only, always 9 Byte's ???
;   bDescriptorType     UINT8  + 1
;   wTotalLength        UINT16 + 2 | Total block size to read
;   bNumInterfaces      UINT8  + 4 | Usually 1
;   bConfigurationValue UINT8  + 5
;   iConfiguration      UINT8  + 6
;   bmAttributes        UINT8  + 7
;   bMaxPower           UINT8  + 8
; } Total 9 Byte's size | 8 Entries

; This is to evaluate "interface_descriptor" in the output buffer

; interface_descriptor {
;   bLength             UINT8 + 0
;   bDescriptorType     UINT8 + 1 | Always 4 ???
;   bInterfaceNumber    UINT8
;   bAlternateSetting   UINT8
;   bNumEndpoints       UINT8 + 4 | Usually 3 ???
;   bInterfaceClass     UINT8 + 5 | !!! Here !!!
;   bInterfaceSubClass  UINT8
;   bInterfaceProtocol  UINT8
;   iInterface          UINT8 + 8 | Index to specific text, usually ZERO
; } Total 9 Byte's size | 9 Entries

; This is to evaluate "endpoint_descriptor" in the output buffer

; endpoint_descriptor {
;   bLength             UINT8  + 0 | Usually 7
;   bDescriptorType     UINT8  + 1 | Usually 5 | $21 is invalid ???
;   bEndpointAddress    UINT8  + 2
;   bmAttributes        UINT8  + 3 | Lowest 3 bits are interesting
;   wMaxPacketSize      UINT16 + 4
;   bInterval           UINT8  + 6
; } Total 7 Byte's size | 6 Entries

; ----------------------------------------------------------------------

  bbbigbuff equ $1000       ; Size $0400
  bbmagic0  equ $1400       ; UINT16 = $ABCF padded to UINT32

  bburb     equ $1404       ; Size $20
  bbrequest equ $1424       ; Size 8
  bbmagic1  equ $142C       ; UINT16 = $9732 padded to UINT32

  bbfireint equ $1430       ; Size 3 AKA 4 Byte's

  ccintopc  equ bbfireint   ; $CD (INT opcode)
  ccintind  equ bbfireint+1 ; UINT8 ($60 to $67)
  ccretrat  equ bbfireint+2 ; $C3 (RET near opcode)
  ccjunk0   equ bbfireint+3 ; Nope ...

  bbvars    equ $1434       ; Size 12 = $0C Byte's

  vvmaxctrl equ bbvars      ; UINT16 (??? "bMaxPacketSize" is UINT8 only !!!)
  vvmaxbull equ bbvars+2    ; UINT16 (512 for EHCI)
  vvindex   equ bbvars+4    ; UINT8 (1 to 99)
  vvepos    equ bbvars+5    ; UINT8
  vvepoinnc equ bbvars+6
  vvepooutc equ bbvars+7
  vvepoinnv equ bbvars+8
  vvepooutv equ bbvars+9
  vvprdel   equ bbvars+10
  vvjunkxyz equ bbvars+11

  ; Total ($0400 + 4) + ($20 + 8 + 4) + 4 + $0C = $0440 Byte's

; ----------------------------------------------------------------------

format binary as "COM"
org $0100
use16

; ----------------------------------------------------------------------

; Program begin

; ----------------------------------------------------------------------

        ; Clear all

        cld
        movntq ax, 0
        mov    di, bbbigbuff
        mov    cx, $0220      ; $0440 Byte's
        rep    stosw

        ; Set magics

        mov    [bbmagic0], word $ABCF
        mov    [bbmagic1], word $9732

        ; Boast and prepare Sigi

        call   @f
        db     1, 'FASM DOSUSB LISTDEVS example (R) "http://dosusb.net"'
        db     1, '(CL) 2010-03-24 by DOS386 | Abuse at your own risk !!!'
        db     1, 1, 0
@@:     pope   si
        lea    bp, [si+6]     ; Sigi
        call   ssprintsi

        ; Check Sigi (reference pointed by ES=CS and BP set above)

        ; Driver can be at INT $60 to $67 giving addresses $0180 to $019C
        ; Don't accept "off" > $FFF0 to prevent GPF !!!

        mov    [ccintopc], word $60CD
        mov    [ccretrat], byte $C3

int_search:
        movntq ax, 0
        mov    al, [ccintind]     ; DS==CS
        shl    ax, 2              ; MUL by 4 | INT index -> IVCT address
        xchg   si, ax             ; MOVNTQ SI, AX | AX ???
        movntq ax, 0
        mov    ds, ax             ; ZERO-based | Trashing DS !!!
        lodsw                     ; AX off
        cmp    ax, $FFF0
        ja     short gpf_no_thanks
        xchg   dx, ax             ; DX off | AX ???
        lodsw                     ; AX seg | DX off
        mov    si, dx             ; SI off | DX off | AX seg
        mov    ds, ax             ; DS:SI found stuff | Trashing DS !!!
        xchg   bx, ax             ; SI off | DX off | BX seg | AX ???
        lodsw                     ; Skip JMP SHORT | SI off | DX seg | AX ???
        mov    cx, 3
        mov    di, bp
        repe   cmpsw              ; Sets flag(Z) like CMP
        pushf
        mov    di, dx             ; DI off | BX seg

        ; Peek date (can be invalid) into DX and CH

        lodsw                 ; AL Y | AH M
        xchg   dx, ax         ; DL Y | DH M | AX ???
        lodsb                 ; AL D | AH ???
        mov    ch, al         ; CH D
        movntq ds, cs         ; Restoring DS !!!

        ; Got target address in DI and BX (may be invalid)
        ; Got date in DX and CH (may be invalid)
        ; Got comparison status in PUSHF'ed flag(Z)

        popef
        je     short dr_found ; DS is already restored !!!

gpf_no_thanks:
        movntq ds, cs         ; Restoring DS !!!
        inc    byte [ccintind]
        cmp    byte [ccintind], $68
        jne    short int_search

        call   drv_evil_pr
        db     "Driver not found", 0
        ;---------------------------

dr_found:

        ; Got target address in DI and BX
        ; Got date in DX and CH (may be invalid)

        call   @f
        db     "Driver found at INT ",0
@@:     pope   si
        call   ssprintsi
        mov    al, [ccintind]
        call   ssdhex8

        call   @f
        db     " | Addr: ",0  ; "ess" would not fit into 80 chars if too old
@@:     pope   si
        call   ssprintsi
        xchg   ax, bx         ; "seg" | BX trashed, nobody needs it anymore
        call   ssdhex16
        mov    al, $3A        ; ":"
        call   ssonecharal
        xchg   ax, di         ; "off" | DI trashed, nobody needs it anymore
        call   ssdhex16
        call   ssspcwallspc

        ; Got date in DX and CH (may be invalid)
        ; Check for validity

        cmp    dl, 10         ; Y
        jb     short f_d
        cmp    dl, 50
        ja     short f_d
        cmp    dh, 1          ; M
        jb     short f_d
        cmp    dh, 12
        ja     short f_d
        cmp    ch, 1          ; D
        jb     short f_d
        cmp    ch, 32
        jb     short g_d

f_d:    call   drv_evil_pr
        db     "Faulty date", 0
        ;----------------------

        ; Got date in DX and CH (valid)
        ; Report it

g_d:    call   @f
        db     "Date: 20",0
@@:     pope   si
        call   ssprintsi

        mov    al, dl         ; Y
        call   ssdec99
        call   ssdash
        mov    al, dh         ; M
        call   ssdec99
        call   ssdash
        mov    al, ch         ; D
        call   ssdec99

        ; Check for age / earliest acceptable date
        ; Minimum is 2010-03-24

        cmp    dl, 10         ; Y
        ja     short a_g
        jb     short a_f
        cmp    dh, 3          ; M
        ja     short a_g
        jb     short a_f
        cmp    ch, 24         ; D
        jae    short a_g

a_f:    call   ssspcdashspc
        call   drv_evil_pr
        db     "unusably old",0
        ; quasi-pass

drv_evil_pr:
        pope   si
        call   ssprintsi
        jmp    near give_up
        ;------------------

a_g:
        ; Boast

        call   @f
        db 1, 1, "Devices assigned by DOSUSB", 0
@@:     pope   si
        call   ssprintsi
        call   ssdotty        ; Reduces risk of hang ???
        call   sseol
        call   sseol

list_loop:

        ; Done ???

        inc    byte [vvindex]
        mov    bl, [vvindex]
        cmp    bl , 99        ; Hit limit ???
        jb     short @f       ; NO ...

pre_got_eof:
        jmp    near got_eof   ; Done !!!
        ;------------------

@@:
        ; First check for EHCI (just fill in "urb" and AX, no "request")
        ; No risk of error except that can be "urb.transaction_token" = 0
        ; AKA "no more devices" ???

        call   ssemptyurb ; Leaves DI pointing to "bburb" and AX == 0 !!
        dec    ax         ; % MOV AL, $FF | Control:$2D In:$69 Out:$E1 AX:$FF
        stosb             ; % "urb.transaction_token" = $FF | + 0 UINT8
        inc    di         ; Skip "chain_end_flag"
        mov    al, bl     ; & Index
        stosb             ; & "urb.dev_add"=da% | +2 UINT8 | ZERO is INVALID
        mov    ax, 7      ; Check controler and device
        call   ssfirejdosusb  ; No "request" here ...
        mov    bl, [bburb]    ; # "controller%" = "urb.transaction_token"
        cmpntq bl, 0          ; # "E", "O" or "U" controller, ZERO if no more
        je     short pre_got_eof  ; No more devices

        ; Boast

        call   @f
        db "Device number: ", 0
@@:     pope   si
        call   ssprintsi

        mov    al, [vvindex]
        call   ssdec99        ; Can be 1 to 99 only

        call   @f
        db 1, "Controller: ", 0
@@:     pope   si
        call   ssprintsi

        mov    al, bl             ; Was in "bburb"
        call   ssreportletter     ; Report controller letter, set flag(C)
        jc     short after_ctl    ; Invalid

        call   @f
        db "HCI", 0
@@:     pope   si
        call   ssprintsi      ; "AHCI" ?!?!?!?

after_ctl:
        call   @f
        db " | Speeed: ", 0
@@:     pope   si
        call   ssprintsi

        mov    al, [bburb+28] ; "speed%" = "urb.next_urb_off" | "H", "F", "L"
        call   ssreportletter ; Report speed letter, set flag(C), nobody care

        ; Set "safe" defaults

        mov    [vvmaxctrl], word 8
        mov    [vvmaxbull], word 64

        ; maxpaketlen_ctrl%=8   ; Try with lowest possible value for 1.1
        ; maxpaketlen_bulk%=64  ; Fixed for 1.1

        cmp    bl, 69         ; EHCI ???
        jne    short @f       ; NO ...

        mov    [vvmaxctrl], byte 64   ; HI is ZERO
        mov    [vvmaxbull], word 512

        ; maxpaketlen_ctrl%=64  ; fixed for 2.0
        ; maxpaketlen_bulk%=512 ; fixed for 2.0

@@:
        ; Request truncated 8 Byte's device descriptor to get Class Code
        ; and a better (?) "bMaxPacketSize" AKA "maxpaketlen_ctrl%" value
        ; "urb.transaction_token" = $2D             | UINT8
        ; "urb.buffer_length" = 8                   | UINT16
        ; "urb.actual_length" = "maxpaketlen_ctrl%" | UINT16
        ; No risk of error ???

        mov    al, 8
        call   ssurbrequestdefa

        ; Boast with Class Code
        ; Here can be and usually is "Interface specific"

        call   sseol
        mov    al, [bbbigbuff+4]  ; Peek it
        call   sshclassboast  ; Include: preceding EOL NO, folowing space YES

        ; Boast with "bMaxPacketSize" and set "vvmaxctrl" if valid

        call   @f
        db "| bMaxPacketSize: ", 0
@@:     pope   si
        call   ssprintsi
        mov    al, [bbbigbuff+7]  ; "bMaxPacketSize" peeked from big buffer
        call   ssdhex8
        cmp    al, 7
        ja     short maxi_vali    ; COOL :-)
        call   ssinvalid
        jmp    short pre_dev_done5
        ;-------------------------

maxi_vali:
        mov    [vvmaxctrl], al    ; Got it ... poke  it ... but HIGH = ???

        ; Request full device descriptor (nothing to boast,
        ; this just returns string indexes for later)
        ; "urb.transaction_token" = $2D             | UINT8
        ; "urb.buffer_length" = $12                 | UINT16
        ; "urb.actual_length" = "maxpaketlen_ctrl%" | UINT16
        ; "device_request.wLength" = $12            | UINT16 | $12=#18
        ; Here got risk of error finally ???

        mov    al, $12
        call   ssurbrequestdefa

        ; Check for critical errors

        mov    ax, [(bburb+4)]    ; AL is "error_code" | AH is "status"

        cmp    al, 1              ; 1 is OK
        jne    short not_ida

        call   @f
        db 1, 1, "Invalid device address", 0
@@:     pope   si
        call   ssprintsi

pre_dev_done5:
        jmp    short pre_dev_done4
        ;-------------------------

not_ida:
        cmp    ah, 2              ; ZERO and 1 are both valid ???
        jb     short not_dnr

        call   @f
        db 1, 1, "Device does not respond", 0
@@:     pope   si
        call   ssprintsi

pre_dev_done4:
        jmp    short pre_dev_done3
        ;-------------------------

not_dnr:

        ; Request 3 strings (if available) and boast with them

        call   ssh3strings    ; Reduce jump distance

        ; Peek configuration descriptor (with EPO's) truncated, then full
        ; Accept total size from 12 to $0400 Byte's
        ; "device_request.wValue" = $0200
        ; "device_request.wIndex" = 0
        ; "device_request.wLength" = 8 or more
        ; Save peeking limit (inclusive, -1 !!!) into DI !!!
        ; Criminal error risk ???

        mov    cx, $0200          ; "device_request.wValue" = $0200 | UINT16
        mov    dx, $0409          ; "device_request.wIndex" = $0409 | UINT16
        mov    ax, 8              ; Length
        call   ssurbrequestfull   ; Load truncated "config" block

        call   @f
        db 1, "Confi size sub, total: ", 0
@@:     pope   si
        call   ssprintsi
        mov    al, [bbbigbuff]    ; Peek "sub"
        call   ssdhex8
        mov    bl, al             ; Backup of "sub"
        call   sscommaspc
        mov    ax, [bbbigbuff+2]  ; Peek "total"
        call   ssdhex16
        cmp    bl, 9              ; "sub"
        jb     short confi_inva
        cmp    ax, $0400          ; "total"
        ja     short confi_inva
        cmp    ax, 12             ; "total"
        jae    short confi_valid

confi_inva:
        call   ssinvalid          ; Includes preceding space

pre_dev_done3:
        jmp    short pre_dev_done2
        ;-------------------------

confi_valid:
        mov    di, ax
        add    di, (bbbigbuff-1)  ; "bbbigbuff">1 | Peeking limit for later !

        mov    cx, $0200          ; "device_request.wValue" = $0200 | UINT16
        mov    dx, $0409          ; "device_request.wIndex" = $0409 | UINT16
        call   ssurbrequestfull   ; Load full "config" block

        ; Amount of interfaces (usually 1, accept 1 to 5)

        call   @f
        db " | Amount of interf: ", 0
@@:     pope   si
        call   ssprintsi
        mov    al, [bbbigbuff+4]
        call   ssdhex8
        cmp    al, 5
        ja     short inte_inva
        cmp    al, 0
        jne    short inte_valid

inte_inva:
        call   ssinvalid          ; Includes preceding space

pre_dev_done2:
        jmp    short pre_dev_done1
        ;-------------------------

inte_valid:

        ; Check 1 interface only
        ;   bLength             UINT8 + 0
        ;   bDescriptorType     UINT8 + 1 | Always 4 ???
        ;   bNumEndpoints       UINT8 + 4 | Usually 3 ??? Accept 1 to 8
        ;   bInterfaceClass     UINT8 + 5 | !!! Here !!!
        ;   iInterface          UINT8 + 8 | Index to interface specific text

        ; !!!FIXME!!! more correct limit check

        call   @f
        db 1, "Interf: ", 0
@@:     pope   si
        call   ssprintsi

        mov    si, bbbigbuff  ; !!! Here we set SI for the BIG evaluation
        lodsb                 ; Skip confi subblock + 1 Byte, get in "interf"
        call   qqq_subr_add_si_al
        lodsb                 ; + 1 | Value must be 4
        cmp    al, 4
        je     short intim_valid
        call   ssinvalid

pre_dev_done1:
        jmp    short pre_dev_done0
        ;-------------------------

qqq_subr_add_si_al:
        mov    ah, 0
        add    si, ax             ; Skip some subblock
        cmp    si, di             ; DI is the inclusive limit
        ja     short evil_limit   ; Limit violation
        ret
        ;----

evil_limit:
        pope   ax                     ; Throw away
        jmp    short pre_dev_done1    ; Limit violation
        ;-------------------------

intim_valid:
        mov    al, 3
        call   qqq_subr_add_si_al ; Had + 2 before addition

        push   si             ; Now + 5
        lodsb                 ; + 5 Class | Here it should no longer be ZERO
        call   sshclassboast

        call   @f
        db "Epo amount: ", 0
@@:     pope   si
        call   ssprintsi

        pope   si             ; Has + 5
        dec    si
        lodsb                 ; + 4 | Amount of endpoints
        call   ssdhex8
        cmp    al, 8
        ja     short epo_inva
        cmp    al, 0
        jne    short epo_valid

epo_inva:
        call   ssinvalid

pre_dev_done0:
        jmp    near dev_done
        ;-------------------

epo_valid:
        mov    [vvepos], al

        if ((vvepoinnc+1)<>vvepooutc)
          err "(vvepoinnc+1)<>vvepooutc"
        end if

        mov    [vvepoinnc], word 0    ; ZERO'ize for every device

        ; Endpoints
        ;   bLength             UINT8  + 0
        ;   bDescriptorType     UINT8  + 1
        ;   bEndpointAddress    UINT8  + 2 | HOT !!! | "b7" = 1 says "IN"
        ;   bmAttributes        UINT8  + 3

        push   si
        call   @f
        db 1, "Epo's:", 0
@@:     pope   si
        call   ssprintsi
        pope   si
        sub    si, 5          ; + 0

        lodsb                     ; + 0 "bLength" -> + 1
        call   qqq_subr_add_si_al ; Skip "interf" subblock +1 Byte, get in EPO
        lodsb                     ; + 1 -> + 2 | $21 is invalid, skip it ???
        dec    si                 ; + 2 -> + 1
        dec    si                 ; + 1 -> + 0
        cmp    al, $21
        jne    short epo_loop     ; FWD | Good, no invalid EPO block

        push   si
        call   ssspc
        call   ssquest            ; Invalid EPO block gives "???"
        pope   si

        lodsb                     ; + 0 "bLength"
        dec    si                 ; Get back to + 0
        call   qqq_subr_add_si_al ; Skip invalid block

        ; EPO checking loop
        ; Preferably, a device will provide exactly 1 (ONE)
        ; "Bulk IN" endpoint and exactly 1 (ONE) "Bulk OUT"
        ; endpoint. Most devices do provide additional other
        ; non-Bulk endpoints, but some also provide ZERO or more
        ; than 1 of the requested 2 types - bad. Also "Bulk IN"
        ; and "Bulk OUT" should be different, but faulty devices exist
        ; with both having the same value.

epo_loop:
        call   ssspc
        mov    al, 3
        call   qqq_subr_add_si_al ; +0 -> +3 | Check limit
        dec    si                 ; Skip + 0 "bLength" and + 1 Type
        lodsb                     ; + 2 Address (HOT !!!)
        mov    bl, al
        call   ssdhex8
        call   ssdash
        lodsb                     ; + 3 Attrib
        call   ssdhex8
        and    al, 3
        cmp    al, 2              ; BULL'k ???
        jne    short after_bull_s ; No BULL

        mov    al, bl             ; Address
        and    al, 127            ; "b7" says "IN"
        test   bl, 128
        jnz    short epo_in

        mov    [vvepooutv], al
        inc    byte [vvepooutc]
        jmp    short after_bull_s
        ;------------------------

epo_in:
        mov    [vvepoinnv], al
        inc    byte [vvepoinnc]

after_bull_s:
        dec    byte [vvepos]      ; We got at least 1, safe to DEC
        cmp    byte [vvepos], 0
        je     short epos_done    ; Check count before limit !!!
        sub    si, 4
        lodsb                     ; + 0 "bLength"
        dec    si                 ; Get to + 0
        call   qqq_subr_add_si_al ; And proceed to next EPO block
        jmp    short epo_loop
        ;--------------------

        ; Report (preferably 2) HOT Epo's
        ; Sorting: vvepoinnc, vvepooutc, vvepoinnv, vvepooutv

        if ((vvepoinnc+1)<>vvepooutc)
          err "(vvepoinnc+1)<>vvepooutc"
        end if
        if ((vvepoinnv+1)<>vvepooutv)
          err "(vvepoinnv+1)<>vvepooutv"
        end if
        if ((vvepoinnc+2)<>vvepoinnv)
          err "(vvepoinnc+2)<>vvepoinnv"
        end if

epos_done:
        call   @f
        db 1, "HOT Bulk Epo's: IN:", 0
@@:     pope   si
        call   ssprintsi

        cmp    byte [vvepoinnc], 1    ; Got exactly 1 IN ???
        jne    short no_in_epo

        mov    al, [vvepoinnv]
        call   sshexordec             ; "vvepoinnv"
        jmp    short after_in_epo
        ;------------------------

no_in_epo:
        call   ssquest

after_in_epo:
        call   @f
        db ", OUT:", 0
@@:     pope   si
        call   ssprintsi

        cmp    byte [vvepooutc], 1    ; Got exactly 1 OUT ???
        jne    short no_out_epo

        mov    al, [vvepooutv]
        call   sshexordec             ; "vvepooutv"
        jmp    short after_out_epo
        ;-------------------------

no_out_epo:
        call   ssquest

after_out_epo:
        mov    si, vvepoinnc
        lodsw                     ; Get "vvepoiinnc" and "vvepooutc"
        cmp    ax, $0101          ; Got exactly 1 IN and 1 OUT ???
        jne    short dev_done     ; No, shut up
        lodsw                     ; Get "vvepoinnv" AL and "vvepooutv" AH
        cmp    al, ah             ; EPO's should NOT be equal, but ...
        je     short epo_evil_equ

        call   epo_join
        db " (good)", 0
        ;--------------

epo_evil_equ:
        call   epo_join
        db " (evil)", 0
        ; quasi-pass

epo_join:
        pope   si
        call   ssprintsi

        ; Done 1 device

dev_done:
        call   ssdotty            ; Reduces risk of hang ???
        call   sseol
        call   sseol
        cmp    [bbmagic0], byte 0
        je     short got_panic    ; Oh nooooooooooooo
        jmp    near list_loop
        ;--------------------

        ; !!!PANIC!!!

got_panic:
        call   @f
        db "Memory corrupted !!!", 0
@@:     pope   si
        call   ssprintsi
        jmp    short give_up
        ;-------------------

        ; Done all !!!

got_eof:
        cmp    byte [vvindex], 1
        jne    short got_not_bugger
        call   @f
        db "(nothing found)", 1, 1, 0
@@:     pope   si
        call   ssprintsi

got_not_bugger:
        call   @f
        db "Done !!!", 0
@@:     pope   si
        call   ssprintsi

        ; Done or not, it's enough now

give_up:
        call   sseol
        call   sseol
        mov    ax, $4C00
        int    $21
        ;---------

; ----------------------------------------------------------------------

; High level SUB's

; ----------------------------------------------------------------------

; SUB SSHCLASSBOAST

sshclassboast:

        push   ax                 ; PUSHNTQ AL
        call   @f
        db "Class Code: ", 0
@@:     pope   si
        call   ssprintsi
        pope   ax                 ; POPENTQ AL
        push   ax                 ; PUSHNTQ AL
        call   ssdhex8
        call   ssspc              ; Trashes AX
        call   ssopenbra
        pope   ax                 ; POPENTQ AL
        cmp    al, 8
        je     short class_sto
        cmp    al, 7
        je     short class_pri
        cmp    al, 0              ; This is the far most frequent case ;-)
        je     short class_inter

        call   clas_join
        db "other", 0
        ;------------

class_sto:
        call   clas_join
        db "storage", 0
        ;--------------

class_pri:
        call   clas_join
        db "printer", 0
        ;--------------

class_inter:
        call   clas_join
        db "by interf", 0
        ; quasi-pass

clas_join:
        pope   si
        call   ssprintsi
        call   ssclobra
        jmp    near ssspc
        ;----------------

; SUB SSH3STRINGS

ssh3strings:

        ; Retrieve string stuff descriptors from
        ; "device descriptor" block already loaded
        ;   iManufacturer       UINT8  + 14
        ;   iProduct            UINT8  + 15
        ;   iSerialNumber       UINT8  + 16
        ; Picking the string overwrites the buffer, so PUSH them now
        ; Risk of error ???

        mov    al, [bbbigbuff+16] ; Check "www.serialz.to"
        push   ax
        mov    al, [bbbigbuff+15] ; Peek "device_descriptor_ptr.iProduct"
        push   ax

        call   @f
        db 1, "Manufacturer: ", 0
@@:     pope   si
        call   ssprintsi
        mov    al, [bbbigbuff+14]
        call   sshstringdes

        call   @f
        db 1, "Product: ", 0
@@:     pope   si
        call   ssprintsi
        pope   ax
        call   sshstringdes

        call   @f
        db 1, "Serial Number: ", 0
@@:     pope   si
        call   ssprintsi
        pope   ax
        ; and pass

; SUB SSHSTRINGDES

; In: AL: Index value, may be ZERO

; Will load the string from device if ("index" <> ZERO) !!!

sshstringdes:

        call   ssopenbra      ; "(" | Preseves AX
        call   ssdhex8        ; Preserves AX
        call   ssclobra       ; ")" | Preserves AX
        cmp    al, 0
        jne    short got_string

        call   @f
        db " (nope)", 0
@@:     pope   si
        jmp    near ssprintsi ; And exit this SUB
        ;--------------------

got_string:

        ; Get string descriptor
        ;   iManufacturer       UINT8  + 14
        ;   iProduct            UINT8  + 15
        ;   iSerialNumber       UINT8  + 16

        mov    ah, 3          ; AL is index
        xchg   cx, ax         ; "device_request.wValue" = $0300 + index
        mov    dx, $0409      ; "device_request.wIndex" = $0409 | UINT16
        mov    ax, $DF        ; Length
        call   ssurbrequestfull

        ; Boast with it

        call   ssspc
        mov    si, bbbigbuff
        lodsw             ; "len"=peek(usb_buffer) | Stuff length in Byte's
        call   ssopenbra  ; "(" | Preserves AX
        call   ssdhex16   ; Preserves AX
        call   ssclobra   ; ")" | Preserves AX
        cmp    al, 220
        ja     short stme_invid
        cmp    al, 5          ; At least 6 Byte's AKA 2 char's
        ja     short stme_valid

stme_invid:
        jmp    near ssinvalid ; And exit this SUB
        ;--------------------

stme_valid:
        mov    ah, 0          ; Length is only UINT8
        shr    ax, 1          ; Uni
        dec    ax             ; 2 Byte's junk
        xchg   ax, cx
        call   ssspc
        call   ssquot

unic_loop:
        lodsw
        cmp    al, 32
        jb     short char_sucks
        cmp    al, 126            ; "~"
        jb     short char_cool
char_sucks:
        mov    al, 46
char_cool:
        call   ssonecharal
        loop   short unic_loop
        jmp    near ssquot        ; And exit this SUB
        ;-----------------

; SUB SSEMPTYURB

; In: NOTHING

; Out: DI == "bburb" and AX==0 and CX==0 !!!

; Trashes AX CX DI

ssemptyurb:

        movntq ax, 0
        mov    di, bburb
        push   di
        mov    cx, $10        ; $20 Byte's
        rep    stosw
        pope   di             ; Leave DI == "bburb" !!!
        ret                   ; Also AX == 0
        ;----

; SUB SSURBREQUESTDEFA

; In: AL length

; Out: "bbbigbuf"

; Trashes AX BX CX DX DI

ssurbrequestdefa:

        mov    ah, 0
        mov    cx, $0100      ; "device_request.wValue" =?= $0100 | UINT16
        movntq dx, 0          ; "device_request.wIndex" = 0 | UINT16
        ; and pass

; SSURBREQUESTFULL:

; In: AX length | CX and DX

; Out: "bbbigbuf"

; Trashes AX BX CX DX DI

ssurbrequestfull:

        push   ax             ; "wLength"

        mov    di, bbrequest
        mov    ax, $0680      ; "device_request.bmRequestType" = $80 | UINT8
        stosw                 ; "device_request.bRequest" = 6 | UINT8
        xchg   ax, cx
        stosw                 ; "wValue" in CX
        xchg   ax, dx
        stosw                 ; "wIndex" in DX

        pope   ax
        stosw                 ; "device_request.wLength" | UINT16
        push   ax

        call   ssemptyurb     ; Leaves DI pointing to "bburb" and AX == 0 !!

        mov    al, $2D        ; @ "urb.transaction_token" = $2D | + 0 UINT8
        stosw                 ; @ Control:$2D In:$69 Out:$E1 AX:$FF
        mov    al, [vvindex]
        stosb           ; "urb.dev_add" = da% | + 2 UINT8 | ZERO is INVALID
        add    di, 9    ; +3 -> +12

        pope   ax       ; "wLength"
        stosw           ; "urb.buffer_length" | +12 | UINT16
        mov    ax, [vvmaxctrl]
        stosw           ; "urb.actual_length" = "maxpaketlen_ctrl%" | +14
        mov    ax, bbrequest
        stosw           ; "urb.setup_buffer_off"=varptr(device_request) | +16
        mov    ax, cs
        stosw           ; "urb.setup_buffer_seg"=varseg(device_request) | +18
        movntq ax, 0
        ; and pass

; SUB SSFIREJDOSUSB

; In: AX , "bburb" block

; Out: "bbbigbuf" , for AX=7 also "bburb" block

; Trashes AX DX DI

ssfirejdosusb:

        xchg   ax, dx         ; Backup AX
        mov    di, (bburb+8)
        mov    ax, bbbigbuff
        stosw                 ; "urb.buffer_off" = varptr(usb_buffer)
        mov    ax, cs
        stosw                 ; "urb.buffer_seg" = varseg(usb_buffer)
        xchg   ax, dx         ; Restore AX
        mov    dx, bburb      ; FYI: DS==CS
        call   ssdwait        ; Better safe and slow than sorry and dead ;-)
        cmp    [bbmagic0], word $ABCF
        jne    short magic_evil
        cmp    [bbmagic1], word $9732
        jne    short magic_evil
        call   near bbfireint ; This will work with any INT, not just $65 ;-)
        cmp    [bbmagic0], word $ABCF
        jne    short magic_evil
        cmp    [bbmagic1], word $9732
        je     short magic_good

magic_evil:
        movntq ax, 0
        mov    [bbmagic0], ax
        mov    [bbmagic1], ax

magic_good:
        ret
        ;----

; ----------------------------------------------------------------------

; Low level SUB's

; ----------------------------------------------------------------------

; SUB SSREPORTLETTER

; In: AL | Out: flag(C)

ssreportletter:

        cmp    al, 65         ; "A"
        jb     short le_invalid
        cmp    al, 91         ; "Z"+1
        jb     short le_valid

le_invalid:
        call   ssdhex8
        call   ssinvalid      ; Includes preceding space
        stc
        ret
        ;----

le_valid:
        call   ssonecharal
        clc
        ret
        ;----

; SSCONVERTDEC1DIG - Works on AL

ssconvertdec1dig:
        cmp    al, 10
        jb     short @f
        mov    al, 15         ; "?"
@@:     add    al, 48
        ret
        ;----

; SSDEC99CONV - Input AL | Out AX | AX destroyed, all other preserved

ssdec99conv:

        mov    ah, 0          ; For "DIV BL" the divisor is full AX !!!
        cmp    ax, 99
        ja     short @f       ; Invalid
        push   bx
        mov    bl, 10
        div    bl             ; Quotient in AL | Remainder in AH
        pope   bx
        call   ssconvertdec1dig
        xchg   ah, al
        call   ssconvertdec1dig
        xchg   ah, al
        ret
        ;----

@@:     mov    ax, $3F3F      ; "??"
        ret
        ;----

; SSDEC99 - Input AL | AX destroyed, all other preserved

ssdec99:

        call   ssdec99conv
        jmp    short ssdchar
        ;-------------------

; SUB SSHEXORDEC

sshexordec:

        cmp    al, 100
        jb     short ssdec99
        ; and pass

; SUB's SSHEX8 SSHEX16

ssdhex8:

        mov    ah, 0          ; !!!FIXME!!!
        ; and pass

; SSDHEX16 - Just HEX16 prefixed with a dollar "$" ...

ssdhex16:

        push   ax
        call   ssdoll
        pope   ax
        ; and pass

; SSHEX16

sshex16:
        push   cx

        mov    cx, 1028     ; "MOVNTQ CL, 4" + "MOVNTQ CH, 4"
@@:     rol    ax, cl       ; 8086 compatible, after 4 ROL's original back
        push   ax
        and    al, $0F
        cmp    al, 10       ; Now must be and is AL<=15 | Decimal "10" !!!
        sbb    al, $69      ; Securely Bugged Backup
        das                 ; Digital Attack System | ASCII result in AL
        call   ssonecharal
        pope   ax
        dec    ch           ; & No LOO'p on CH :-(
        jnz    short @b     ; &

        pope   cx
        ret
        ;----

; SINGLE- , DOUBLE- & TRIPLE-CHAR SUB'S | SSSPCDASHSPC + EOL

; SSSPCWALLSPC

ssspcwallspc:
        call   ssspc
        mov    al, 124        ; "|"
        call   ssonecharal
        jmp    short ssspc
        ;-----------------

; SSSPCDASHSPC

ssspcdashspc:
        call   ssspc
        call   ssdash
        ; and pass

; SSSPC

ssspc:
        mov    al, 32
        db     $A9            ; TESTNTQ AX, stuff
        ; quasi-pass

ssquot:
        mov    al, 34
        db     $A9            ; TESTNTQ AX, stuff
        ; quasi-pass

ssdoll:
        mov    al, 36         ; "$"
        db     $A9            ; TESTNTQ AX, stuff
        ; quasi-pass

ssdash:
        mov    al, 45         ; "-" dash
        db     $A9            ; TESTNTQ AX, stuff
        ; quasi-pass

ssdot:
        mov    al, 46         ; "." dot
        jmp    short ssonecharal
        ;-----------------------

sseol:
        push   ax
        mov    ax, $0A0D
        call   ssdchar
        pope   ax
        ret
        ;----

sscommaspc:
        mov    ax, $202C
        ; and pass

ssdchar:
        call   ssonecharal
        mov    al, ah
        ; and pass

; SSONECHARAL

; One char | Input: AL
; All registers preserved, optionally including flags [-] !!!

ssonecharal:

        ; pushf            ; opt
        push   ax
        push   bx
        ; push   dx

        ; cmp    byte [vvprfast], 0
        ; jne    short @f       ; No slowdown
        inc    byte [vvprdel]
        test   byte [vvprdel], 15
        jnz    short @f
        call   sswait         ; Preserves all except flags
@@:
        mov    ah, $0E        ; "TTY" BIOS service, char in AL
        movntq bx, 0
        int    $10            ; BIOS screen stuff

        ; mov    dl, al
        ; mov    ah, 2        ; DOS service, char in DL
        ; int    $21          ; Here

        ; pope   dx
        pope   bx
        pope   ax
        ; popef            ; opt

        ret
        ;----

; SUB SSOPENBRA

ssopenbra:

        push   ax
        mov    al, 40     ; "("
        jmp    short ssbra
        ;-----------------

; SUB SSCLOBRA

ssclobra:

        push   ax
        mov    al, 41     ; ")"
        ; and pass

; SUB SSBRA

ssbra:

        call   ssonecharal
        pope   ax
        ret
        ;----

; SUB SSQUEST | NO preceding SPACE

ssquest:

        call   ssxxx
        db "???", 0
        ;----------

; SUB SSINVALID :lol: | Includes preceding SPACE

ssinvalid:

        call   ssxxx
        db " (invalid)", 0
        ; quasi-pass

ssxxx:
        pope   si
        ; and pass

; SUB SSPRINTSI

; Input in SI
; Converts value of 1 to EOL

ssprintsi:
        push   ax
        push   si

pickchar:
        lodsb
        cmp    al, 0
        je     short sisi_done
        cmp    al, 1
        jne    short @f
        call   sseol
        jmp    short pickchar
        ;--------------------

@@:     ; call   ssfaultyfix
        call   ssonecharal
        jmp    short pickchar
        ;--------------------

sisi_done:
        pope   si
        pope   ax
        ret
        ;----

; SSDOTTY | Brews 1 space and 9 dot's in 1 second, that's all .........

ssdotty:

        call   ssspc
        mov    cx, 9
@@:     call   ssdot
        call   ssdwait
        loop   short @b
        ret
        ;----

; SSDWAIT - preserves all except flags

ssdwait:
        call  sswait
        ; and pass

; SSWAIT - preserves all except flags

sswait:
        push   ds
        push   ax
        movntq ax, 0
        mov    ds, ax
        mov    al, [$046C]    ; BIOS timer
@@:     cmp    al, [$046C]
        je     short @b       ; DANGER: will HANG if interrupts disabled !!!
        pope   ax
        pope   ds
        ret
        ;----

; ----------------------------------------------------------------------

