' This file has no copyright assigned and is placed in the Public Domain
' This sample prints the DosUHCI.TXT document to a HP Laserprinter in text
' mode. There are some PCL commands before and after the text output.
' This was tested with a HP 2420d printer.
'

'$INCLUDE: 'VBDOS.BI'

DEFINT A-Z

DIM regs AS RegTypeX                   ' Defines registers

CLS                                    ' Clears the screen

'define structure of URB
TYPE urbtype
  
  chain_end_flag__transaction_token  AS INTEGER
  'control (002Dh), in (0069h), out (00E1h) as hex code
  end_point__dev_add AS INTEGER
  status__error_code AS INTEGER 'returned by dosuhci
  transaction_flags AS INTEGER 'reserved
  buffer_off      AS INTEGER  'for in/out
  buffer_seg      AS INTEGER  'for in/out
  buffer_length   AS INTEGER  'for in/out
  actual_length   AS INTEGER  'for in/out
  setup_buffer_off AS INTEGER 'for control
  setup_buffer_seg AS INTEGER 'for control
  start_frame     AS INTEGER  'reserved
  nr_of_packets   AS INTEGER  'reserved - iso
  error_count__int_interval AS INTEGER  'reserved
  timeout         AS INTEGER  'reserved
  next_urb_off    AS INTEGER  'reserved
  next_urb_seg    AS INTEGER  'reserved
END TYPE '32 byte long

DIM urb AS urbtype

dev_add% = 1
in_endpoint% = 1
out_endpoint% = 2

DIM buffer  AS STRING * 1024
buffer = STRING$(1024, CHR$(0))

'Reset printer
b$ = CHR$(27) + "E" + CHR$(13) + CHR$(10)
'Enable end of line wrap
b$ = b$ + CHR$(27) + "&s0C" + CHR$(13) + CHR$(10)
'select PC-8 symbol set
b$ = b$ + CHR$(27) + "(10U" + CHR$(13) + CHR$(10)
'select 10 pitch, 12 point, upright medium, courier font
b$ = b$ + CHR$(27) + "(s0p10h12v0s0b3T" + CHR$(13) + CHR$(10)
MID$(buffer, 1) = b$
packetlen% = LEN(b$)
GOSUB do_out

OPEN "dosuhci.txt" FOR BINARY AS #1
jmax% = LOF(1)
GET #1, LOF(1), b$
CLOSE #1

jmax% = jmax% \ 64 + 1
FOR j = 0 TO jmax%
   a$ = MID$(b$, 1 + j * 64, 64)
   buffer = STRING$(1024, CHR$(0))
   MID$(buffer, 1) = a$
   packetlen% = 64
   GOSUB do_out
NEXT j

buffer = STRING$(1024, CHR$(0))
'Reset and eject page
b$ = CHR$(27) + "E" + CHR$(13) + CHR$(10)
MID$(buffer, 1) = b$
packetlen% = 4
GOSUB do_out

END

do_out:  'public subroutine

FOR i_out = 1 TO 4'retry four times

'set up out request
  urb.chain_end_flag__transaction_token = &HE1
  urb.end_point__dev_add = out_endpoint% * &H100 + dev_add%
  urb.status__error_code = 0
  urb.transaction_flags = 0
  urb.buffer_off = VARPTR(buffer)
  urb.buffer_seg = VARSEG(buffer)
  urb.buffer_length = packetlen%
  urb.actual_length = 64
  urb.setup_buffer_off = 0
  urb.setup_buffer_seg = 0
  urb.start_frame = 0
  urb.nr_of_packets = 0
  urb.error_count__int_interval = 0
  urb.timeout = 0
  urb.next_urb_off = 0
  urb.next_urb_seg = 0

'now call DosUHCI

 regs.dx = VARPTR(urb)
 regs.ds = VARSEG(urb)
 CALL INTERRUPTX(&H65, regs, regs)

IF usb.status <> &H88 THEN EXIT FOR

NEXT i_out

RETURN

