/*      ENUM_GCC.C -- retrieves the device descriptor of a USB device
        using the DOSUSB driver.

        This file has no copyright assigned
        and is placed in the Public Domain

        Using GCC 
*/

#include <stdio.h>

#include <stdlib.h>
#include <time.h>
#include <string.h>

#include <sys/types.h>
#include <sys/movedata.h>
#include <dpmi.h>
#include <go32.h>

struct urbtype {
  char  transaction_token ;
  char  chain_end_flag ;
  char  dev_add ;
  char  end_point ;
  char  error_code ;
  char  status ;
  unsigned short  transaction_flags __attribute__((packed));
  unsigned short  buffer_off __attribute__((packed));
  unsigned short  buffer_seg __attribute__((packed));
  unsigned short  buffer_length __attribute__((packed));
  unsigned short  actual_length __attribute__((packed));
  unsigned short  setup_buffer_off __attribute__((packed));
  unsigned short  setup_buffer_seg __attribute__((packed));
  unsigned short  start_frame __attribute__((packed));
  unsigned short  nr_of_packets __attribute__((packed));
  char  int_interval ;
  char  error_count ;
  unsigned short  timeout __attribute__((packed));
  unsigned short  next_urb_off __attribute__((packed));
  unsigned short  next_urb_seg __attribute__((packed));    /* reserved */
} ;

struct setuptype {
  char   bmRequestType ;
  char   bRequest ;
  unsigned short   wValue __attribute__((packed));
  unsigned short   wIndex __attribute__((packed));
  unsigned short   wLength __attribute__((packed));
};

main()
{
struct urbtype urb;
struct setuptype device_request ;
char buffer[8] = "********";
int i;

/* we will put the struct URB at the beginning of the DJGPP transfer buffer.
After that, at byte 33 the struct device_request is put. Following that, at
byte 41, the memory area in the DJGPP transfer buffer is used as in/out buffer */

/* get device descriptor */
device_request.bmRequestType = 0x80;
device_request.bRequest = 6;
device_request.wValue = 0x100;
device_request.wIndex = 0;
device_request.wLength = 8;

/* set up request */
  urb.transaction_token=0x2D;
  urb.chain_end_flag=0;
  urb.dev_add=1;
  urb.end_point=0;
  urb.error_code=0;
  urb.status=0;
  urb.transaction_flags=0;
  urb.buffer_seg=(__tb+41) >> 4; 
  urb.buffer_off=(__tb+41) & 0x0f; 
  urb.buffer_length=8;
  urb.actual_length=8;
  urb.setup_buffer_seg=(__tb+33) >> 4;
  urb.setup_buffer_off=(__tb+33) & 0x0f;
  urb.start_frame=0;
  urb.nr_of_packets=0;
  urb.int_interval=0;
  urb.error_count=0;
  urb.timeout=0;
  urb.next_urb_seg=0;
  urb.next_urb_off=0;

/* now copy the URB into the transfer buffer */
dosmemput (&urb, 32, __tb);
/* now copy the device_request into the transfer buffer */
dosmemput (&device_request, 8, __tb+33);

   __dpmi_regs regs;

   //regs.x.ax = 4; //display
   regs.x.ds = __tb >> 4;     /* URB / transfer buffer address in DS:DX  */
   regs.x.dx = __tb & 0x0f;
   __dpmi_int (0x65, &regs);  /* call DOSUSB  */

/* now copy the URB from the transfer buffer */
dosmemget (__tb, 32, &urb);
/* now copy the in/out buffer from the transfer buffer */
dosmemget (__tb+41, 8, &buffer);

/* printf ("Buffer: %s\n",buffer); */
/* for (i=0 ; i<8; ++i) { printf ("%d ",buffer[i]); } */

printf("\n\nDevice Descriptor:");
printf("\nLength:                %d",buffer[0]);
printf("\nDescriptor type:       %d",buffer[1]);
printf("\nUSB specification nr.: %02X%02X hex",buffer[3],buffer[2]);
printf("\nClass code:            %d",buffer[4]);
printf("\nSubclass code:         %d",buffer[5]);
printf("\nProtocol code:         %d",buffer[6]);
printf("\nMax Packet size:       %d\n",buffer[7]);

}

