/*	ENUM.C -- retrieves the device descriptor of a USB device
	using the DOSUSB driver.

        This file has no copyright assigned
        and is placed in the Public Domain

	Done with an old Borland C compiler to be able to use
	FP_SEG and FP_OFF. DOSUSB needs real mode segment/offset address.
*/

#include <stdio.h>
#include <dos.h>

union REGS regs;

struct urbtype {
  char  transaction_token;
  char  chain_end_flag;
  char  dev_add;
  char  end_point;
  char  error_code;
  char  status;
  unsigned int  transaction_flags;
  unsigned int  buffer_off;
  unsigned int  buffer_seg;
  unsigned int  buffer_length;
  unsigned int  actual_length;
  unsigned int  setup_buffer_off;
  unsigned int  setup_buffer_seg;
  unsigned int  start_frame;
  unsigned int  nr_of_packets;
  char  int_interval;
  char  error_count;
  unsigned int  timeout;
  unsigned int  next_urb_off;
  unsigned int  next_urb_seg;    /* reserved */
} ;

struct setuptype {
  char   bmRequestType;
  char   bRequest;
  unsigned int   wValue;
  unsigned int   wIndex;
  unsigned int   wLength;
};

main()
{
struct urbtype urb;
struct setuptype device_request ;
char buffer[8] = "********";
int i;

/* get device descriptor */
device_request.bmRequestType = 0x80;
device_request.bRequest = 6;
device_request.wValue = 0x100;
device_request.wIndex = 0;
device_request.wLength = 8;

/* set up request */
  urb.transaction_token=0x2D;
  urb.chain_end_flag=0;
  urb.dev_add=1;
  urb.end_point=0;
  urb.error_code=0;
  urb.status=0;
  urb.transaction_flags=0;
  urb.buffer_seg=FP_SEG(&buffer);
  urb.buffer_off=FP_OFF(&buffer);
  urb.buffer_length=8;
  urb.actual_length=8;
  urb.setup_buffer_seg=FP_SEG(&device_request);
  urb.setup_buffer_off=FP_OFF(&device_request);
  urb.start_frame=0;
  urb.nr_of_packets=0;
  urb.int_interval=0;
  urb.error_count=0;
  urb.timeout=0;
  urb.next_urb_seg=0;
  urb.next_urb_off=0;

/* DS does not need to be set here */
regs.x.dx = FP_OFF(&urb);
int86(0x65, &regs, &regs);  /* call DosUHCI */

/* printf ("Buffer: %s\n",buffer); */
/* for (i=0 ; i<8; ++i) { printf ("%d ",buffer[i]); } */

printf("\n\nDevice Descriptor:");
printf("\nLength:                %d",buffer[0]);
printf("\nDescriptor type:       %d",buffer[1]);
printf("\nUSB specification nr.: %02X%02X hex",buffer[3],buffer[2]);
printf("\nClass code:            %d",buffer[4]);
printf("\nSubclass code:         %d",buffer[5]);
printf("\nProtocol code:         %d",buffer[6]);
printf("\nMax Packet size:       %d\n",buffer[7]);

}
