' This file has no copyright assigned and is placed in the Public Domain
' This sample prints the DosUSB.TXT document to a HP Laserprinter in text
' mode. There are some PCL commands before and after the text output.
' This was tested with a HP 2420d printer and QB 4.5
'
' Load QB with the /L parameter and then make a stand alone EXE file.

'$INCLUDE: 'QB.BI'

DEFINT A-Z

DIM regs AS RegTypeX

CLS

'define structure of URB
TYPE urbtype
  
  chainendflagtransactiontoken  AS INTEGER
  'control (002Dh), in (0069h), out (00E1h) as hex code
  endpointdevadd AS INTEGER
  statuserrorcode AS INTEGER 'returned by dosuhci
  transactionflags AS INTEGER 'reserved
  bufferoff      AS INTEGER  'for in/out
  bufferseg      AS INTEGER  'for in/out
  bufferlength   AS INTEGER  'for in/out
  actuallength   AS INTEGER  'for in/out
  setupbufferoff AS INTEGER 'for control
  setupbufferseg AS INTEGER 'for control
  startframe     AS INTEGER  'reserved
  nrofpackets   AS INTEGER  'reserved - iso
  errorcountintinterval AS INTEGER  'reserved
  timeout         AS INTEGER  'reserved
  nexturboff    AS INTEGER  'reserved
  nexturbseg    AS INTEGER  'reserved
END TYPE '32 byte long

DIM urb AS urbtype

devadd% = 1
inendpoint% = 1
outendpoint% = 2

DIM buffer  AS STRING * 1024
buffer = STRING$(1024, CHR$(0))

'Reset printer
b$ = CHR$(27) + "E" + CHR$(13) + CHR$(10)
'Enable end of line wrap
b$ = b$ + CHR$(27) + "&s0C" + CHR$(13) + CHR$(10)
'select PC-8 symbol set
b$ = b$ + CHR$(27) + "(10U" + CHR$(13) + CHR$(10)
'select 10 pitch, 12 point, upright medium, courier font
b$ = b$ + CHR$(27) + "(s0p10h12v0s0b3T" + CHR$(13) + CHR$(10)
MID$(buffer, 1) = b$
packetlen% = LEN(b$)
GOSUB doout

OPEN "dosusb.txt" FOR BINARY AS #1
jmax% = LOF(1)
b$ = SPACE$(jmax%)
GET #1, , b$
CLOSE #1

a$ = SPACE$(64)
jmax% = jmax% \ 64 + 1
FOR j = 0 TO jmax%
   a$ = MID$(b$, 1 + j * 64, 64)
   buffer = STRING$(1024, CHR$(0))
   MID$(buffer, 1) = a$
   packetlen% = 64
   GOSUB doout
NEXT j

buffer = STRING$(1024, CHR$(0))
'Reset and eject page
b$ = CHR$(27) + "E" + CHR$(13) + CHR$(10)
MID$(buffer, 1) = b$
packetlen% = 4
GOSUB doout

END

doout:  'public subroutine

FOR iout = 1 TO 4'retry four times

'set up out request
  urb.chainendflagtransactiontoken = &HE1
  urb.endpointdevadd = outendpoint% * &H100 + devadd%
  urb.statuserrorcode = 0
  urb.transactionflags = 0
  urb.bufferoff = VARPTR(buffer)
  urb.bufferseg = VARSEG(buffer)
  urb.bufferlength = packetlen%
  urb.actuallength = 64
  urb.setupbufferoff = 0
  urb.setupbufferseg = 0
  urb.startframe = 0
  urb.nrofpackets = 0
  urb.errorcountintinterval = 0
  urb.timeout = 0
  urb.nexturboff = 0
  urb.nexturbseg = 0

'now call DosUHCI

 regs.dx = VARPTR(urb)
 regs.ds = VARSEG(urb)
 CALL INTERRUPTX(&H65, regs, regs)

IF usb.status <> &H88 THEN EXIT FOR

NEXT iout

RETURN

