$stack 3072
defint a-z

' This file has no copyright assigned and is placed in the Public Domain

color 15,1 : cls
locate 12,20 : print "USBView for DosUHCI"
locate 18,20 : print "(Addresses are starting with 1)"
locate 14,20 : input "Please enter device address: ", devadd%
cls
locate 14,20 : print "Retrieving device descriptor..."

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved - int
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

type device_descriptor_type
   bLength		as byte
   bDescriptorType	as byte
   bcdUSB		as word
   bDeviceClass		as byte
   bDeviceSubClass	as byte
   bDeviceProtocol	as byte
   bMaxPacketSize	as byte
   idVendor		as word
   idProduct		as word
   bcdDevice		as word
   iManufacturer	as byte
   iProduct		as byte
   iSerialNumber	as byte
   bNumConfigurations	as byte
end type

dim device_descriptor_ptr as device_descriptor_type ptr

type configuration_descriptor_type
   bLength		as byte
   bDescriptorType	as byte
   wTotalLength		as word
   bNumInterfaces	as byte
   bConfigurationValue	as byte
   iConfiguration	as byte
   bmAttributes		as byte
   bMaxPower		as byte
end type

dim configuration_descriptor_ptr as configuration_descriptor_type ptr

type interface_descriptor_type
   bLength		as byte
   bDescriptorType	as byte
   bInterfaceNumber     as byte
   bAlternateSetting    as byte
   bNumEndpoints        as byte
   bInterfaceClass      as byte
   bInterfaceSubClass   as byte
   bInterfaceProtocol   as byte
   iInterface           as byte
end type

dim interface_descriptor_ptr as interface_descriptor_type ptr

type endpoint_descriptor_type
   bLength		as byte
   bDescriptorType	as byte
   bEndpointAddress     as byte
   bmAttributes         as byte
   wMaxPacketSize       as word
   bInterval            as byte
end type

dim endpoint_descriptor_ptr as endpoint_descriptor_type ptr

dim inbuffer as string*2048
dim inbuffer2 as string*2048

inbuffer=repeat$(1024,chr$(0)) 'return data here
inbuffer2=repeat$(1024,chr$(0)) 'return data here as well

'do 8 byte device_descriptor to determine maxlen of packet
'device descriptor
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0100
device_request.wIndex=0
device_request.wLength=&H08

'set up device descriptor request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(inbuffer)
  urb.buffer_seg=varseg(inbuffer)
  urb.buffer_length=8
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        locate 24,23
        input "Press enter to continue", a$
        goto do_end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        locate 24,23
        input "Press enter to continue", a$
        goto do_end
end if


'now determine maxlen
device_descriptor_ptr = varptr32(inbuffer)
maxlen%=@device_descriptor_ptr.bMaxPacketSize

'full device descriptor
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0100
device_request.wIndex=0
device_request.wLength=&H12 '18 'hex 12

'set up device descriptor request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer)
  urb.buffer_off=varptr(inbuffer)
  urb.buffer_length=18
  urb.actual_length=maxlen%
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

device_descriptor_ptr = varptr32(inbuffer)

cls
print
print "Device Descriptor:"
print "Length:                " @device_descriptor_ptr.bLength
print "Descriptor type:       " @device_descriptor_ptr.bDescriptorType
print "USB specification nr.: " @device_descriptor_ptr.bcdUSB
print "Class code:            " @device_descriptor_ptr.bDeviceClass;
if @device_descriptor_ptr.bDeviceClass=0 then
 print "Class code specified by interface"
elseif @device_descriptor_ptr.bDeviceClass=1 then
 print "Audio device"
elseif @device_descriptor_ptr.bDeviceClass=2 then
 print "Modem device"
elseif @device_descriptor_ptr.bDeviceClass=3 then
 print "Human interface device - mouse, keyboard, etc."
elseif @device_descriptor_ptr.bDeviceClass=6 then
 print "Scanner / imaging device"
elseif @device_descriptor_ptr.bDeviceClass=7 then
 print "Printer"
elseif @device_descriptor_ptr.bDeviceClass=8 then
 print "Mass storage device"
elseif @device_descriptor_ptr.bDeviceClass=9 then
 print "Hub"
elseif @device_descriptor_ptr.bDeviceClass=&H0B then
 print "Chip/smart card interface device"
elseif @device_descriptor_ptr.bDeviceClass=&H0E then
 print "Video device"
elseif @device_descriptor_ptr.bDeviceClass=&HE0 then
 print "Bluetooth"
elseif @device_descriptor_ptr.bDeviceClass=255 then
 print "Vendor specified class code"
else
 print
end if
print "Subclass code:         " @device_descriptor_ptr.bDeviceSubClass
print "Protocol code:         " @device_descriptor_ptr.bDeviceProtocol
print "Max Packet size:       " @device_descriptor_ptr.bMaxPacketSize
print "Vendor ID:             " @device_descriptor_ptr.idVendor
print "Product ID:            " @device_descriptor_ptr.idProduct
print "Device release nr.:    " @device_descriptor_ptr.bcdDevice
print "Index of manufacturer: " @device_descriptor_ptr.iManufacturer
print "Index of product:      " @device_descriptor_ptr.iProduct
print "Index of serial nr.:   " @device_descriptor_ptr.iSerialNumber
print "Nr. of configurations: " @device_descriptor_ptr.bNumConfigurations

input "Press enter to continue", a$
print "Retrieving string descriptors..."

'don't care for unicode - shows text ok
'retrieve string descriptors
if @device_descriptor_ptr.iManufacturer > 0 then
device_request.bmRequestType=&H80
device_request.bRequest=&H06
device_request.wValue=&H0300 + @device_descriptor_ptr.iManufacturer
device_request.wIndex=&H0409
device_request.wLength=&HDF

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer2)
  urb.buffer_off=varptr(inbuffer2)
  urb.buffer_length=&HDF 'will do more in's than required - don't know how long
  urb.actual_length=maxlen
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "Manufacturer: ";
a%=ascii(mid$(inbuffer2,1,1))
print mid$(inbuffer2,3,a%)
end if

if @device_descriptor_ptr.iProduct > 0 then
'get string descriptor
device_request.bmRequestType=&H80
device_request.bRequest=&H06
device_request.wValue=&H0300 + @device_descriptor_ptr.iProduct
device_request.wIndex=&H0409
device_request.wLength=&HDF

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer2)
  urb.buffer_off=varptr(inbuffer2)
  urb.buffer_length=&HDF
  urb.actual_length=maxlen
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "Product: ";
a%=ascii(mid$(inbuffer2,1,1))
print mid$(inbuffer2,3,a%)
'input "Press enter to continue", a$
'cls
end if


if @device_descriptor_ptr.iSerialNumber > 0 then
device_request.bmRequestType=&H80
device_request.bRequest=&H06
device_request.wValue=&H0300 + @device_descriptor_ptr.iSerialNumber
device_request.wIndex=&H0409
device_request.wLength=&HDF

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer2)
  urb.buffer_off=varptr(inbuffer2)
  urb.buffer_length=&HDF
  urb.actual_length=maxlen
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "Serial number: ";
a%=ascii(mid$(inbuffer2,1,1))
print mid$(inbuffer2,3,a%)
end if

print
input "Press enter to continue", a$
print "Retrieving configuration descriptor..."

'determine length of configuration descriptor
'configuration descriptor
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0200
device_request.wIndex=0
device_request.wLength=&H08

'set up configuration descriptor request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer)
  urb.buffer_off=varptr(inbuffer)
  urb.buffer_length=8 'for configuration descriptor
  urb.actual_length=maxlen%
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

configuration_descriptor_ptr = varptr32(inbuffer)

conf_total_length = @configuration_descriptor_ptr.wTotalLength

'full configuration descriptor
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0200
device_request.wIndex=0
device_request.wLength=conf_total_length

'set up configuration descriptor request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer)
  urb.buffer_off=varptr(inbuffer)
  urb.buffer_length=conf_total_length 'for configuration descriptor
  urb.actual_length=maxlen%
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

configuration_descriptor_ptr = varptr32(inbuffer)

cls
print
print "Configuration Descriptor:"
print "Length:                   " @configuration_descriptor_ptr.bLength
print "Descriptor type:          " @configuration_descriptor_ptr.bDescriptorType
print "Total length:             " @configuration_descriptor_ptr.wTotalLength
print "Nr. of interfaces:        " @configuration_descriptor_ptr.bNumInterfaces
print "Nr. of this configuration:" @configuration_descriptor_ptr.bConfigurationValue
print "String descriptor index:  " @configuration_descriptor_ptr.iConfiguration
print "Attributes:               " @configuration_descriptor_ptr.bmAttributes;
a%= @configuration_descriptor_ptr.bmAttributes
if (a% and 128) >0 then print "Bus powered ";
if (a% and 64) >0 then print "Self powered ";
if (a% and 32) >0 then print "Remote Wakeup ";
print
print "Maximum power:            " @configuration_descriptor_ptr.bMaxPower "=" 2*@configuration_descriptor_ptr.bMaxPower "mA"

'print "Returned:" urb.actual_length

interface_descriptor_ptr = configuration_descriptor_ptr + @configuration_descriptor_ptr.bLength
j=1 'interface counter

while @interface_descriptor_ptr.bDescriptorType = 4
print
print "Interface Descriptor"+str$(j)+":"
print "Length:                   " @interface_descriptor_ptr.bLength
print "Descriptor type:          " @interface_descriptor_ptr.bDescriptorType
print "Interface nr.:            " @interface_descriptor_ptr.bInterfaceNumber
print "Alternate setting nr.:    " @interface_descriptor_ptr.bAlternateSetting
print "Nr of endpoints:          " @interface_descriptor_ptr.bNumEndpoints
print "Class code:               " @interface_descriptor_ptr.bInterfaceClass;
if @interface_descriptor_ptr.binterfaceClass=1 then
 print "Audio device"
elseif @interface_descriptor_ptr.binterfaceClass=2 then
 print "Modem device"
elseif @interface_descriptor_ptr.binterfaceClass=3 then
 print "Human interface device - mouse, keyboard, etc."
elseif @interface_descriptor_ptr.binterfaceClass=6 then
 print "Scanner / imaging device"
elseif @interface_descriptor_ptr.binterfaceClass=7 then
 print "Printer"
elseif @interface_descriptor_ptr.binterfaceClass=8 then
 print "Mass storage device"
elseif @interface_descriptor_ptr.binterfaceClass=9 then
 print "Hub"
elseif @interface_descriptor_ptr.binterfaceClass=&H0B then
 print "Chip/smart card interface device"
elseif @interface_descriptor_ptr.binterfaceClass=&H0E then
 print "Video device"
elseif @interface_descriptor_ptr.binterfaceClass=&HE0 then
 print "Bluetooth"
elseif @interface_descriptor_ptr.binterfaceClass=255 then
 print "Vendor specified class code"
else
 print
end if

print "Subclass code:            " @interface_descriptor_ptr.bInterfaceSubClass
print "Protocol code:            " @interface_descriptor_ptr.bInterfaceProtocol
print "String descriptor index:  " @interface_descriptor_ptr.iInterface

print
input "Press enter to continue", a$
cls
if @interface_descriptor_ptr.iInterface > 0 then
device_request.bmRequestType=&H80
device_request.bRequest=&H06
device_request.wValue=&H0300 + @interface_descriptor_ptr.iInterface
device_request.wIndex=&H0409
device_request.wLength=&H1FF

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer2)
  urb.buffer_off=varptr(inbuffer2)
  urb.buffer_length=&H1FF
  urb.actual_length=maxlen%
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "Interface: ";
a%=ascii(mid$(inbuffer2,1,1))
print mid$(inbuffer2,3,a%)
print
input "Press enter to continue", a$
cls
end if

endpoint_descriptor_ptr = interface_descriptor_ptr + @interface_descriptor_ptr.bLength

if @endpoint_descriptor_ptr.bDescriptorType = &H21 then
'jump over this descriptor
endpoint_descriptor_ptr = endpoint_descriptor_ptr + @endpoint_descriptor_ptr.bLength
end if

for i=1 to @interface_descriptor_ptr.bNumEndpoints

print
print "Endpoint Descriptor"+str$(i)+":"
print "Length:          " @endpoint_descriptor_ptr.bLength
print "Descriptor type: " @endpoint_descriptor_ptr.bDescriptorType
'print "Endpoint address:" hex$(@endpoint_descriptor_ptr.bEndpointAddress) "Hex"
a% = @endpoint_descriptor_ptr.bEndpointAddress
a%=a% and &H007F
print "Endpoint address:" a%;
if @endpoint_descriptor_ptr.bEndpointAddress > 127 then
	print "IN"
else
	print "OUT"
end if
print "Attributes:      " @endpoint_descriptor_ptr.bmAttributes;
a%=@endpoint_descriptor_ptr.bmAttributes
a%=a% and &H0003
if a%=0 then
print "Control"
elseif a%=1 then
print "Isochronous"
elseif a%=2 then
print "Bulk"
elseif a%=3 then
print "Interrupt"
end if
print "Max packet size: " @endpoint_descriptor_ptr.wMaxPacketSize
print "Polling interval:" @endpoint_descriptor_ptr.bInterval

endpoint_descriptor_ptr = endpoint_descriptor_ptr + @endpoint_descriptor_ptr.bLength

next i 'endpoint loop
input "Press enter to continue", a$
cls
interface_descriptor_ptr = endpoint_descriptor_ptr 'advanced above
incr j 'interface counter
wend   'interface loop

do_end:
color 7,0
cls

end

