defint a-z

' This file has no copyright assigned and is placed in the Public Domain

color 15,1 : cls
locate 14,20 : input "Please enter device address: ", devadd%

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

buffer$=repeat$(100,chr$(0)) 'return data here

'get interface - check current setting
device_request.bmRequestType=&H81
device_request.bRequest=10
device_request.wValue=0
device_request.wIndex=0
device_request.wLength=1

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=strptr(buffer$)
  urb.buffer_seg=strseg(buffer$)
  urb.buffer_length=1
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Illegal device address"
        end
end if

cls : locate 12,20
print "Alternate interface set to: " ascii(mid$(buffer$,1,1))
locate 14,10 : input "Please enter new alternate interface number: ", altint%

cls
locate 14,20 : print "Setting alternate interface..."

'set alternate interface
device_request.bmRequestType=&H01
device_request.bRequest=11
device_request.wValue=altint% 'set alternate number
device_request.wIndex=0
device_request.wLength=0

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=strptr(buffer$)
  urb.buffer_seg=strseg(buffer$)
  urb.buffer_length=0
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Illegal device address"
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        end
end if

'get interface - check if set successfully
device_request.bmRequestType=&H81
device_request.bRequest=10
device_request.wValue=0
device_request.wIndex=0
device_request.wLength=1

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=strptr(buffer$)
  urb.buffer_seg=strseg(buffer$)
  urb.buffer_length=1
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

cls : locate 14,20
print "Alternate interface set to: " ascii(mid$(buffer$,1,1))

end