' This file has no copyright assigned and is placed in the Public Domain
'
' This sample issues a restart to DosUSB which check for new and removed
' devices and enumerates all devices it could find. Some or all devices
' may get new addresses this way.
'
defint a-z

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

'set up request
  reg 1,8 'set ax to 8
  urb.transaction_token=&HFF
  urb.dev_add=1

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print : print

end
