' This file has no copyright assigned and is placed in the Public Domain
' This sample reads a sector of a memory card in a card reader using
' the bulk only protocol. It assumes the card to be in LUN number 1.

defint a-z

cls

input "Please enter sector number:" lbanumber$
lbanumber%=val(ltrim$(lbanumber$))

devadd%=1
in_endpoint%=1
out_endpoint%=2
slot%=1

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h)
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

type read_command  '31 byte
'first cbw fields  '15 byte
   signature      as dword
   tag            as dword
   tlength        as dword
   flags          as byte
   cbwlun         as byte
   clength        as byte
'now command fields '16 byte
   operation_code as byte
   lun            as byte
   lba            as dword
   reserved       as byte
   blocks         as word
   controls       as byte
   padding1       as word
   padding2       as word
   padding3       as word
end type

dim read_command_request as read_command

type inquiry_command  '31 byte
'first cbw fields  '15 byte
   signature      as dword
   tag            as dword
   tlength        as dword
   flags          as byte
   cbwlun         as byte
   clength        as byte
'now command fields '16 byte
   operation_code as byte
   lun            as byte
   lba            as dword
   reserved       as byte
   blocks         as word
   controls       as byte
   padding1       as word
   padding2       as word
   padding3       as word
end type

dim inquiry_command_request as read_command

dim buffer as string*64
buffer=repeat$(64,chr$(0)) 'return data here

dim sbuffer as string*1256
sbuffer=repeat$(1256,chr$(0)) 'return data here

'End of data structures ************************************************

$if 0 'set to 1 to include debug on
'set debug on
urb.transaction_token=&HFF
urb.dev_add=devadd%  'dosuhci checks valid address

reg 1,2 'ax=2
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65
$endif

'get max lun
device_request.bmRequestType=&HA1
device_request.bRequest=&HFE
device_request.wValue=&H0000
device_request.wIndex=&H0000
device_request.wLength=&H0001


'set up command request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=1
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        end
end if

print
print "Logical units:" ascii(left$(buffer,urb.actual_length))+1 'zero based!

'set up inquiry command incl. cbw
read_command_request.signature=&H43425355
read_command_request.tag=&H82A36008
read_command_request.tlength=&h24
read_command_request.flags=&h80
read_command_request.cbwlun=slot% '1
read_command_request.clength=&h0C '6
'now command fields
read_command_request.operation_code=&h12
read_command_request.lun=slot% '32 '=1
shift left read_command_request.lun,5
read_command_request.lba=&H240000
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=31
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

buffer=repeat$(100,chr$(0)) 'return data here

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "Inquiry:" left$(buffer,urb.actual_length)

'set up in request - to read CSW
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "CSW:" left$(buffer,urb.actual_length)

'set up request sense command incl. cbw
read_command_request.signature=&H43425355
read_command_request.tag=&H82A36008
read_command_request.tlength=&h12
read_command_request.flags=&h80
read_command_request.cbwlun=slot% '1
read_command_request.clength=&h0C
'now command fields
read_command_request.operation_code=&h03
read_command_request.lun=slot% '32 '=1
shift left read_command_request.lun,5
read_command_request.lba=&H120000
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=31
  urb.actual_length=31
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

buffer=repeat$(100,chr$(0)) 'return data here

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "Request sense:" left$(buffer,urb.actual_length)

'set up in request - to read CSW
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "CSW:" left$(buffer,urb.actual_length)

'set up test unit ready command incl. cbw
read_command_request.signature=&H43425355
read_command_request.tag=&H82A36008
read_command_request.tlength=&h0
read_command_request.flags=&h0
read_command_request.cbwlun=slot% '1
read_command_request.clength=&h0C
'now command fields
read_command_request.operation_code=&h00
read_command_request.lun=slot% '32 '=1
shift left read_command_request.lun,5
read_command_request.lba=&H000000
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=31
  urb.actual_length=31
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

buffer=repeat$(100,chr$(0)) 'return data here

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "Test unit ready:" left$(buffer,urb.actual_length)

'******************************************************

gosub do_read

if urb.error_code >0 then
        cls : locate 14,23
	print "Buffer length exceeded"
        end
end if

print
print "Sector:" left$(sbuffer,512) 'urb.actual_length)

'set up in request - to read CSW
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "CSW:" left$(buffer,urb.actual_length)
print "status:" urb.status


end

do_read:  'needs lbanumber%
'set up bulk read command incl. cbw
read_command_request.signature=&H43425355
read_command_request.tag=&H82A36008
read_command_request.tlength=&h200 '512 byte
read_command_request.flags=&h80
read_command_request.cbwlun=slot%
read_command_request.clength=&h0C 'A
'now command fields
read_command_request.operation_code=&h28

read_command_request.lun=slot% '32 '=1
shift left read_command_request.lun,5
read_command_request.lba=lbanumber% '0
rotate right read_command_request.lba,8 'works up to lba FFh - big endian
'print "LBA:" hex$(read_command_request.lba) " ";
read_command_request.reserved=0
read_command_request.blocks=&H01 '00 'big endian
rotate right read_command_request.blocks,8
'print "Blocks:" hex$(read_command_request.blocks)

read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

mid$(buffer,1,64)=read_command_request

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=31
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

buffer=repeat$(64,chr$(0)) 'return data here

i=0
while i<8 'leave if 8 ( 8*64=512 )

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

if urb.status=0 then
	incr i
        midpos=1+(i-1)*64
        mid$(sbuffer,midpos)=buffer
elseif urb.status<>88 then
	exit loop
end if
'do not incr if 88

wend

return