defint a-z

' This file has no copyright assigned and is placed in the Public Domain

print
print "Device addresses defined by DOSUSB"
print

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved - int
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

type device_descriptor_type
   bLength		as byte
   bDescriptorType	as byte
   bcdUSB		as word
   bDeviceClass		as byte
   bDeviceSubClass	as byte
   bDeviceProtocol	as byte
   bMaxPacketSize	as byte
   idVendor		as word
   idProduct		as word
   bcdDevice		as word
   iManufacturer	as byte
   iProduct		as byte
   iSerialNumber	as byte
   bNumConfigurations	as byte
end type

dim device_descriptor_ptr as device_descriptor_type ptr

dim inbuffer as string*2048
dim inbuffer2 as string*2048

for devadd%=1 to 198

inbuffer=repeat$(1024,chr$(0)) 'return data here
inbuffer2=repeat$(1024,chr$(0)) 'return data here as well

'do 8 byte device_descriptor to determine maxlen of packet
'device descriptor
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0100
device_request.wIndex=0
device_request.wLength=&H08

'set up device descriptor request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(inbuffer)
  urb.buffer_seg=varseg(inbuffer)
  urb.buffer_length=8
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        goto end_loop
end if

'transaction error?
if urb.status >1 then
        goto end_loop
end if

'now determine maxlen
device_descriptor_ptr = varptr32(inbuffer)
maxlen%=@device_descriptor_ptr.bMaxPacketSize

'full device descriptor to see if string descriptors present
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0100
device_request.wIndex=0
device_request.wLength=&H12 '18 'hex 12

'set up device descriptor request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer)
  urb.buffer_off=varptr(inbuffer)
  urb.buffer_length=18
  urb.actual_length=maxlen%
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

device_descriptor_ptr = varptr32(inbuffer)

'don't care for unicode - shows text ok
'retrieve string descriptors

print "Device address: " devadd% ,

if @device_descriptor_ptr.iProduct > 0 then
'get string descriptor
device_request.bmRequestType=&H80
device_request.bRequest=&H06
device_request.wValue=&H0300 + @device_descriptor_ptr.iProduct
device_request.wIndex=&H0409
device_request.wLength=&HDF

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=varseg(inbuffer2)
  urb.buffer_off=varptr(inbuffer2)
  urb.buffer_length=&HDF
  urb.actual_length=maxlen
  urb.setup_buffer_seg=varseg(device_request)
  urb.setup_buffer_off=varptr(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print "Product: ";
a%=ascii(mid$(inbuffer2,1,1))
print mid$(inbuffer2,3,a%)
end if

end_loop:

next devadd%

end

