' This file has no copyright assigned and is placed in the Public Domain
' This demo reads keys from a USB keyboard
'
defint a-z

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h)
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'indicate iso
  int_interval    as byte  'int
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

buffer$=repeat$(64,chr$(0))   'return data here

color 15,1 : cls
locate 14,20 : input "Please enter device address: ", devadd%
cls
locate 1,1 : print "Showing key codes sent by the keyboard - 0 if key is released"
print "Press press any key - ESC to stop program"

while instr(buffer$,chr$(&H29))=0 'ESC
'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=1
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=strptr(buffer$)
  urb.buffer_seg=strseg(buffer$)
  urb.buffer_length=8
  urb.actual_length=8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=4 '10 'should read from device descriptor
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

if urb.actual_length >0 then
k1%=ascii(mid$(buffer$,1,1))
k2%=ascii(mid$(buffer$,2,1))
k3%=ascii(mid$(buffer$,3,1))

print hex$(k3%) " ";
end if

wend

end

