' This file has no copyright assigned and is placed in the Public Domain
' icheck = installation check
' call dosuhci with ax=6 and transaction_token=0FFh to query if installed
'
defint a-z

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

'set up request
  reg 1,6 'set ax to 6
  'reg 1,4 'have dosuhci print the URB received
  urb.transaction_token=&HFF
  'urb.dev_add=1

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
if urb.transaction_token=&H47 then
	print "DosUHCI installed"
elseif urb.transaction_token=&HFF then
	print "DosUHCI not installed"
else
	print "Error"
end if


end