' This file has no copyright assigned and is placed in the Public Domain
' This sample prints the DosUSB.TXT document to a HP Laserprinter in text
' mode. There are some PCL commands before and after the text output.
' This was tested with a HP 2420d printer.
'
defint a-z

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte  'does another urb follow this urb in memory?
                           'zero=no,one=yes
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long
dim urb as urbtype

dev_add%=1
in_endpoint%=1
out_endpoint%=2

dim buffer  as string*1024
buffer=repeat$(1024,chr$(0))

'Reset printer
b$=chr$(27)+"E"+chr$(13)+chr$(10)
'Enable end of line wrap
b$=b$+chr$(27)+"&s0C"+chr$(13)+chr$(10)
'select PC-8 symbol set
b$=b$+chr$(27)+"(10U"+chr$(13)+chr$(10)
'select 10 pitch, 12 point, upright medium, courier font
b$=b$+chr$(27)+"(s0p10h12v0s0b3T"+chr$(13)+chr$(10)
mid$(buffer,1)=b$
packetlen%=len(b$)
gosub do_out

open "dosusb.txt" for binary as #1
jmax%=lof(1)
get$ #1,lof(1),b$
close #1

jmax%=jmax%\64 +1
for j=0 to jmax%
   a$=mid$(b$,1+j*64,64)
   buffer=repeat$(1024,chr$(0))
   mid$(buffer,1)=a$
   packetlen%=64
   gosub do_out
next j

buffer=repeat$(1024,chr$(0))
'Reset and eject page
b$=chr$(27)+"E"+chr$(13)+chr$(10)
mid$(buffer,1)=b$
packetlen%=4
gosub do_out

end

do_out:  'public subroutine

for i_out=1 to 4  'retry four times

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=dev_add%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=packetlen%
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

if usb.status <> &H88 then exit 'for

next i_out

return
