' This file has no copyright assigned and is placed in the Public Domain
' This sample reads sector zero of a USB floppy drive using the CBI protocol.
'
defint a-z

cls
print "Reading floppy sector ..."
devadd%=2
in_endpoint%=1
out_endpoint%=2
int_endpoint%=3

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h)
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by DOSUSB
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

type read_command '16 byte
   operation_code as byte '0
   lun            as byte '1
   lba            as dword'2-5
   reserved       as byte
   blocks         as word
   controls       as byte
   padding1       as word
   padding2       as word
   padding3       as word
end type

dim read_command_request as read_command

dim buffer as string*1256
buffer=repeat$(1256,chr$(0)) 'return data here

'End of data structures ************************************************

print "inquiry"
gosub do_inquiry

print "request_sense"
gosub do_request_sense 'clear attention condition

print "test unit ready"
gosub do_test_unit

print "start motor"
gosub do_start_motor 'avoid lots of NAKs on following read

print "read sector"
lbanumber%=0
gosub do_read  'read sector

while mid$(buffer,1,2) <> chr$(0)+chr$(0) 'if not successful
        print "Trying again"
        gosub do_request_sense 'clear attention condition
	gosub do_read 'retry
wend

end

'*************************************************************************
'subroutines start here
'*************************************************************************

exec_command:
'do ADSC
device_request.bmRequestType=&H21
device_request.bRequest=&H00
device_request.wValue=&H0000
device_request.wIndex=&H0000
device_request.wLength=&H000C

'set up command request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=0
  urb.buffer_seg=0
  urb.buffer_length=0
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        end
end if

'now send command using two out's

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=8
  urb.actual_length=8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DOSUSB
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'second out now
mid$(buffer,1,50)=mid$(read_command_request,9,4)

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=4
  urb.actual_length=8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DOSUSB
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

buffer=repeat$(100,chr$(0)) 'return data here

'set up in request to read acknowledge
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=8
  urb.actual_length=8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DOSUSB
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

delay 0.8 'floppies are slow!

if getbytes% > -1 then 'no in request if getbytes% = -1

'nr_of_runs%=getbytes% / 64

'for i_nr%=1 to nr_of_runs%

'set up in request - to read data
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=getbytes% '64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DOSUSB
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "Data:" left$(buffer,urb.actual_length)
'for ix=1 to 75
' print hex$(ascii(mid$(buffer,ix,1))) " ";
'next ix
print

'next i_nr%

end if 'getbytes%=-1

gosub check_interrupt

return
'************************************************************+
do_inquiry:
'set up inquiry command
read_command_request.operation_code=&h12
read_command_request.lun=0
read_command_request.lba=&H240000
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

getbytes%=64
gosub exec_command
return
'************************************************************+
do_request_sense:
'set up request sense command
read_command_request.operation_code=&H03
read_command_request.lun=0
read_command_request.lba=&H00240000
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

getbytes%=64
gosub exec_command
return
'************************************************************+
do_mode_sense:
'set up mode sense command
read_command_request.operation_code=&h5A
read_command_request.lun=0
read_command_request.lba=&H3F
read_command_request.reserved=0
read_command_request.blocks=&H4800
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

mid$(buffer,1,16)=read_command_request

getbytes%=64
gosub exec_command
return
'************************************************************+
do_read_capacity:
'set up read capacity command
read_command_request.operation_code=&h25
read_command_request.lun=0
read_command_request.lba=0
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

getbytes%=64
gosub exec_command
return
'************************************************************+
do_start_motor:
'set up start unit command
read_command_request.operation_code=&h1B
read_command_request.lun=0
read_command_request.lba=&H00010000 'set bit in byte 4
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

getbytes%=-1
gosub exec_command
return

'************************************************************+
do_test_unit:
'set up test unit ready command
read_command_request.operation_code=0
read_command_request.lun=0
read_command_request.lba=0
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

getbytes%=-1
gosub exec_command
return
'************************************************************+
check_interrupt:

buffer=repeat$(100,chr$(0)) 'return data here

do

'set up in request to read acknowledge
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=int_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=8
  urb.actual_length=8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DOSUSB
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

if urb.status<>0 then
   if urb.status=&H88 then
   	print "Return code: NAK";
   else
        print "Return code:" hex$(urb.status);
   end if
	incr icounter%
        if icounter% > 4 then exit loop
else
	exit loop
end if

loop

return

'************************************************************+
do_read:
'set up read command
read_command_request.operation_code=&h28
read_command_request.lun=0
rotate right lbanumber%,8 'convert to big endian
read_command_request.lba=lbanumber%
'now move to high of dword - assume floppy has max 32.000 sectors (16 MB)
shift left read_command_request.lba,16
read_command_request.reserved=0
read_command_request.blocks=1 '&H0100 'msb/lsb - big endian here
rotate right read_command_request.blocks,8 'convert to big endian
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

getbytes%=512 'retrieve 512 byte sector
gosub exec_command

return
