' This file has no copyright assigned and is placed in the Public Domain
' This sample sets buffer_off/seg to zero to do all transactions whithin this
' program. If buffer_off/seg would be specified, only one control transaction
' had to be scheduled instead.
' The first control transaction requests 18 bytes of the device descriptor.
' If the device is e.g. a mouse, it will have a MaxLen of 8 on endpoint zero.
' Therefore following the control transaction, there need to be 3 IN
' transactions to retrieve the 18 bytes. Then the data is acknowledged with
' an zero OUT transaction.
' This program schedules one or more IN transactions depending on MaxLen to
' retrieve the descriptor of the device.
'
defint a-z

cls

devadd%=1

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

type device_descriptor_type
   bLength		as byte
   bDescriptorType	as byte
   bcdUSB		as word
   bDeviceClass		as byte
   bDeviceSubClass	as byte
   bDeviceProtocol	as byte
   bMaxPacketSize	as byte
   idVendor		as word
   idProduct		as word
   bcdDevice		as word
   iManufacturer	as byte
   iProduct		as byte
   iSerialNumber	as byte
   bNumConfigurations	as byte
end type

dim device_descriptor_ptr as device_descriptor_type ptr

dim buffer as string*256
buffer=repeat$(100,chr$(0)) 'return data here


$if 0 'set to 1 to include debug on
'set debug on
urb.transaction_token=&HFF
urb.dev_add=devadd%  'dosuhci checks valid address

reg 1,2 'ax=2
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65
$endif

'do device_descriptor to determine maxlen of packet
'device descriptor
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0100
device_request.wIndex=0
device_request.wLength=&H12

'set up device descriptor request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=0 'varptr(buffer)
  urb.buffer_seg=0 'varseg(buffer)
  urb.buffer_length=8
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        end
end if

repeat_in:
'set up in request to read descriptor
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64 '8
  urb.actual_length=64 '8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

if urb.status<>0 then
   if urb.status=&H88 then
   	print "Return code: NAK";
   else
        print "Return code:" hex$(urb.status);
   end if
end if

'collect in totalbuffer$ in case multiple INs needed
totalbuffer$=totalbuffer$+left$(buffer,urb.actual_length)
total_length=total_length+urb.actual_length
if total_length < 18 then goto repeat_in

buffer=totalbuffer$
urb.actual_length=total_length

'now determine maxlen
device_descriptor_ptr = varptr32(buffer)
maxlen%=@device_descriptor_ptr.bMaxPacketSize
print
print "MaxLen :" maxlen%
print

print "Buffer:" left$(buffer,urb.actual_length)
print
print "Buffer in hex: ";
for i=1 to urb.actual_length
print hex$(ascii(mid$(buffer,i,1))) " ";
next i

'set up out request to acknowledge IN packet
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=0
  urb.actual_length=0
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

end

