' This file has no copyright assigned and is placed in the Public Domain
' This sample reads a sector of a USB memory stick
' using the bulk only protocol.

defint a-z

color 15,1 : cls
locate 12,20 : input "Please enter device address: ", devadd%
locate 14,20 : print "Use USBVIEW to determine these endpoints:"
locate 16,20 : input "Please enter bulk IN  endpoint : ", in_endpoint%
locate 18,20 : input "Please enter bulk OUT endpoint: ", out_endpoint%

do_it_again:

cls

print "Note: Diskspy reads the physical sector number disregarding partitions"
input "Please enter sector number:", lbanumber$
lbanumber???=val(ltrim$(lbanumber$))

'devadd%=1
'in_endpoint%=1
'out_endpoint%=1

lbanumberlo??=0
lbanumberhi??=0

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h)
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

type read_command  '31 byte
'first cbw fields  '15 byte
   signature      as dword
   tag            as dword
   tlength        as dword
   flags          as byte
   cbwlun         as byte
   clength        as byte
'now command fields '16 byte
   operation_code as byte
   lun            as byte
   lbahi          as word 'bytes 2+3 (zero based)
   lbalo          as word 'bytes 4+5 (zero based)
   reserved       as byte
   blocks         as word
   controls       as byte
   padding1       as word
   padding2       as word
   padding3       as word
end type

dim read_command_request as read_command


type inquiry_command  '31 byte
'first cbw fields  '15 byte
   signature      as dword
   tag            as dword
   tlength        as dword
   flags          as byte
   cbwlun         as byte
   clength        as byte
'now command fields '16 byte
   operation_code as byte
   lun            as byte
   lba            as dword
   reserved       as byte
   blocks         as word
   controls       as byte
   padding1       as word
   padding2       as word
   padding3       as word
end type

dim inquiry_command_request as read_command

dim buffer as string*64
buffer=repeat$(64,chr$(0)) 'return data here

dim sbuffer as string*1256
sbuffer=repeat$(1256,chr$(0)) 'return data here

'End of data structures ************************************************

'goto testmarke
$if 0
'get max lun
device_request.bmRequestType=&HA1
device_request.bRequest=&HFE
device_request.wValue=&H0000
device_request.wIndex=&H0000
device_request.wLength=&H0001


'set up command request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=1
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        end
end if

'has device changed?
if urb.error_code=5 then
        cls : locate 14,23
	print "Device has been removed"
        end
end if

'has device changed?
if urb.error_code>0 then
        cls : locate 14,23
	print "Error " urb.error_code
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        end
end if

'print
'print "Logical units:" left$(buffer,urb.actual_length)
$endif

testmarke:
'set up inquiry command incl. cbw
read_command_request.signature=&H43425355
read_command_request.tag=&H82A36008
read_command_request.tlength=&h24
read_command_request.flags=&h80
read_command_request.cbwlun=0 '1
read_command_request.clength=&h0C '6
'now command fields
read_command_request.operation_code=&h12
read_command_request.lun=0 '32 '=1
read_command_request.lbahi=0
read_command_request.lbalo=&H24 'allocation length in byte 4
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=31
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'transaction error?
if urb.status >1 then
	print "URB Status 1: " hex$(urb.status)
end if



buffer=repeat$(64,chr$(0)) 'return data here

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=31
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'transaction error?
if urb.status >1 then
	print "URB Status 2: " hex$(urb.status)
end if

'print
'print "Inquiry:" left$(buffer,urb.actual_length)

retry3:

'set up in request - to read CSW
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=13
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'transaction error?
if urb.status >1 then
	print "URB Status 3: " hex$(urb.status)
        'goto retry3
end if


'print
'print "CSW:" left$(buffer,urb.actual_length)

'******************************************************
'set up request sense command incl. cbw
read_command_request.signature=&H43425355
read_command_request.tag=&H82A36008
read_command_request.tlength=&h12
read_command_request.flags=&h80
read_command_request.cbwlun=0 '1
read_command_request.clength=&h0C
'now command fields
read_command_request.operation_code=&h03
read_command_request.lun=0 '32 '=1
read_command_request.lbahi=0
read_command_request.lbalo=&H12 'allocation length in byte 4
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=31
  urb.actual_length=31
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

buffer=repeat$(64,chr$(0)) 'return data here

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'print
'print "Request sense:" left$(buffer,urb.actual_length)

'set up in request - to read CSW
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'print
'print "CSW:" left$(buffer,urb.actual_length)


'******************************************************
'set up test unit ready command incl. cbw
read_command_request.signature=&H43425355
read_command_request.tag=&H82A36008
read_command_request.tlength=&h0
read_command_request.flags=&h0
read_command_request.cbwlun=0 '1
read_command_request.clength=&h0C
'now command fields
read_command_request.operation_code=&h00
read_command_request.lun=0 '32 '=1
read_command_request.lbahi=0
read_command_request.lbalo=0
read_command_request.reserved=0
read_command_request.blocks=0
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

buffer=read_command_request

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=31
  urb.actual_length=31
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

buffer=repeat$(64,chr$(0)) 'return data here

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'print
'print "Test unit ready:" left$(buffer,urb.actual_length)

'set up in request - to read CSW
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'print
'print "CSW:" left$(buffer,urb.actual_length)
'******************************************************

'lbanumber???=0

gosub do_read

if urb.error_code >0 then
        cls : locate 14,23
	print "Buffer length exceeded"
        end
end if

cls
print
print "Sector "+lbanumber$+": "
print "      0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F"

for k=0 to 31
a$="000"+ltrim$(hex$(k))+"0 "
if len(a$)=7 then a$=mid$(a$,2)
print a$;
for i=1 to 16
	position%=k*16+i
	a$=ltrim$(hex$(ascii(mid$(sbuffer,position%,1))) )
        if len(a$)=1 then a$="0"+a$
        print a$ " " ;
next i
print mid$(sbuffer,k*16+1,16)
if k=22 then print "Press any key to continue.."; : junk$=input$(1) : print
next k

$if 0
if lbanumber???=0 then
for i=&H1BD to 512 'urb.actual_length
print hex$(ascii(mid$(sbuffer,i,1))) " ";
if (i-&H1BD) mod 16 = 0 then print
next i
else
for i=1 to 128 'urb.actual_length
print hex$(i-1) "-" hex$(ascii(mid$(sbuffer,i,1))) " ";
next i
end if
$endif


'set up in request - to read CSW
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'print
'print "CSW:" left$(buffer,urb.actual_length)

buffer=repeat$(64,chr$(0)) 'return data here
input ; "Read another sector Y/N" a$
if ucase$(a$)="Y" then goto do_it_again

end

'**********************************************************
do_read:  'needs lbanumber???
'set up bulk read command incl. cbw
read_command_request.signature=&H43425355
read_command_request.tag=&H82A36008
read_command_request.tlength=&h200 '512 byte
read_command_request.flags=&h80
read_command_request.cbwlun=0 '1
read_command_request.clength=&h0C 'A
'now command fields
read_command_request.operation_code=&h28
read_command_request.lun=0 '32 '=1
'convert lbanumber??? to big endian
lbanumberlo??=lbanumber??? AND &H0000FFFF
rotate right lbanumberlo??,8
shift right lbanumber???,16
lbanumberhi??=lbanumber???
rotate right lbanumberhi??,8
read_command_request.lbalo=lbanumberlo?? '0
read_command_request.lbahi=lbanumberhi?? '0
'print "LBAhi:" hex$(read_command_request.lbahi) " ";
'print "LBAlo:" hex$(read_command_request.lbalo) " ";
read_command_request.reserved=0
read_command_request.blocks=&H01 '00 'big endian
rotate right read_command_request.blocks,8
'print "Blocks:" hex$(read_command_request.blocks)
read_command_request.controls=0
read_command_request.padding1=0
read_command_request.padding2=0
read_command_request.padding3=0

mid$(buffer,1,64)=read_command_request

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=31
  urb.actual_length=31
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'has device changed?
if urb.error_code=5 then
        cls : locate 14,23
	print "Device has been removed"
        end
end if

buffer=repeat$(64,chr$(0)) 'return data here

i=0
while i<8 'leave if 8 ( 8*64=512 )

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

if urb.status=0 then
	incr i
        midpos=1+(i-1)*64
        mid$(sbuffer,midpos)=buffer
elseif urb.status<>&H88 then
	exit loop
end if
'do not incr if 88

wend

return
