' This file has no copyright assigned and is placed in the Public Domain
'
' This sample reads 32 isochronous packets from a Trust 120 Spacecam.
' There is no documentation available as far as I am aware, so the
' commands are copied from a line trace to start the ISO traffic.
' Assuming that 32*1024 bytes gives a frame of the camera, this data
' is stored in the file camera.yuv.
'
' The objective of this is to test isochronous traffic with DosUHCI.com
'
' Use DosUHCI with the /D option
'
defint a-z

cls

devadd%=1
in_endpoint%=1
out_endpoint%=0
int_endpoint%=3

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h)
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype
   bmRequestType  as byte
   bRequest	  as byte
   wValue	  as word
   wIndex         as word
   wLength        as word
end type

dim device_request as setuptype

'now dimension device request for out commands
dim devicerequest as string*8

dim buffer as string*1024

buffer=repeat$(1024,chr$(0)) 'return data here

dim image$(34)

'set alternate interface first
device_request.bmRequestType=&H01
device_request.bRequest=11
device_request.wValue=8 'set alternate number
device_request.wIndex=0
device_request.wLength=0

'set up request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=0
  urb.actual_length=8
  urb.setup_buffer_off=varptr(device_request)
  urb.setup_buffer_seg=varseg(device_request)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Illegal device address"
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        end
end if

'now configure the camera
for j=1 to 25 'read the 25 data statements with the traced commands

for i=1 to 8  'read setup packet first
read b$
mid$(devicerequest,i,1)=chr$(val("&H"+b$))
next i

payloadlength%=ascii(mid$(devicerequest,7,1))

for i=1 to payloadlength% 'send the command via OUT to endpoint zero
read b$
mid$(buffer,i,1)=chr$(val("&H"+b$))
next i

gosub exec_command

next j

print "Reading ISO packets: ";
for k=1 to 32
 gosub do_iso_in
 print k;
 image$(k)=left$(buffer,urb.actual_length)
next k

open "image.yuv" for output as #1
for k=1 to 32
  print #1, image$(k);
next k
close #1

end

'****************************************************************
'subroutines
'****************************************************************
do_iso_in:

buffer=repeat$(1024,chr$(0)) 'return data here

'set up in request - iso
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=1 '0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=1023
  urb.actual_length=1023
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=1
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

return

'send command with this subroutine
exec_command:

'set up command request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=0  'just setup
  urb.buffer_seg=0
  urb.buffer_length=0
  urb.actual_length=64 '8
  urb.setup_buffer_off=varptr(devicerequest)
  urb.setup_buffer_seg=varseg(devicerequest)
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        end
end if

'now send command using out - send multiple out's if required

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=payloadlength%
  urb.actual_length=64 '8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

buffer=repeat$(100,chr$(0)) 'return data here

'set up in request to read acknowledge
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64 '8
  urb.actual_length=64 '8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
'call interrupt &H65

'gosub check_interrupt

return
'these two subroutines are not used in this sample
set_toggle_to_zero:
 urb.transaction_token=&HFF
 urb.dev_add=devadd%
 urb.end_point=in_endpoint%
 'now call DosUHCI
 reg 1,&H05
 reg 8,varseg(urb)
 reg 4,varptr(urb)
 call interrupt &H65
return

check_interrupt:

buffer=repeat$(100,chr$(0)) 'return data here
do
'set up in request to read acknowledge
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=int_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=8
  urb.actual_length=8
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

if urb.status<>0 then
   if urb.status=&H88 then
   	print "Return code: NAK";
   else
        print "Return code:" hex$(urb.status);
   end if
	incr icounter%
        if icounter% > 4 then exit loop
else
	exit loop
end if

loop

return

'read from trace
'the first 8 bytes are the setup packet,
'byte 7 contains the number of bytes to send using out
'these bytes follow the eight setup bytes in each data statement
DATA 41,08,01,00,00,00,01,00,04
DATA 41,08,17,00,00,00,01,00,20
DATA 41,08,01,00,00,00,1F,00,44,03,00,00,00,00,00,80,40,00,00,00,00,00,00,00,00,04,03,0A,16,12,28,89,20,00,00,00,00,00,00
DATA 41,08,08,00,00,00,08,00,C0,40,02,02,13,06,00,10
DATA 41,08,08,00,00,00,08,00,D0,40,05,00,00,01,20,10
DATA 41,08,08,00,00,00,08,00,D0,40,09,03,00,00,06,10
DATA 41,08,08,00,00,00,08,00,B0,40,0D,00,04,00,06,10
DATA 41,08,08,00,00,00,08,00,A0,40,14,02,04,00,06,10
DATA 41,08,08,00,00,00,08,00,D0,40,10,06,06,06,01,10
DATA 41,08,01,00,00,00,01,00,44
DATA 41,08,17,00,00,00,03,00,28,89,20
DATA 41,08,1C,00,00,00,04,00,01,01,07,06
DATA 41,08,15,00,00,00,02,00,14,0F
DATA 41,08,18,00,00,00,01,00,89
DATA 41,08,01,00,00,00,01,00,44
DATA 41,08,08,00,00,00,08,00,A0,40,02,02,06,06,01,16
DATA 41,08,08,00,00,00,08,00,B0,40,03,12,05,06,01,16
DATA 41,08,08,00,00,00,08,00,A0,40,08,20,05,06,01,16
DATA 41,08,08,00,00,00,08,00,C0,40,05,92,00,81,01,16
DATA 41,08,08,00,00,00,08,00,A0,40,13,01,00,81,01,16
DATA 41,08,08,00,00,00,08,00,A0,40,0E,04,00,81,01,15
DATA 41,08,08,00,00,00,08,00,A0,40,13,01,00,81,01,15
DATA 41,08,08,00,00,00,08,00,A0,40,13,01,00,81,01,15
DATA 41,08,01,00,00,00,01,00,44
DATA 41,08,17,00,00,00,03,00,28,89,20


