' This file has no copyright assigned and is placed in the Public Domain
'
' This sample does a data transfer via a USB connect cable, which is
' designed to enable a file transfer between two PC's.
' Such a cable has a circuit in the middle which consists of two devices,
' one for each side of the cable. When you send data to one device it will
' output the data at the other device.
' This sample assumes the cable is put with both plugs into the first USB
' ports of one PC so you get address one and two.
' Then the sample will send the text DOSUHCI to address one and read this
' from the other address.
'
defint a-z

cls

outdevadd%=1
indevadd%=2
in_endpoint%=3
out_endpoint%=2

'define structure of URB
type urbtype
  transaction_token as byte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as byte
  dev_add         as byte
  end_point       as byte
  error_code      as byte
  status          as byte  'returned by dosuhci
  transaction_flags as word 'reserved
  buffer_off      as word  'for in/out
  buffer_seg      as word  'for in/out
  buffer_length   as word  'for in/out
  actual_length   as word  'for in/out
  setup_buffer_off as word 'for control
  setup_buffer_seg as word 'for control
  start_frame     as word  'reserved
  nr_of_packets   as word  'reserved - iso
  int_interval    as byte  'reserved
  error_count     as byte  'reserved
  timeout         as word  'reserved
  next_urb_off    as word  'reserved
  next_urb_seg    as word  'reserved
end type '32 byte long

dim urb as urbtype

dim buffer as string*1025
buffer=repeat$(1025,chr$(0)) 'return data here

for i=1 to 12

mid$(buffer,1,64)=repeat$(8,"DOSUHCI ")

'set up out request
  urb.transaction_token=&HE1
  urb.chain_end_flag=0
  urb.dev_add=outdevadd%
  urb.end_point=out_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65


'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        end
end if

buffer=repeat$(1025,chr$(0)) 'return data here

'set up in request
  urb.transaction_token=&H69
  urb.chain_end_flag=0
  urb.dev_add=indevadd%
  urb.end_point=in_endpoint%
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_off=varptr(buffer)
  urb.buffer_seg=varseg(buffer)
  urb.buffer_length=64 '128 '32 '16
  urb.actual_length=64
  urb.setup_buffer_off=0
  urb.setup_buffer_seg=0
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_off=0
  urb.next_urb_seg=0

'now call DosUHCI
reg 8,varseg(urb)
reg 4,varptr(urb)
call interrupt &H65

print
print "Buffer:" left$(buffer,64)

next i

end
