Program reset (output);

{ This file has no copyright assigned and is placed in the Public Domain }

{ This sample issues a reset to DosUSB for device "dev_add". Since new
  devices will not be enumerated, all device addresses are unchanged. }

Uses
   dos;  {defines "registers" type & "intr" call}

Const
   control_token = $2D;
   in_token = $69;
   out_token = $E1;
   command_token = $FF;

Type
   URB_type =
      packed record
         transaction_token : byte; {see token values above}
         chain_end_flag  : byte; {1 = another URB follows this one in memory}
         dev_add         : byte;
         end_point       : byte;
         error_code      : byte;
         status          : byte; {returned by dosuhci}
         transaction_flags : word; {reserved}
         buffer_off      : word; {for in/out}
         buffer_seg      : word; {for in/out}
         buffer_length   : word; {for in/out}
         actual_length   : word; {for in/out}
         setup_buffer_off : word; {for control}
         setup_buffer_seg : word; {for control}
         start_frame     : word; {reserved}
         nr_of_packets   : word; {reserved - iso}
         int_interval    : byte; {reserved}
         error_count     : byte; {reserved}
         timeout         : word; {reserved}
         next_urb_off    : word; {reserved}
         next_urb_seg    : word; {reserved}
      end; {record, 32 bytes long}

Var
   urb : URB_type;
   regs : registers;

Begin {reset}
   {set up request}
   regs.AX := 1; {reset command}
   urb.transaction_token := command_token;
   urb.dev_add := 0; {device number, 0 = all}

   {now call DosUHCI}
   regs.DS := seg(urb);
   regs.DX := ofs(urb);
   intr($65, regs);

   writeln;
End. {reset}
