{$i-}
Program HPLASER;
(*
  This file has no copyright assigned and is placed in the Public Domain

  This sample prints the DosUHCI.TXT document to a HP Laserprinter in text
  mode. There are some PCL commands before and after the text output.
  The text output has to be terminated with a packet full of NULL characters.
  This was tested with a HP 2420d printer.

  *********************************************************
  * The translation to PASCAL was done by Michel LECLERC! *
  *********************************************************

  Made just some minor changes to his code. Georg Potthast
*)

Uses DOS;

Const
 the_dev_add = 1;
 in_endpoint = 1;
 out_endpoint = 2;
 myFN = 'dosuhci.txt';


Type

 (* define structure of URB *)
 urbtype = Record
  transaction_token : byte (* control (2Dh), in (69h), out (E1h) as hex code *);
  chain_end_flag    : byte (* does another urb follow this urb in memory ?
                              zero=no,one=yes *);
  dev_add           : byte;
  end_point         : byte;
  error_code        : byte;
  status            : byte (* returned by dosuhci *);
  transaction_flags : word (* reserved *);
  buffer_off        : word (* for in/out *);
  buffer_seg        : word (* for in/out *);
  buffer_length     : word (* for in/out *);
  actual_length     : word (* for in/out *);
  setup_buffer_off  : word (* for control *);
  setup_buffer_seg  : word (* for control *);
  start_frame       : word (* reserved *);
  nr_of_packets     : word (* iso *);
  int_interval      : byte (* reserved *);
  error_count       : byte (* reserved *);
  timeout           : word (* reserved *);
  next_urb_off      : word (* reserved *);
  next_urb_seg      : word (* reserved *);
end (* 32 byte long *);

Var
 urb: urbtype;
 buffer: Array[0..1024-1] Of Byte;
 packetlen: Word;
 bStr: String;
 f: File;
 ReqNr: Word;

Procedure do_out;  (* public subroutine *)

Var
 Reg: Registers;

Begin

 WriteLn('Before request nr.:', ReqNr:4, '  packetlen: ', packetlen);

 (* set up out request *)
 urb.transaction_token := $E1;
 urb.chain_end_flag := 0;
 urb.dev_add := the_dev_add;
 urb.end_point := out_endpoint;
 urb.error_code := 0;
 urb.status := 0;
 urb.transaction_flags := 0;
 urb.buffer_off := ofs(buffer);
 urb.buffer_seg := seg(buffer);
 urb.buffer_length := packetlen;
 urb.actual_length := 64;
 urb.setup_buffer_off := 0;
 urb.setup_buffer_seg := 0;
 urb.start_frame := 0;
 urb.nr_of_packets := 0;
 urb.int_interval := 0;
 urb.error_count := 0;
 urb.timeout := 0;
 urb.next_urb_off := 0;
 urb.next_urb_seg := 0;

 (* now call DosUHCI *)
 Reg.DS := seg(urb);
 Reg.DX := ofs(urb);
 Intr($65, Reg);

 WriteLn('After request nr.:', ReqNr:4, '  Error: ', urb.error_code);

 Inc(ReqNr);

End (* do_out *);

Label Suite;

Begin

{Write(SizeOf(urb));ReadLn;Halt;}

 ReqNr := 0;

 FillChar(buffer, SizeOf(buffer), #0);

{ (* Init for HP DeskJet 970 CXI *)
 bStr := #27+'E'+#27+'&l26A'+#27+'9'+#27+'&l0L'+#27+'(10U'+#27+'(s12V'+#27+'&l6D';
}

(* Reset printer *)
 bStr := #27+'E';
 (* Enable end of line wrap *)
 bStr := bStr+#27+'&s0C';
 (* select PC-8 symbol set *)
 bStr := bStr+#27+'(10U';
 (* select 10 pitch, 12 point, upright medium, courier font *)
 bStr := bStr+#27+'(s0p10h12v0s0b3T';

 packetlen := Length(bStr);
 Move(bStr[1], buffer, packetlen);

 do_out;

{
 (* Printing a line of text for test *)
 FillChar(buffer, SizeOf(buffer), #0);
 bStr := 'Hello world !'+#13+#10+#13+#10;
 packetlen := Length(bStr);
 Move(bStr[1], buffer, packetlen);
 do_out;

 (* Printing a line of text for test *)
 FillChar(buffer, SizeOf(buffer), #0);
 bStr := 'This is the first line of my text...'+#13+#10+#13+#10;
 packetlen := Length(bStr);
 move(bStr[1], buffer, packetlen);
 do_out;
}

(*
 Goto Suite;
*)

 (* open "dosuhci.txt" *)
 Assign(f, myFN);Reset(f, 1);
 If (IOResult = 0) Then
  Begin
   Repeat
    BlockRead(f, buffer, SizeOf(Buffer), packetlen);
    If (IOResult = 0) Then
     Begin
      If (packetlen = 0) then break (* eof *);
      FillChar(buffer[packetlen], SizeOf(buffer)-packetlen, #0);
      do_out;
     End
    Else Break;
   Until false;
   Close(f);
  End
 Else WriteLn('Cannot open ', '''myFN''', ' !');

Suite:

 FillChar(buffer, SizeOf(buffer), #0);
 (* 'RESET' *)
 bStr := #27 + 'E';
 packetlen := Length(bStr);
 Move(bStr[1], buffer, packetlen);
 do_out;

end (* HPLASER.PAS *).

