uses Dos;

{ This file has no copyright assigned and is placed in the Public Domain }

Type 
  URB_type = 
             packed Record
                      transaction_token : byte; {see token values above}
                      chain_end_flag  : byte; {1 = another URB follows this one in memory}
                      dev_add         : byte;
                      end_point       : byte;
                      error_code      : byte;
                      status          : byte; {returned by dosuhci}
                      transaction_flags : word; {reserved}
                      buffer_off      : word; {for in/out}
                      buffer_seg      : word; {for in/out}
                      buffer_length   : word; {for in/out}
                      actual_length   : word; {for in/out}
                      setup_buffer_off : word; {for control}
                      setup_buffer_seg : word; {for control}
                      start_frame     : word; {reserved}
                      nr_of_packets   : word; {reserved - iso}
                      int_interval    : byte; {reserved}
                      error_count     : byte; {reserved}
                      timeout         : word; {reserved}
                      next_urb_off    : word; {reserved}
                      next_urb_seg    : word; {reserved}
      End; {record, 32 bytes long}


SetupType = 
            packed Record
                     bmRequestType: byte;
                     bRequest     : byte;
                     wValue     : word;
                     wIndex       : word;
                     wLength      : word;
     End;



Pdevice_descriptor_type = ^Tdevice_descriptor_type;
Tdevice_descriptor_type = packed Record
                                   bLength  : byte;
                                   bDescriptorType : byte;
                                   bcdUSB  : word;
                                   bDeviceClass  : byte;
                                   bDeviceSubClass : byte;
                                   bDeviceProtocol : byte;
                                   bMaxPacketSize : byte;
                                   idVendor  : word;
                                   idProduct  : word;
                                   bcdDevice  : word;
                                   iManufacturer : byte;
                                   iProduct  : byte;
                                   iSerialNumber : byte;
                                   bNumConfigurations : byte;
   End;


Var 
  urb: urb_type;
  device_descriptor_ptr: Pdevice_descriptor_type;
  device_request: setuptype;
  inbuffer,inbuffer2: array[0..2027] Of char;
  devadd,a,b: byte;
  maxlen: integer;
  regs: registers;


Begin
{defint a-z}
  writeln(#13#10,'Device addresses defined by DOSUSB',#13#10);

  For devadd:=1 To 200 Do
    Begin
      FillChar(inbuffer,1024,0);  {return data here}
      FillChar(inbuffer,1024,0);  {return data here as well}



{do 8 byte device_descriptor to determine maxlen of packet device descriptor}
      device_request.bmRequestType := $80;
      device_request.bRequest := 6;
      device_request.wValue := $100;
      device_request.wIndex := 0;
      device_request.wLength := $8;

{set up device descriptor request}
      urb.transaction_token := $2D;
      urb.chain_end_flag := 0;
      urb.dev_add := devadd;
      urb.end_point := 0;
      urb.error_code := 0;
      urb.status := 0;
      urb.transaction_flags := 0;
      urb.buffer_off := ofs(inbuffer);
      urb.buffer_seg := seg(inbuffer);
      urb.buffer_length := 8;
      urb.actual_length := 8;
      urb.setup_buffer_off := ofs(device_request);
      urb.setup_buffer_seg := seg(device_request);
      urb.start_frame := 0;
      urb.nr_of_packets := 0;
      urb.int_interval := 0;
      urb.error_count := 0;
      urb.timeout := 0;
      urb.next_urb_off := 0;
      urb.next_urb_seg := 0;


      regs.AX := 0;
      regs.DS := seg(urb);
      regs.DX := ofs(urb);
      intr($65, regs);




{invalid device address?}
      If (urb.error_code<>1) And (urb.status<=1) Then
        Begin
   {now determine maxlen}
          device_descriptor_ptr := @inbuffer;
          maxlen := device_descriptor_ptr^.bMaxPacketSize;

{full device descriptor to see if string descriptors present}
          device_request.bmRequestType := $80;
          device_request.bRequest := 6;
          device_request.wValue := $100;
          device_request.wIndex := 0;
          device_request.wLength := $12; {'18 'hex 12}

{set up device descriptor request}
          urb.transaction_token := $2D;
          urb.chain_end_flag := 0;
          urb.dev_add := devadd;
          urb.end_point := 0;
          urb.error_code := 0;
          urb.status := 0;
          urb.transaction_flags := 0;
          urb.buffer_seg := seg(inbuffer);
          urb.buffer_off := ofs(inbuffer);
          urb.buffer_length := 18;
          urb.actual_length := maxlen;
          urb.setup_buffer_seg := seg(device_request);
          urb.setup_buffer_off := ofs(device_request);
          urb.start_frame := 0;
          urb.nr_of_packets := 0;
          urb.int_interval := 0;
          urb.error_count := 0;
          urb.timeout := 0;
          urb.next_urb_seg := 0;
          urb.next_urb_off := 0;


          regs.AX := 0;
          regs.DS := seg(urb);
          regs.DX := ofs(urb);
          intr($65, regs);


          device_descriptor_ptr := @inbuffer;

{don't care for unicode - shows text ok}
{retrieve string descriptors}

          writeln('Device address: ',devadd);

          If device_descriptor_ptr^.iProduct > 0 Then
            Begin
   {get string descriptor}
              device_request.bmRequestType := $80;
              device_request.bRequest := $06;
              device_request.wValue := $300+device_descriptor_ptr^.iProduct;
              device_request.wIndex := $409;
              device_request.wLength := $DF;

{set up request}
              urb.transaction_token := $2D;
              urb.chain_end_flag := 0;
              urb.dev_add := devadd;
              urb.end_point := 0;
              urb.error_code := 0;
              urb.status := 0;
              urb.transaction_flags := 0;
              urb.buffer_seg := seg(inbuffer2);
              urb.buffer_off := ofs(inbuffer2);
              urb.buffer_length := $DF;
              urb.actual_length := maxlen;
              urb.setup_buffer_seg := seg(device_request);
              urb.setup_buffer_off := ofs(device_request);
              urb.start_frame := 0;
              urb.nr_of_packets := 0;
              urb.int_interval := 0;
              urb.error_count := 0;
              urb.timeout := 0;
              urb.next_urb_seg := 0;
              urb.next_urb_off := 0;


              regs.AX := 0;
              regs.DS := seg(urb);
              regs.DX := ofs(urb);
              intr($65, regs);

              write('Product: ');
              a := byte(inbuffer2[0]);
              For b:=2 To 2+a-1 Do
                write(inbuffer2[b]);
              writeln(#13#10);
            End;

        End;
    End;

End.
